<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Group class.
*
*	$Header: /cvsroot/wikindx/wikindx3/core/group/GROUP.php,v 1.8 2005/05/03 00:04:24 sirfragalot Exp $
*****/
class GROUP
{
// Constructor
	function GROUP($db)
	{
		$this->db = $db;
	}
// Get category names from WKX_category.  Return associative array of id => category.
	function grabAll()
	{
		include_once("core/html/HTML.php");
		$html = new HTML();
		$recordset = $this->db->select(array("WKX_category"), array("id", "category"), 
			'ORDER BY ' . $this->db->tidyInputClause('category'));
		while($row = $this->db->loopRecordSet($recordset))
			$groups[$row['id']] = $html->dbToFormTidy($row['category']);
		if(isset($groups))
			return $groups;
// shouldn't ever happen since 1 => 'General' should always be set.
		return FALSE;
	}
// return a SQL condition clause when selecting by category
	function selectCondition($input)
	{
		$condition = '';
		$selectArray = explode(",", $input['category']);
		foreach($selectArray as $key => $value)
			$conditionArray[] = "FIND_IN_SET(" . $this->db->tidyInput($value) . ", " . 
			$this->db->formatfield('categories') . ")";
		$condition .= implode(" " . $input['categoryMethod'] . " ", $conditionArray);
		return $condition;
	}
// Update $input to category table.  If category ID exists, update category name otherwise do nothing.
// $input is id => groupName
	function updateSql($input)
	{
		$recordset = $this->db->select(array("WKX_category"), array("id", "category"));
		while($row = $this->db->loopRecordSet($recordset))
		{
			if(array_key_exists($row['id'], $input))
			{
				$update['category'] = $input[$row['id']];
				$this->db->update('WKX_category', $update, 
				"WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($row['id']));
				unset($input[$row['id']]);
			}
		}
		return TRUE;
	}
// Add a new category to the category table
	function addSql($category)
	{
// database match is case insensitive.
		$recordset = $this->db->select(array("WKX_category"), array("id"), 
			"WHERE " . $this->db->formatField('category') . "=" . $this->db->tidyInput($category));
// If category already exists quietly return without error.
		if($id = $this->db->fetchOne($recordset))
			return $id;
		$this->db->insert("WKX_category", array('category'), array($category));
		return TRUE;
	}
// Delete category(s) from category table.  $input is array of ids in WKX_category.
// 'General' category always has id 1.
	function deleteSql($input)
	{
// Grab info from WKX_resource_category table and store those resources that require updating.....
		$condition = " WHERE ";
		foreach($input as $value)
			$conditionArray[] = "FIND_IN_SET(" . $this->db->tidyInput($value) . ", " . 
			$this->db->formatField('categories') . ")";
		$condition .= implode(" OR ", $conditionArray);
		$recordset = $this->db->select(array("WKX_resource_category"), array("id", "categories"), $condition);
		while($row = $this->db->loopRecordSet($recordset))
		{
// Resource belongs to just this category so place in the 'General' category
			if(array_key_exists($row['categories'], $input))
			{
				$this->db->update('WKX_resource_category', array("categories" => 1), 
					"WHERE " . $this->db->formatfield('id') . "=" . 
					$this->db->tidyInput($row['id']));
				continue;
			}
// In the comma-delimited list of $input, exists a deleted category?  If so, update with reduced category list
			$list = explode(",", $row['categories']);
			foreach($input as $value)
			{
				if($key = array_search($value, $list))
					unset($list[$key]);
			}
// just in case...
			if(empty($list))
				$list[] = 1;
			else
				$list = implode(",", $list);
			$this->db->update('WKX_resource_category', array("categories" => $list, 
				"WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($row['id'])));
		}
// Finally delete categories and optimize table
		foreach($input as $value)
			$this->db->delete('WKX_category', "WHERE " . $this->db->formatfield('id') . "=" . 
				$this->db->tidyInput($value));
		$this->db->optimize('WKX_category');
		return TRUE;
	}
}
?>
