<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* FRONT class
*
* Front page of the system.
*****/
class FRONT
{
// Constructor
	function FRONT($db)
	{
		$this->db = $db;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// Display front page information.  If $noMenu, display WIKINDX submenu links
	function display($noMenu = FALSE)
	{
		include_once("core/html/HTML.php");
		include_once("core/html/MISC.php");
		include_once("core/messages/MESSAGES.php");
		$html = new HTML();

		$this->template->setVar('heading', 'WIKINDX');
		$recordset = $this->db->select(array('WKX_config'), array("description", "contactEmail"));
		$row = $this->db->fetchRow($recordset);
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('wikindx');
			$this->template->setVar('noMenu', $pString);
		}
		$this->template->setVar('body', $html->dbToHtmlTidy($row['description']));
		if($row['contactEmail'])
		{
			$email = $html->dbToHtmlTidy($row['contactEmail']);
			$email = MISC::a("link", $email, "mailto:$email");
			$this->template->setVar('contact', $email);
		}
		return $this->template->process();
	}
}
?>
