<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	ENDNOTEIMPORTSTAGE1: Endnote XML STAGE1 import class
*
*	$Header: /cvsroot/wikindx/wikindx3/core/file/import/ENDNOTEIMPORTSTAGE1.php,v 1.2 2005/04/21 03:54:15 sirfragalot Exp $
*****/
class ENDNOTEIMPORTSTAGE1
{
// Constructor
	function ENDNOTEIMPORTSTAGE1($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/file/BIBTEXCONFIG.php");
		$this->config = new BIBTEXCONFIG();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/group/GROUP.php");
		$this->group = new GROUP($this->db);
		include_once("core/file/TAG.php");
		$this->tag = new TAG($this->db);
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
	}
	function init($message = FALSE)
	{
// Load config arrays
		$this->config->bibtex();
// Load groups
		$groups = $this->group->grabAll();
// Load tags
		$tags = $this->tag->grabAll();
		
		$pString = $message ? $message : FALSE;
		$pString .= MISC::p($this->messages->text("import", "warning"));
		$pString .= MISC::p($this->messages->text("import", "introEndnote"));
//		$pString .= FORM::formMultiHeader("importBibtexStage2");
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(FORM::textInput($this->messages->text("import", "tag"), 
			"import_tag", FALSE, 50, 255), FALSE, "", "bottom");
		if($tags)
		{
// add 0 => IGNORE to creators array
			$temp[0] = $this->messages->text("misc", "ignore");
			foreach($tags as $key => $value)
				$temp[$key] = $value;
			$tags = $temp;
			$sessionTag = $this->session->issetVar('import_tagId') ? 
				$this->session->getVar('import_tagId') : FALSE;
			if($sessionTag)
				$element = FORM::selectedBoxValue(FALSE, 'import_tagId', $tags, 5);
			else
				$element = FORM::selectFBoxValue(FALSE, 'import_tagId', $tags, 5);
			$pString .= TABLE::td($element);
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "");
		$pString .= TABLE::trStart();
		$groupTd = FALSE;
		if(sizeof($groups) > 1)
		{
			$td = MISC::p($this->messages->text("import", "categoryPrompt"));
			if($sessionGroups = $this->session->getVar('import_groups'))
			{
				$sGroups = explode(",", $sessionGroups);
				$element = FORM::selectedBoxValueMultiple($this->messages->text("import", 
					"category"), 'import_groups', $groups, $sGroups, 5);
			}
			else
				$element = FORM::selectFBoxValueMultiple($this->messages->text("import", 
					"category"), 'import_groups', $groups, 5);
			$pString .= TABLE::td($td . $element . MISC::br() . $this->messages->text("hint", "multiples"));
			$groupTd = TRUE;
		}
		$pString .= TABLE::td(FORM::fileUpload($this->messages->text("import", "file"), 
			"import_file", 30), FALSE, "left", "bottom");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		if($groupTd)
			$pString .= TABLE::td("&nbsp;");
		$pString .= TABLE::td($this->messages->text("import", "importDuplicates") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, 'import_importDuplicates'), FALSE, "left", "bottom");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->messages->text("import", "storeRawEndnote"), FALSE, "left", "bottom");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->messages->text("import", "storeRawLabel") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, 'import_raw'), FALSE, "right");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit(), FALSE, "right");
//		$pString .= FORM::formEnd();
		return $pString;
	}
}
?>
