<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	ENDNOTEDATEPARSE: Endnote date import class
*
* Endnote field can come in as:
* September 11
* September 11th
* 11th September
* 11 Sept.
* 11th. Sept
* etc. etc. etc. as there's no control over the format.  We'll try our best...
*****/
class ENDNOTEDATEPARSE
{
// Constructor
	function ENDNOTEDATEPARSE()
	{
// need to use English constants
		include_once("languages/en/CONSTANTS.php");
		$this->constants = new CONSTANTS_en();
		$this->monthMatch = "/(jan|feb|mar|apr|jun|jul|aug|sep|oct|nov|dec)/i";
	}
	function init($dateField)
	{
		$day = $month = $year = FALSE;
		$date = split(" ", $dateField);
		foreach($date as $d)
		{
// Try for month first
			if(!$month)
				$month = $this->parseMonth($d);
// Year
			if(!$year)
				$year = $this->parseYear($d);
// Day
			if(!$day)
				$day = $this->parseDay($d);
		}
		return array($month, $day, $year);
	}
// extract day of month from field
	function parseDay($d)
	{
		if(preg_match("/([0-9]+)/", $d, $matches))
			return $matches[1];
		return FALSE;
	}
// extract month
	function parseMonth($d)
	{
		if(preg_match($this->monthMatch, $d, $matches))
		{
			if($month = array_search(ucfirst($matches[1]), $this->constants->monthToShortName()))
				return $month;
		}
		return FALSE;
	}
// extract year
	function parseYear($d)
	{
		if(preg_match("/(\d{4,4})/", $d, $matches))
			return $matches[1];
		return FALSE;
	}
}
?>
