<?php
/*
Released through http://bibliophile.sourceforge.net under the GPL licence.
Do whatever you like with this -- some credit to the author(s) would be appreciated.

A collection of PHP classes to manipulate bibtex files.

If you make improvements, please consider contacting the administrators at bibliophile.sourceforge.net so that your improvements can be added to the release package.

Mark Grimshaw 2004
http://bibliophile.sourceforge.net
Modified 17/March/2005 Mark Grimshaw for Endnote XML author formats...
*/

class ENDNOTECREATORPARSE
{
	function ENDNOTECREATORPARSE()
	{
	}
// Create writer arrays from endnote input.
// 'author field can be:
//	Grimshaw, Mark N.
//	Smith, Alfred, Jr.
//	Fisher, J.O.
//	J O Fisher
//	Mark M N G Grimshaw
//	Mark N. Grimshaw
// The delimiter WIKINDX inserts for XML multiple authors is ' and '
	function parse($input)
	{
		$input = trim($input);
// split on ' and ' 
		$authorArray = preg_split("/\s(and)\s/i", $input);
// check if there's anything that looks like et. al
		foreach($authorArray as $value)
		{
			$appellation = $prefix = $surname = $firstname = $initials = '';
			$author = explode(",", preg_replace("/\s{2,}/", ' ', trim($value)));
			$size = sizeof($author);
// No commas therefore something like Mark Grimshaw, Mark Nicholas Grimshaw, M N Grimshaw, Mark N. Grimshaw
			if($size == 1)
			{
				$author = split(" ", $value);
// last of array is surname (no prefix if entered correctly)
				$surname = array_pop($author);
			}
// Something like Grimshaw, Mark or Grimshaw, Mark Nicholas  or Grimshaw, M N or Grimshaw, Mark N.
			else if($size == 2)
			{
// first of array is surname (perhaps with prefix)
				list($surname, $prefix) = $this->grabSurname(array_shift($author));
			}
// If $size is > 2, we're looking at something like Bush, George W, III
			else
			{
// last of array is 'Jr.', 'IV' etc.
				$appellation = array_pop($author);
// first of array is surname (perhaps with prefix)
				list($surname, $prefix) = $this->grabSurname(array_shift($author));
			}
			$remainder = join(" ", $author);
			list($firstname, $initials) = $this->grabFirstnameInitials($remainder);
			$surname = $surname . ' ' . $appellation;
			$creators[] = array("$firstname", "$initials", "$surname", "$prefix");
		}
		if(isset($creators))
			return $creators;
		return FALSE;
	}
// grab firstname and initials which may be of form "A.B.C." or "A. B. C. " or " A B C " etc.
	function grabFirstnameInitials($remainder)
	{
		$firstname = $initials = '';
		$array = split(" ", $remainder);
		foreach($array as $value)
		{
			if(preg_match("/[a-zA-Z]{2,}/", trim($value)))
				$firstnameArray[] = trim($value);
			else
				$initialsArray[] = str_replace(".", " ", trim($value));
		}
		if(isset($initialsArray))
		{
			foreach($initialsArray as $initial)
				$initials .= ' ' . trim($initial);
		}
		if(isset($firstnameArray))
			$firstname = join(" ", $firstnameArray);
		return array($firstname, $initials);
	}
// surname may have title such as 'den', 'von', 'de la' etc. - characterised by first character lowercased
	function grabSurname($input)
	{
		$surnameArray = split(" ", $input);
		foreach($surnameArray as $value)
		{
			$firstChar = substr($value, 0, 1);
			if((ord($firstChar) >= 97) && (ord($firstChar) <= 122))
				$prefix[] = $value;
			else
				$surname[] = $value;
		}
		$surname = join(" ", $surname);
		if(isset($prefix))
		{
			$prefix = join(" ", $prefix);
			return array($surname, $prefix);
		}
		return array($surname, FALSE);
	}
}
?>
