<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BIBTEXPAGEPARSE: BibTeX PAGES import class
*****/
class BIBTEXPAGEPARSE
{
// Constructor
	function BIBTEXPAGEPARSE()
	{
	}
// Create page arrays from bibtex input.
// 'page field can be:
//	"77--99"
//	"3 - 5"
//	"ix -- 101"
//	"73+"
//	73, 89,103"
// Currently, WIKINDX will take 1/, 2/ and 3/ above as page_start and page_end and, in the other cases, will accept
// the first valid number it finds from the left as page_start setting page_end to NULL
	function init($item)
	{
		$item = trim($item);
// Remove any enclosing double quotes or braces around entry field values
//		if(preg_match("/^[\"{](.*)[\"}]$/", $item, $matches))
//			$item = $matches[1];
		if($this->type1($item))
			return $this->return;
// else, return first number we can find
		if(preg_match("/(\d+|[ivx]+)/i", $item, $array))
			return array($array[1], FALSE);
// No valid page numbers found
		return array(FALSE, FALSE);;
	}
// "77--99" or '-'type?
	function type1($item)
	{
		$start = $end = FALSE;
		$array = preg_split("/--|-/", $item);
		if(sizeof($array) > 1)
		{
			if(is_numeric(trim($array[0])))
				$start = trim($array[0]);
			else
				$start = strtolower(trim($array[0]));
			if(is_numeric(trim($array[1])))
				$end = trim($array[1]);
			else
				$end = strtolower(trim($array[1]));
			if($end && !$start)
				$this->return = array($end, $start);
			else
				$this->return = array($start, $end);
			return TRUE;
		}
		return FALSE;
	}
}
?>
