<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BIBTEXMONTHPARSE: BibTeX MONTH import class
*
* BibTeX month field can come in as:
* jan
* "8~" # jan
* jan#"~8"
*
* where # is concatenation and '~' can be any non-numeric character. The number must be extracted for use in the WIKINDX 'day' field.
*
* Entries of type jun # "-" # aug are reduced to just the first month.
*****/
class BIBTEXMONTHPARSE
{
// Constructor
	function BIBTEXMONTHPARSE()
	{
	}
	function init($monthField)
	{
// need to use English constants for BibTeX
		include_once("languages/en/CONSTANTS.php");
		$constants = new CONSTANTS_en();
		$startMonth = $this->startDay = $endMonth = $this->endDay = FALSE;
		$date = split(" ", $monthField); // ' # ' has been replaced by ' ' in PARSEBIBTEX.php
		foreach($date as $field)
		{
			$field = ucfirst(strtolower(trim($field)));
			if($month = array_search($field, $constants->monthToLongName()))
			{
				if(!$startMonth)
					$startMonth = $month;
				else
					$endMonth = $month;
				continue;
			}
			else if($month = array_search($field, $constants->monthToShortName()))
			{
				if(!$startMonth)
					$startMonth = $month;
				else
					$endMonth = $month;
				continue;
			}
			$this->parseDay($field);
		}
		if($this->endDay && !$endMonth)
			$endMonth = $startMonth;
		return array($startMonth, $this->startDay, $endMonth, $this->endDay);
	}
// extract day of month from field
	function parseDay($dayField)
	{
		preg_match("/([0-9]+).*([0-9]+)|([0-9]+)/", $dayField, $array);
		if(array_key_exists(3, $array))
		{
			if(!$this->startDay)
				$this->startDay = $array[3];
			else if(!$this->endDay)
				$this->endDay = $array[3];
		}
		else
		{
			if(array_key_exists(1, $array))
				$this->startDay = $array[1];
			if(array_key_exists(2, $array))
				$this->endDay = $array[2];
		}
	}
}
?>
