<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BIBTEXIMPORT BibTeX bibliography class.
*
*	$Header: /cvsroot/wikindx/wikindx3/core/file/import/BIBTEXIMPORT.php,v 1.5 2005/04/03 04:47:05 sirfragalot Exp $
*****/
class BIBTEXIMPORT
{
// Constructor
	function BIBTEXIMPORT($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// First check we are superadmin or are simply cut 'n' pasting bibtex
	function gatekeep($function)
	{
		if(!$this->session->getVar("setup_superadmin") && ((!$this->session->getVar("setup_write") && 
			($function == 'resourcePasteBibtex'))))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			if($pString = $authorize->initLogon())
				return $pString;
		}
		$this->template->setVar('heading', $this->messages->text("heading", "bibtexImport"));
		if($function == 'importBibtexStage1')
		{
			include_once("core/file/import/BIBTEXIMPORTSTAGE1.php");
			$stage = new BIBTEXIMPORTSTAGE1($this->db, $this->vars);
			$this->session->setVar('importLock', FALSE);
			$this->session->clearArray("import");
			$this->template->setVar('formStart', FORM::formMultiHeader("importBibtexStage2"));
			$this->template->setVar('body', $stage->init(FALSE));
			$this->template->setVar('formEnd', FORM::formEnd());
		}
		else if($function == 'resourcePasteBibtex')
		{
			include_once("core/file/import/BIBTEXIMPORTSTAGE1.php");
			$stage = new BIBTEXIMPORTSTAGE1($this->db, $this->vars);
			$this->session->setVar('importLock', FALSE);
			$this->session->clearArray("import");
			$this->template->setVar('formStart', FORM::formHeader("resourcePasteBibtexStage2"));
			$this->template->setVar('body', $stage->init(TRUE));
			$this->template->setVar('formEnd', FORM::formEnd());
		}
		else if($function == 'importBibtexStage2')
		{
			include_once("core/file/import/BIBTEXIMPORTSTAGE2.php");
			$stage = new BIBTEXIMPORTSTAGE2($this->db, $this->vars);
			$this->template->setVar('body', $stage->init(FALSE));
		}
		else if($function == 'resourcePasteBibtexStage2')
		{
			include_once("core/file/import/BIBTEXIMPORTSTAGE2.php");
			$stage = new BIBTEXIMPORTSTAGE2($this->db, $this->vars);
			$this->template->setVar('body', $stage->init(TRUE));
		}
		return $this->template->process();
	}
}
?>
