<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	RTF class
*****/
class RTF
{
// Constructor
	function RTF($db, $vars = FALSE)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/file/FILE.php");
		$this->file = new FILE($this->db);
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/cite/CITEFORMAT.php");
		$this->cite = new CITEFORMAT($this->db, $this->vars, 'rtf');
		include_once("core/file/export/EXPORTCOMMON.php");
		$this->common = new EXPORTCOMMON($this->db);
		include_once("core/user/USER.php");
		$this->user = new USER($this->db);
		$this->pString = '';
		$this->fontSizes = array(
					8, 10, 12, 14, 16, 18, 20, 22,
				);
		$this->fonts = array(
					"Arial",
					"Courier",
					"Georgia",
					"Helvetica",
					"MS Sans Serif",
					"MS Serif",
					"Palatino",
					"Tahoma",
					"Trebuchet MS",
					"Times New Roman",
					"Verdana",
				);
		$this->ubi = array(
					"Normal",
					"Italics",
					"Bold",
					"Underline",
				);
		$this->ubiBib = array(
					"Normal",
					"Bold",
				);
		$this->indentTabs = array(0, 1, 2, 3);
		$this->cr = array(1, 2, 3, 4);
		$this->dividerCR = array(0, 1, 2, 3, 4);
// Perform some system admin
		$this->file->tidyFiles();
	}
// Display RTF export and format options
	function setup()
	{
		include_once("core/html/FORM.php");
		include_once("core/html/MISC.php");
		$this->template->setVar('heading', $this->messages->text("heading", "exportRtf"));
// Check we have a list to export
		if(!$sql = $this->session->getVar('sql_stmt'))
			$this->failure($this->errors->text("file", "noSql"));
// load the session
		$sessionVars = $this->session->getArray("exportRtf");
		$this->template->setVar('formStart', FORM::formHeader("exportRtf"));
		$checked = $this->session->issetVar("exportRtf_bibliography") ? 'CHECKED' : FALSE;
		$pString = $this->makeForm($checked, "bibliography", "bibliography");
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$checked = $this->session->issetVar("exportRtf_abstract") ? 'CHECKED' : FALSE;
		$pString .= $this->makeForm($checked, "abstract", "abstract");
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$checked = $this->session->issetVar("exportRtf_notes") ? 'CHECKED' : FALSE;
		$pString .= $this->makeForm($checked, "notes", "notes");
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$selected = $this->session->getVar("exportRtf_metadata");
		$metadata = array(0 => $this->messages->text("exportRtf", "metadataAll"), 
			1 => $this->messages->text("exportRtf", "metadataUser"));
		if($selected)
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "metadata"), "exportRtf_metadata", 
			$metadata, $selected, 2));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "metadata"), "exportRtf_metadata", 
			$metadata, 2));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$checked = $this->session->issetVar("exportRtf_quotes") ? 'CHECKED' : FALSE;
		$pString .= $this->makeForm($checked, "quotes", "quotes", TRUE);
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$checked = $this->session->issetVar("exportRtf_paraphrases") ? 'CHECKED' : FALSE;
		$pString .= $this->makeForm($checked, "paraphrases", "paraphrases", TRUE);
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$checked = $this->session->issetVar("exportRtf_musings") ? 'CHECKED' : FALSE;
		$pString .= $this->makeForm($checked, "musings", "musings");
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
// Entry divider
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if($selected = trim($this->session->getVar("exportRtf_divider")))
			$pString .= TABLE::td(FORM::textInput($this->messages->text("exportRtf", "divider"), 
				"exportRtf_divider", $selected, 75, 75));
		else
			$pString .= TABLE::td(FORM::textInput($this->messages->text("exportRtf", "divider"), 
				"exportRtf_divider", FALSE, 75, 75));
// Divider Font
		if($selected = $this->session->getVar("exportRtf_dividerFont"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "font"), "exportRtf_dividerFont", $this->fonts, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "font"), "exportRtf_dividerFont", $this->fonts, 3));
// Divider Font Size
		if($selected = $this->session->getVar("exportRtf_dividerFontSize"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "fontSize"), "exportRtf_dividerFontSize", 
			$this->fontSizes, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "fontSize"), "exportRtf_dividerFontSize", $this->fontSizes, 3));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if($selected = $this->session->getVar("exportRtf_dividerCR"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "dividerCR"), "exportRtf_dividerCR", $this->dividerCR, 
			$selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "dividerCR"), "exportRtf_dividerCR", $this->dividerCR, 3));
// preferences
		include_once("core/styles/LOADSTYLE.php");
		$styles = LOADSTYLE::loadDir("styles/bibliography");
		if($selected = $this->session->getVar("exportRtf_style"))
			$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("config", "style"), 
				"exportRtf_style", $styles, $this->session->getVar("exportRtf_style"), 4));
		else
			$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("config", "style"), "exportRtf_style", 
				$styles, $this->session->getVar("setup_style"), 4));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// make a form subset for setup()
	function makeForm($checked, $session, $text, $comments = FALSE)
	{
		$pString = TABLE::tableStart();
		$pString .= TABLE::trStart();
		$temp = MISC::b($this->messages->text("exportRtf", $text)) . "&nbsp;" . 
			FORM::checkbox(FALSE, "exportRtf_" . $text, $checked);
		if($session != 'bibliography')
		{
			if($selected = trim($this->session->getVar("exportRtf_" . $session . "Tag")))
				$temp .= MISC::br() . FORM::textInput($this->messages->text("exportRtf", "tag"), 
					"exportRtf_" . $session . "Tag", $selected, 15, 50);
			else
				$temp .= MISC::br() . FORM::textInput($this->messages->text("exportRtf", "tag"), 
					"exportRtf_" . $session . "Tag", FALSE, 15, 50);
		}
		$pString .= TABLE::td($temp);
		if($comments)
		{
			$checkedC = $this->session->issetVar("exportRtf_" . $session . "Comments") ? 'CHECKED' : FALSE;
			$temp = $this->messages->text("exportRtf", "comments") . "&nbsp;" . 
				FORM::checkbox(FALSE, "exportRtf_" . $text . "Comments", $checkedC);
			if($selected = trim($this->session->getVar("exportRtf_" . $session . "CommentsTag")))
				$temp .= MISC::br() . FORM::textInput($this->messages->text("exportRtf", "tag"), 
					"exportRtf_" . $session . "CommentsTag", $selected, 15, 50);
			else
				$temp .= MISC::br() . FORM::textInput($this->messages->text("exportRtf", "tag"), 
					"exportRtf_" . $session . "CommentsTag", FALSE, 15, 50);
			$pString .= TABLE::td($temp);
		}
// Font
		if($selected = $this->session->getVar("exportRtf_" . $session . "Font"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "font"), "exportRtf_" . $session . "Font", 
				$this->fonts, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "font"), "exportRtf_" . $session . "Font", $this->fonts, 3));
// Font Size
		if($selected = $this->session->getVar("exportRtf_" . $session . "FontSize"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "fontSize"), "exportRtf_" . $session . "FontSize", 
			$this->fontSizes, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "fontSize"), "exportRtf_" . $session . "FontSize", 
				$this->fontSizes, 3));
// Underline, Italics, Bold, Normal
		if($session != 'bibliography')
		{
			if($selected = $this->session->getVar("exportRtf_" . $session . "TextFormat"))
				$pString .= TABLE::td(FORM::selectedBoxValue(
				$this->messages->text("exportRtf", "textFormat"), "exportRtf_" . $session . "TextFormat", 
				$this->ubi, $selected, 3));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(
					$this->messages->text("exportRtf", "textFormat"), "exportRtf_" . $session . "TextFormat", 
					$this->ubi, 3));
		}
		else
		{
			if($selected = $this->session->getVar("exportRtf_bibliographyTextFormat"))
				$pString .= TABLE::td(FORM::selectedBoxValue(
					$this->messages->text("exportRtf", "textFormat"), "exportRtf_bibliographyTextFormat", 
					$this->ubiBib, $selected, 2));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(
					$this->messages->text("exportRtf", "textFormat"), "exportRtf_bibliographyTextFormat", 
					$this->ubiBib, 2));
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
// Left Indent
		if($selected = $this->session->getVar("exportRtf_" . $session . "IndentL"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "indentL"), "exportRtf_" . $session . "IndentL", 
			$this->indentTabs, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "indentL"), "exportRtf_" . $session . "IndentL", 
			$this->indentTabs, 3));
// Right Indent
		if($selected = $this->session->getVar("exportRtf_" . $session . "IndentR"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "indentR"), "exportRtf_" . $session . "IndentR", 
			$this->indentTabs, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "indentR"), "exportRtf_" . $session . "IndentR", 
			$this->indentTabs, 3));
		if(($session == 'musings') || ($session == 'quotes') || ($session == 'paraphrases'))
		{
// Carriage Returns between parts of element
			if($selected = $this->session->getVar("exportRtf_" . $session . "CR"))
				$pString .= TABLE::td(FORM::selectedBoxValue(
				$this->messages->text("exportRtf", "crBetween"), "exportRtf_" . $session . "CrBetween", 
				$this->indentTabs, $selected, 3));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(
				$this->messages->text("exportRtf", "crBetween"), "exportRtf_" . $session . "CrBetween", 
				$this->cr, 3));
		}
// Carriage Returns after element
		if($selected = $this->session->getVar("exportRtf_" . $session . "CR"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("exportRtf", "crFollowing"), "exportRtf_" . $session . "CrFollowing", 
			$this->indentTabs, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("exportRtf", "crFollowing"), "exportRtf_" . $session . "CrFollowing", 
			$this->cr, 3));
// ISBN
		if($session == 'bibliography')
		{
			$checkedC = $this->session->issetVar("exportRtf_bibliographyIsbn") ? 'CHECKED' : FALSE;
			$pString .= TABLE::td($this->messages->text("exportRtf", "isbn") . "&nbsp;" . 
				FORM::checkbox(FALSE, "exportRtf_bibliographyIsbn", $checkedC));
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// RTF header
	function rtfHeader()
	{
		$this->pString .= "{\\rtf1\\ansi\\deff0\n\n";
	}
// RTF Footer
	function rtfFooter()
	{
		$this->pString .= "\\qj\\li0\\ri0\n\\par\n\n}";
	}
// RTF header fontBlocks
	function rtfFontBlock($type, $font, $fontSize, $indentL, $indentR, $crFollowing, $crBetween = FALSE, $textFormat = 'Normal')
	{
		if(!isset($this->fontBlockIndex))
			$this->fontBlockIndex = 0;
		$this->pString .= "{\\f" . $this->fontBlockIndex . "\\fcharset0 $font;}\n";
		$this->fontBlocks[$type]['fontBlock'] = "\\f" . $this->fontBlockIndex;
// Actual font size seems to be half this value and rounded up to an even number
		$this->fontBlocks[$type]['fontSize'] = "\\fs" . $fontSize * 2;
// Each TAB approximately = 720 (no idea what the units are)
		if($indentL)
			$this->fontBlocks[$type]['indentL'] = "\\li" . $indentL * 720;
		else
			$this->fontBlocks[$type]['indentL'] = "\\li0";
		if($indentR)
			$this->fontBlocks[$type]['indentR'] = "\\ri" . $indentR * 720;
		else
			$this->fontBlocks[$type]['indentR'] = "\\ri0";
		$this->fontBlocks[$type]['crFollowing'] = $crFollowing;
		if($crBetween)
			$this->fontBlocks[$type]['crBetween'] = $crBetween;
		if($textFormat != 'Normal')
			$this->fontBlocks[$type]['textFormat'] = $textFormat;
		$this->fontBlockIndex++;
	}
// RTF Paragraph block
	function rtfParagraphBlock($type)
	{
		if($type == 'divider')
			$pString = "{" . $this->fontBlocks[$type]['fontBlock'] . $this->fontBlocks[$type]['fontSize'];
		else
			$pString = "{" . $this->fontBlocks[$type]['fontBlock'] . $this->fontBlocks[$type]['fontSize'];
		if(array_key_exists('textFormat', $this->fontBlocks[$type]) && ($this->fontBlocks[$type]['textFormat'] == 'Italics'))
			$pString .= "\\i";
		else if(array_key_exists('textFormat', $this->fontBlocks[$type]) && 
			($this->fontBlocks[$type]['textFormat'] == 'Underline'))
			$pString .= "\\ul";
		if(array_key_exists('textFormat', $this->fontBlocks[$type]) && ($this->fontBlocks[$type]['textFormat'] == 'Bold'))
			$pString .= "\\b";
		$pString .= " ";
		return $pString;
	}
// make RTF fontBlocks according to input
	function makeFontBlocks()
	{
		$sqlSelectReplace = "SELECT ";
		$sqlJoinReplace = "FROM WKX_resource ";
		$replace = FALSE;
		$this->pString .= "{\\fonttbl\n";
		if(array_key_exists("divider", $this->input))
		{
			$this->rtfFontBlock("divider", $this->fonts[$this->input['dividerFont']], 
				$this->fontSizes[$this->input['dividerFontSize']], 
				FALSE, FALSE, 0);
		}
		if(array_key_exists("bibliography", $this->input))
		{
			$this->rtfFontBlock("bibliography", $this->fonts[$this->input['bibliographyFont']], 
				$this->fontSizes[$this->input['bibliographyFontSize']], 
				$this->indentTabs[$this->input['bibliographyIndentL']],
				$this->indentTabs[$this->input['bibliographyIndentR']],
				$this->cr[$this->input['bibliographyCrFollowing']],
				FALSE, 
				$this->ubiBib[$this->input['bibliographyTextFormat']]);
		}
		if(array_key_exists("abstract", $this->input))
		{
			$this->rtfFontBlock("abstract", $this->fonts[$this->input['abstractFont']], 
				$this->fontSizes[$this->input['abstractFontSize']],
				$this->indentTabs[$this->input['abstractIndentL']],
				$this->indentTabs[$this->input['abstractIndentR']],
				$this->cr[$this->input['abstractCrFollowing']],
				FALSE, 
				$this->ubi[$this->input['abstractTextFormat']]);
			$sqlSelectReplace .= $this->db->formatField('abstract') . ", ";
// Select and Search operations already have WKX_abstract as part of SQL statement - need to add to list operations
			if(($this->session->getVar('sql_lastMulti') == 'list') || 
				($this->session->getVar('sql_lastMulti') == 'listKeyword') ||
				($this->session->getVar('sql_lastMulti') == 'listCite'))
				$sqlJoinReplace .= " LEFT JOIN " . $this->db->formatTable('WKX_resource_abstract') . 
					" ON " . $this->db->formatField('WKX_resource_abstract.id') . " = " . 
					$this->db->formatField('WKX_resource.id');
			$replace = TRUE;
		}
		if(array_key_exists("notes", $this->input))
		{
			$this->rtfFontBlock("notes", $this->fonts[$this->input['notesFont']], 
				$this->fontSizes[$this->input['notesFontSize']],
				$this->indentTabs[$this->input['notesIndentL']],
				$this->indentTabs[$this->input['notesIndentR']],
				$this->cr[$this->input['notesCrFollowing']],
				FALSE, 
				$this->ubi[$this->input['notesTextFormat']]);
			$sqlSelectReplace .= $this->db->formatAlias(array('WKX_resource_note.text' => 'notes')) . ", ";
			$replace = TRUE;
		}
		if(array_key_exists("quotes", $this->input))
			$this->rtfFontBlock("quotes", $this->fonts[$this->input['quotesFont']], 
				$this->fontSizes[$this->input['quotesFontSize']],
				$this->indentTabs[$this->input['quotesIndentL']],
				$this->indentTabs[$this->input['quotesIndentR']],
				$this->cr[$this->input['quotesCrFollowing']],
				$this->cr[$this->input['quotesCrBetween']],
				$this->ubi[$this->input['quotesTextFormat']]);
		if(array_key_exists("paraphrases", $this->input))
			$this->rtfFontBlock("paraphrases", $this->fonts[$this->input['paraphrasesFont']], 
				$this->fontSizes[$this->input['paraphrasesFontSize']],
				$this->indentTabs[$this->input['paraphrasesIndentL']],
				$this->indentTabs[$this->input['paraphrasesIndentR']],
				$this->cr[$this->input['paraphrasesCrFollowing']],
				$this->cr[$this->input['paraphrasesCrBetween']],
				$this->ubi[$this->input['paraphrasesTextFormat']]);
		if(array_key_exists("musings", $this->input))
			$this->rtfFontBlock("musings", $this->fonts[$this->input['musingsFont']], 
				$this->fontSizes[$this->input['musingsFontSize']],
				$this->indentTabs[$this->input['musingsIndentL']],
				$this->indentTabs[$this->input['musingsIndentR']],
				$this->cr[$this->input['musingsCrFollowing']],
				$this->cr[$this->input['musingsCrBetween']],
				$this->ubi[$this->input['musingsTextFormat']]);
		$this->pString .= "}\n\n";
		return array($replace, $sqlSelectReplace, $sqlJoinReplace);
	}
// encode paragraphs from HTML
	function paragraph($string)
	{
        	return preg_replace("/<\/ br>/i", "\\par\n", $string);
	}
// write $this->pString to file.  If file exists, it is written over.
	function process()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "exportRtf"));
		$this->input = $this->checkInput();
		$this->fontBlocks = array();
		$this->rtfHeader();
		$this->getData();
		$this->rtfFooter();
		if(!$fileName = $this->file->createFileName('.rtf'))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		if(!$fp = fopen("$fileName", "w"))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		if(!fputs($fp, $this->pString))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		fclose($fp);
		$pString = $this->common->listFiles();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// get data from database
	function getData()
	{
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "rtf");
		if(!$sql = $this->session->getVar('sql_stmt'))
			$this->failure($this->errors->text("file", "noSql"));
		$userId = $this->session->getVar("setup_userId");
		$sql = stripslashes($sql);
		list($replace, $sqlSelectReplace, $sqlJoinReplace) = $this->makeFontBlocks();
		if($replace)
		{
			$sql = str_replace("SELECT", $sqlSelectReplace, $sql);
			$sql = str_replace("FROM WKX_resource", $sqlJoinReplace, $sql);
		}
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$returnAfterBib = FALSE;
			if(array_key_exists('bibliography', $this->input))
			{
				$this->pString .= $this->makeBlock('bibliography');
				$this->pString .= $this->rtfParagraphBlock('bibliography');
				$this->pString .= $this->paragraph($this->utf8_2_unicode($bibStyle->process($row)));
				if(array_key_exists('bibliographyIsbn', $this->input) && ($row['isbn']))
					$this->pString .= "  [" . $row['isbn'] . "]";
				$this->pString .= " }\n";
				for($i = 0; $i < $this->fontBlocks['bibliography']['crFollowing']; $i++)
					$this->pString .= $this->makeParagraph('bibliography') . "\n";
				$returnAfterBib = TRUE;
			}
			if(array_key_exists('abstract', $this->input) && $row['abstract'])
			{
				$this->pString .= $this->makeBlock('abstract');
				if($row['abstract'])
				{
					if($returnAfterBib)
					{
						$this->pString .= $this->makeParagraph('bibliography') . "\n";
						$returnAfterBib = FALSE;
					}
					if(trim($this->input['abstractTag']))
					{
						$this->pString .= $this->rtfParagraphBlock('abstract');
						$this->pString .= $this->utf8_2_unicode(trim($this->input['abstractTag'])) . 
							" \\par }\n";
					}
					$this->pString .= $this->rtfParagraphBlock('abstract');
					$this->pString .= $this->utf8_2_unicode($this->textFormat($row['abstract'], 
						'abstract')) . "}";
					for($i = 0; $i < $this->fontBlocks['abstract']['crFollowing']; $i++)
						$this->pString .= $this->makeParagraph('abstract') . "\n";
				}
			}
			if(array_key_exists('notes', $this->input) && $row['notes'])
			{
				$this->pString .= $this->makeBlock('notes');
				if($row['notes'])
				{
					if($returnAfterBib)
					{
						$this->pString .= $this->makeParagraph('bibliography') . "\n";
						$returnAfterBib = FALSE;
					}
					if(trim($this->input['notesTag']))
					{
						$this->pString .= $this->rtfParagraphBlock('notes');
						$this->pString .= $this->utf8_2_unicode(trim($this->input['notesTag'])) . 
							" \\par }\n";
					}
					$this->pString .= $this->rtfParagraphBlock('notes');
					$this->pString .= $this->utf8_2_unicode($this->textFormat($row['notes'], 
						'notes')) . "}";
					for($i = 0; $i < $this->fontBlocks['notes']['crFollowing']; $i++)
						$this->pString .= $this->makeParagraph('notes') . "\n";
				}
			}
			if(array_key_exists('musings', $this->input))
			{
				$this->pString .= $this->makeBlock('musings');
				if($this->input['metadata'] == 1) // only my musings
					$recordset2 = $this->db->select(array('WKX_resource_musing'), 
						array('page_start', 'page_end', 'text', 'addUserIdMusing'), 
						" LEFT JOIN " . $this->db->formatTable('WKX_resource_musing_text') . 
						" ON " . 
						$this->db->formatfield("WKX_resource_musing.id") . "=" . 
						$this->db->formatfield("WKX_resource_musing_text.id") . 
						" WHERE " . $this->db->formatfield("WKX_resource_musing.resourceId") . "=" . 
						$this->db->tidyInput($row['resourceId']) . 
						" AND " . 
						$this->db->formatfield("WKX_resource_musing_text.addUserIdMusing") . "=" . 
						$this->db->tidyInput($userId) . 
						" ORDER BY " . $this->db->tidyInputClause('page_start'));
				else // my musings and all public musings
					$recordset2 = $this->db->select(array('WKX_resource_musing'), 
						array('page_start', 'page_end', 'text', 'addUserIdMusing'), 
						" LEFT JOIN " . $this->db->formatTable('WKX_resource_musing_text') . 
						" ON " . 
						$this->db->formatfield("WKX_resource_musing.id") . "=" . 
						$this->db->formatfield("WKX_resource_musing_text.id") . 
						" WHERE " . $this->db->formatfield("WKX_resource_musing.resourceId") . "=" . 
						$this->db->tidyInput($row['resourceId']) . 
						" AND (" . 
						$this->db->formatfield("WKX_resource_musing_text.addUserIdMusing") . "=" . 
						$this->db->tidyInput($userId) . 
						" OR " . 
						$this->db->formatfield("WKX_resource_musing_text.musingPrivate") . "=" . 
						$this->db->tidyInput('N') . 
						") ORDER BY " . $this->db->tidyInputClause('page_start'));
//					ORDER BY " . $this->db->tidyInputClause('page_start')) . " + 0";
				if($this->db->numRows($recordset2))
				{
					if($returnAfterBib)
					{
						$this->pString .= $this->makeParagraph('bibliography') . "\n";
						$returnAfterBib = FALSE;
					}
					if(trim($this->input['musingsTag']))
					{
						$this->pString .= $this->rtfParagraphBlock('musings');
						$this->pString .= $this->utf8_2_unicode(trim($this->input['musingsTag'])) . 
							" \\par }\n";
					}
					$numElements = 0;
					while($rowT = $this->db->loopRecordset($recordset2))
					{
						$page_start = $rowT['page_start'] ? "p." . $rowT['page_start'] : FALSE;
						$page_end = $rowT['page_end'] ? "-" . $rowT['page_end'] : FALSE;
						if($page_start && $page_end)
							$page_start = 'p' . $page_start;
						if($numElements)
							for($i = 0; $i < $this->fontBlocks['musings']['crBetween']; $i++)
								$this->pString .= $this->makeParagraph('musings') . "\n";
						$user = $this->user->displayUserAddEditPlain($rowT['addUserIdMusing']) . "\n";
						$this->pString .= $this->rtfParagraphBlock('musings');
						$this->pString .= $this->utf8_2_unicode($this->textFormat(
							$rowT['text'], 'musings')) . " $page_start$page_end ($user)\\par }";
						$numElements++;
					}
					for($i = 0; $i < $this->fontBlocks['musings']['crFollowing']; $i++)
						$this->pString .= $this->makeParagraph('musings') . "\n";
				}
			}
			if(array_key_exists('quotes', $this->input))
			{
				$this->pString .= $this->makeBlock('quotes');
				$recordset2 = $this->db->select(array('WKX_resource_quote'), 
						array(array('WKX_resource_quote.id' => 'quoteId'), 
							'page_start', 'page_end', 'text'), 
						" LEFT JOIN " . $this->db->formatTable('WKX_resource_quote_text') . 
						" ON " . $this->db->formatField("WKX_resource_quote.id") . "=" . 
						$this->db->formatField("WKX_resource_quote_text.id") . 
						" WHERE " . $this->db->formatField("WKX_resource_quote.resourceId") . "=" . 
						$this->db->tidyInput($row['resourceId']) . 
						" ORDER BY " . $this->db->tidyInputClause('page_start'));
//						ORDER BY " . $this->db->tidyInputClause('page_start')) . " + 0";
				if($this->db->numRows($recordset2))
				{
					if($returnAfterBib)
					{
						$this->pString .= $this->makeParagraph('bibliography') . "\n";
						$returnAfterBib = FALSE;
					}
					if(trim($this->input['quotesTag']))
					{
						$this->pString .= $this->rtfParagraphBlock('quotes');
						$this->pString .= $this->utf8_2_unicode(trim($this->input['quotesTag'])) . 
							" \\par }\n";
					}
					$numElements = 0;
					while($rowT = $this->db->loopRecordSet($recordset2))
					{
						$page_start = $rowT['page_start'] ? "p." . $rowT['page_start'] : FALSE;
						$page_end = $rowT['page_end'] ? "-" . $rowT['page_end'] : FALSE;
						if($page_start && $page_end)
							$page_start = 'p' . $page_start;
						if($numElements)
							for($i = 0; $i < $this->fontBlocks['quotes']['crBetween']; $i++)
								$this->pString .= $this->makeParagraph('quotes') . "\n";
						$this->pString .= $this->rtfParagraphBlock('quotes');
						$this->pString .= $this->utf8_2_unicode($this->textFormat(
							$rowT['text'], 'quotes')) . " $page_start$page_end \\par }";
						if(array_key_exists('quotesComments', $this->input))
						{
							if($this->input['metadata'] == 1) // only my musings
								$recordset3 = $this->db->select(array('WKX_resource_quote_comment'),
									array('comment', 'addUserIdQuote'), 
									" WHERE " . $this->db->formatField('quoteId') . "=" . 
									$this->db->tidyInput($rowT['quoteId']) . 
									" AND " . 
									$this->db->formatfield("addUserIdQuote") . "=" . 
									$this->db->tidyInput($userId));
							else // my musings and all public musings
								$recordset3 = $this->db->select(array('WKX_resource_quote_comment'),
									array('comment', 'addUserIdQuote'), 
									" WHERE " . $this->db->formatField('quoteId') . "=" . 
									$this->db->tidyInput($rowT['quoteId']) . 
									" AND (" . 
									$this->db->formatfield("addUserIdQuote") . "=" . 
									$this->db->tidyInput($userId) . 
									" OR " . 
									$this->db->formatfield("quotePrivate") . "=" . 
									$this->db->tidyInput('N') . ")"
									);
							while($rowC = $this->db->loopRecordset($recordset3))
							{
								$user = $this->user->displayUserAddEditPlain($rowC['addUserIdQuote']) . "\n";
								if(trim($this->input['quotesCommentsTag']))
								{
									$this->pString .= "\n" . 
										$this->rtfParagraphBlock('quotes');
									$this->pString .= $this->utf8_2_unicode(trim(
										$this->input['quotesCommentsTag'])) . 
										"  }\n";
								}
								$this->pString .= $this->rtfParagraphBlock('quotes');
								$this->pString .= $this->utf8_2_unicode(
								$this->textFormat($rowC['comment'], 'quotes')) . 
									"  ($user)\\par }\n";
							}
						}
						$numElements++;
					}
					for($i = 0; $i < $this->fontBlocks['quotes']['crFollowing']; $i++)
						$this->pString .= $this->makeParagraph('quotes') . "\n";
				}
			}
			if(array_key_exists('paraphrases', $this->input))
			{
				$this->pString .= $this->makeBlock('paraphrases');
				$recordset2 = $this->db->select(array('WKX_resource_paraphrase'), 
					array(array('WKX_resource_paraphrase.id' => 'paraphraseId'), 
					'page_start', 'page_end', 'text'), 
						" LEFT JOIN " . $this->db->formatTable('WKX_resource_paraphrase_text') . 
						" ON " . $this->db->formatField("WKX_resource_paraphrase.id") . "=" . 
						$this->db->formatField("WKX_resource_paraphrase_text.id") . 
						" WHERE " . $this->db->formatField("WKX_resource_paraphrase.resourceId") . "=" . 
						$this->db->tidyInput($row['resourceId']) . 
					" ORDER BY " . $this->db->tidyInputClause('page_start'));
//					ORDER BY " . $this->db->tidyInputClause('page_start')) . " + 0";
				if($this->db->numRows($recordset2))
				{
					if($returnAfterBib)
					{
						$this->pString .= $this->makeParagraph('bibliography') . "\n";
						$returnAfterBib = FALSE;
					}
					if(trim($this->input['paraphrasesTag']))
					{
						$this->pString .= $this->rtfParagraphBlock('paraphrases');
						$this->pString .= $this->utf8_2_unicode(trim(
							$this->input['paraphrasesTag'])) . " \\par }\n";
					}
					$numElements = 0;
					while($rowT = $this->db->loopRecordSet($recordset2))
					{
						$page_start = $rowT['page_start'] ? "p." . $rowT['page_start'] : FALSE;
						$page_end = $rowT['page_end'] ? "-" . $rowT['page_end'] : FALSE;
						if($page_start && $page_end)
							$page_start = 'p' . $page_start;
						if($numElements)
							for($i = 0; $i < $this->fontBlocks['paraphrases']['crBetween']; $i++)
								$this->pString .= $this->makeParagraph('paraphrases') . "\n";
						$this->pString .= $this->rtfParagraphBlock('paraphrases');
						$this->pString .= $this->utf8_2_unicode(
							$this->textFormat($rowT['text'], 
							'paraphrases')) . " $page_start$page_end \\par }";
						if(array_key_exists('paraphrasesComments', $this->input))
						{
							if($this->input['metadata'] == 1) // only my musings
								$recordset3 = $this->db->select(
									array('WKX_resource_paraphrase_comment'), 
									array('comment', 'addUserIdParaphrase'), 
									" WHERE " . $this->db->formatField('paraphraseId') . "=" . 
									$this->db->tidyInput($rowT['paraphraseId']) . 
									" AND " . 
									$this->db->formatfield("addUserIdParaphrase") . "=" . 
									$this->db->tidyInput($userId));
							else // my musings and all public musings
								$recordset3 = $this->db->select(array('WKX_resource_paraphrase_comment'),
									array('comment', 'addUserIdParaphrase'), 
									" WHERE " . $this->db->formatField('paraphraseId') . "=" . 
									$this->db->tidyInput($rowT['paraphraseId']) . 
									" AND (" . 
									$this->db->formatfield("addUserIdParaphrase") . "=" . 
									$this->db->tidyInput($userId) . 
									" OR " . 
									$this->db->formatfield("paraphrasePrivate") . "=" . 
									$this->db->tidyInput('N') . ")"
									);
							while($rowC = $this->db->loopRecordSet($recordset3))
							{
								$user = $this->user->displayUserAddEditPlain($rowC['addUserIdParaphrase'])
									. "\n";
								if(trim($this->input['paraphrasesCommentsTag']))
								{
									$this->pString .= "\n" . 
										$this->rtfParagraphBlock('paraphrases');
									$this->pString .= $this->utf8_2_unicode(trim(
										$this->input['paraphrasesCommentsTag'])) .
										"  }\n";
								}
								$this->pString .= $this->rtfParagraphBlock('paraphrases');
								$this->pString .= $this->utf8_2_unicode(
								$this->textFormat($rowC['comment'], 'paraphrases')) . 
								"  ($user)\\par }\n";
							}
						}
						$numElements++;
					}
					for($i = 0; $i < $this->fontBlocks['paraphrases']['crFollowing']; $i++)
						$this->pString .= $this->makeParagraph('paraphrases') . "\n";
				}
			}
// Do divider
			if(array_key_exists('divider', $this->input) && trim($this->input['divider']))
			{
				$this->pString .= $this->makeBlock('divider');
				$this->pString .= $this->rtfParagraphBlock('divider');
				$this->pString .= $this->utf8_2_unicode(trim($this->input['divider'])) . " \\par }" . "\n";
			}
			for($i = 0; $i < $this->dividerCR[$this->input['dividerCR']]; $i++)
				$this->pString .= $this->makeParagraph('divider') . "\n";
		}
	}
// Make a RTF paragraph
	function makeParagraph($type)
	{
		return "{" . $this->fontBlocks[$type]['fontBlock'] . $this->fontBlocks[$type]['fontSize'] . " \\par }";
	}
// make RTF block (justification, indents)
	function makeBlock($type)
	{
		if($type == 'divider')
			$pString = "\\qc";
		else
			$pString = "\\qj";
		$pString .= $this->fontBlocks[$type]['indentL'];
		$pString .= $this->fontBlocks[$type]['indentR'];
		return $pString . "\n";
	}
// format text with bold, italics, underline, convert newlines etc.
	function textFormat($input, $type)
	{
// remove db slashes and convert newlines
		$input = preg_replace("/(\015?\012){2,}/", " }" . $this->makeParagraph($type) . $this->makeParagraph($type) . 
			$this->rtfParagraphBlock($type), stripslashes($input));
		$input = preg_replace("/(\015?\012)/", " }\n" . $this->makeParagraph($type) . 
			$this->rtfParagraphBlock($type), $input);
// convert citations (FALSE for no hyperlink)
		$input = $this->cite->citeParse($input, FALSE);
// Convert bold, underline and italics
		$this->dbFormat = array("#\[b\](.*)\[/b\]#U", "#\[i\](.*)\[/i\]#U", "#\[u\](.*)\[/u\]#U");
		$this->rtfFormat = array("{\b \${1}}", "{\i \${1}}", "{\ul \${1}}");
		return preg_replace($this->dbFormat, $this->rtfFormat, $input);
	}
// Error handling
	function failure($error)
	{
		$this->template->setVar('body', $error);
		$pString = $this->template->process();
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $pString);
	}
// validate user input
	function checkInput()
	{
		$this->session->clearArray("exportRtf");
		$this->writeSession();
// At least one must be on
		if(!array_key_exists("exportRtf_bibliography", $this->vars) && 
			!array_key_exists("exportRtf_abstract", $this->vars) && 
			!array_key_exists("exportRtf_notes", $this->vars) && 
			!array_key_exists("exportRtf_quotes", $this->vars) && 
			!array_key_exists("exportRtf_paraphrases", $this->vars) && 
			!array_key_exists("exportRtf_musings", $this->vars))
			$this->failure($this->errors->text("inputError", "missing"));
		return $this->session->getArray("exportRtf");
	}
// write input to session
	function writeSession()
	{
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/^exportRtf_/", $key))
				$temp[$key] = $value;
		}
		if(isset($temp))
			$this->session->writeArray($temp);
	}
        /**
         * UTF-8 to unicode
         * returns an array of unicode character codes 
         * Code adapted from opensource PHP code by Scott Reynen at:
         * http://www.randomchaos.com/document.php?source=php_and_unicode
         *
         * @parameter string $string UTF-8 encoded string
         * @return string
         */
         
	function utf8_2_unicode($string)
	{
//		return preg_replace_callback("/&#(.*);/U", array($this, 'callback'), $string);
		$unicode = array();        
		$values = array();
		$lookingFor = 1;
		for($i = 0; $i < strlen($string); $i++)
		{
			$thisValue = ord($string[$i]);
			if($thisValue < 128)
				$unicode[] = $string[$i];
			else
			{
				if(count($values) == 0)
					$lookingFor = ($thisValue < 224) ? 2 : 3;
				$values[] = $thisValue;
				if(count($values) == $lookingFor)
				{
					$number = ($lookingFor == 3) ?
						(($values[0] % 16) * 4096) + (($values[1] % 64) * 64) + ($values[2] % 64) :
						(($values[0] % 32) * 64) + ($values[1] % 64);
					$unicode[] = '\u' . $number . " ?";
					$values = array();
					$lookingFor = 1;
				}
			}
		}
		return join('', $unicode);
	}
// callback for above - no longer needed
	function callback($array)
	{
		return '\u' . $array[1] . " ?";
	}
}
?>
