<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	HTML export class
*	Export just a plain HTML file listing of the bibliography (no meta data etc.)
*****/
class HTMLEXPORT
{
// Constructor
	function HTMLEXPORT($db)
	{
		$this->db = $db;
		include_once("core/file/FILE.php");
		$this->file = new FILE($this->db);
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
// Perform some system admin
		$this->file->tidyFiles();
	}
// write $this->pString to file.  If file exists, it is written over.
	function process()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "exportHtml"));
		if(!$fileName = $this->file->createFileName('.html'))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		if(!$fp = fopen("$fileName", "w"))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		$this->htmlHeader();
		$this->getData();
		$this->htmlFooter();
		if(!fputs($fp, $this->pString))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		fclose($fp);
		$pString = $this->listFiles();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Write the HTML header to $this->pString
	function htmlHeader()
	{
		$this->pString = "<head><title></title>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head><body>\n\n";
	}
// Write the HTML footer to $this->pString
	function htmlFooter()
	{
		$this->pString .= "\n</body></html>";
	}
// list and HTML format all files in this sessionID's folder
	function listFiles()
	{
		include_once("core/html/MISC.php");
		list($dirName, $deletePeriod, $array) = $this->file->listFiles();
		if(!$dirName)
			$this->failure($this->errors->text("file", "read"));
		$pString = MISC::p($this->messages->text("file", "contents"));
		foreach($array AS $key => $value)
			$pString .= MISC::a("link", $key, $dirName . '/' . $key, "_blank") . MISC::br();
		$minutes = $deletePeriod/60;
		$pString .= MISC::hr();
		$pString .= MISC::p($this->messages->text("file", "warning", " $minutes "));
		return $pString;
	}
// get data from database
	function getData()
	{
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "html");
		if(!$sql = $this->session->getVar('sql_stmt'))
			$this->failure($this->errors->text("file", "noSql"));
		$recordset = $this->db->query(stripslashes($sql));
		while($row = $this->db->loopRecordSet($recordset))
			$this->pString .= $bibStyle->process($row) . "<br />\n";
	}
// Error handling
	function failure($error)
	{
		$this->template->setVar('body', $error);
		$pString = $this->template->process();
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $pString);
	}
}
?>
