<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BIBTEX BibTeX export class
*****/
class BIBTEX
{
// Constructor
	function BIBTEX($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/file/FILE.php");
		$this->file = new FILE($this->db);
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/file/BIBTEXMAP.php");
		$this->map = new BIBTEXMAP();
		include_once("core/file/export/EXPORTCOMMON.php");
		$this->common = new EXPORTCOMMON($this->db);
		$this->pString = '';
// Perform some system admin
		$this->file->tidyFiles();
	}
// Stage 1 - present export options
	function stage1()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "exportBibtex"));
		if(!$sql = $this->session->getVar('sql_stmt'))
			$this->failure($this->errors->text("file", "noSql"));
		$pString = FORM::formHeader("exportBibtex");
		$checked = $this->session->getVar("export_mergeStored") ? TRUE : FALSE;
		$pString .= MISC::p($this->messages->text("misc", "mergeStored") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "mergeStored", $checked));
		$checked = $this->session->getVar("export_useOriginalCitation") ? TRUE : FALSE;
		$pString .= MISC::p($this->messages->text("misc", "useOriginalCitation") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "useOriginalCitation", $checked));
		$pString .= MISC::br() . FORM::formSubmit('Submit');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write $this->pString to file.  If file exists, it is written over.
	function process()
	{
		if(isset($this->vars['mergeStored']))
			$this->session->setVar('export_mergeStored', $this->vars['mergeStored']);
		else
			$this->session->delVar('export_mergeStored');
		if(isset($this->vars['useOriginalCitation']))
			$this->session->setVar('export_useOriginalCitation', $this->vars['useOriginalCitation']);
		else
			$this->session->delVar('export_useOriginalCitation');
		$this->template->setVar('heading', $this->messages->text("heading", "exportBibtex"));
		if(!$fileName = $this->file->createFileName('.bib'))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		if(!$fp = fopen("$fileName", "w"))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		$this->titleString = $this->rawString = array();
		$this->getData();
		$string = array();
		if(isset($this->rawString) && !empty($this->rawString))
		{
			foreach($this->titleString as $key => $value)
			{
				if(!array_key_exists($key, $this->rawString))
					$this->rawString[$key] = $value;
			}
			foreach($this->rawString as $key => $value)
				$string[] = "@STRING" . '{' . "$key = $value" . '}';
			$this->rawStringString .= implode("\n", $string) . "\n\n";
			$this->pString = $this->rawStringString . $this->pString;
		}
		else if(!empty($this->titleString))
		{
			foreach($this->titleString as $key => $value)
				$string[] = "@STRING" . '{' . "$key = $value" . '}';
			$this->rawStringString .= implode("\n", $string) . "\n\n";
			$this->pString = $this->rawStringString . $this->pString;
		}
		if(!fputs($fp, $this->pString))
			$this->failure($this->errors->text("file", "write", ": $fileName"));
		fclose($fp);
		$pString = $this->common->listFiles();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// get data from database
	function getData()
	{
		if(!$sql = $this->session->getVar('sql_stmt'))
			$this->failure($this->errors->text("file", "noSql"));
		$recordset = $this->db->query(stripslashes($sql));
// load default arrays
		$this->loadArrays();
		$this->stringIdArray = $this->strValues = $this->strKeys = array();
		$this->rawStringString = '';
		while($row = $this->db->loopRecordSet($recordset))
		{
			$entryArray = $this->rawEntries = array();
			$this->rawCitation = $longtitle = $shorttitle = FALSE;
			$this->raw($row);
			$cite = $this->citeFormat($row);
			foreach($this->map->{$row['type']}['resource_creator'] as $wkField => $bibField)
			{
				if(!$creators = $this->nameFormat($row, $wkField, $bibField))
					continue;
				else
					$entryArray[] = $creators;
			}
			$entryArray[] = "title = " . $this->convertCharacter($this->common->titleFormat($row, TRUE));
			if(($row['type'] == 'web_article') || ($row['type'] == 'database')) // 'misc' types
			{
				$entryArray[] = "howpublished = \"" . "\url{" . stripslashes($row['url']) . "}" . "\",";
				unset($row['url']);
			}
			$pubArray = array();
// For proceedings_article, miscField1 is the publisher
			if(($row['type'] == 'proceedings_article') && $row['miscField1'])
			{
				$recordSet2 = $this->db->select(array('WKX_publisher'), array('publisherName',
					'publisherLocation'), " WHERE " . 
					$this->db->formatField("id") . "=" . $this->db->tidyInput($row['miscField1']));
				$pubArray = $this->db->fetchRow($recordSet2);
				if($pubArray['publisherName'])
					$entryArray[] = "publisher = ". 
					$this->convertCharacter(stripslashes($pubArray['publisherName']));
				if($pubArray['publisherLocation'])
					$entryArray[] = "address = ". 
					$this->convertCharacter(stripslashes($pubArray['publisherLocation']));
			}
			foreach($this->map->{$row['type']} as $table => $tableArray)
			{
				if(($table == 'resource_creator') || ($table == 'howpublished'))
					continue;
				foreach($tableArray as $wkField => $bibField)
				{
					if(isset($row[$wkField]) && $row[$wkField])
					{
						if(($wkField == 'collectionTitle') && 
							isset($row['collectionTitleShort']) && 
							$row['collectionTitleShort'])
						{
							$short = stripslashes($row['collectionTitleShort']);
							$title = stripslashes($row['collectionTitle']);
							$long = "/^" . preg_quote($title) . "$/";
							if(!array_key_exists($short, $this->titleString))
								$this->titleString[$short] = '"' . $title . '"';
							$entryArray[] = "$bibField = " . 
								$this->convertCharacter2($title, $short, $long);
						}
						else
							$entryArray[] = "$bibField = " . 
							$this->convertCharacter(stripslashes($row[$wkField]));
					}
				}
			}
			if($item = $this->common->pageFormat($row, 'bibtex'))
				$entryArray[] = "pages = ". $this->convertCharacter($item);
			if($item = $this->common->keywordFormat($row, 'bibtex'))
				$entryArray[] = "keywords = " . $this->convertCharacter($item);
			if($item = $this->common->grabAbstract($row, 'bibtex'))
				$entryArray[] = "abstract = " . $this->convertCharacter($item);
			if($item = $this->common->grabNote($row, 'bibtex'))
				$entryArray[] = "note = " . $this->convertCharacter($item);
// Deal with month/day
			if($row['miscField3'])
			{
				if($item = $this->formatDate($row))
// No double quotes for month
					$entryArray[] = "month = $item,";
			}
// 'howpublished'
			else if(isset($this->map->types[$row['type']]) && 
				($this->map->types[$row['type']] == 'misc') && 
				(array_key_exists('howpublished', $this->map->{$row['type']})))
			{
				$field = $this->map->{$row['type']}['howpublished'];
				if(!array_key_exists($field, $row))
					$entryArray[] = "howpublished = " . $this->convertCharacter(ucfirst($field));
				else
					$entryArray[] = "howpublished = " . $this->convertCharacter(ucfirst($row[$field]));
			}
			if(($row['type'] == 'thesis') && 
				(($row['field1'] == 'doctoral') || ($row['field1'] == 'PhD')))
				$this->pString .= "@" . 'phdthesis' . "\{$cite,\n\t";
			else if($row['type'] == 'thesis') // masters + unknown
				$this->pString .= "@" . 'mastersthesis' . "\{$cite,\n\t";
			else
				$this->pString .= "@" . $this->map->types[$row['type']] . "\{$cite,\n\t";
			if($this->session->getVar("export_mergeStored") && !empty($this->rawEntries))
			{
				foreach($this->rawEntries as $key => $value)
				{
					if(($key == 'month') && ($value{0} == '"'))
					{
						$value = substr($value, 1);
						$value = substr($value, 0, -1);
					}
					$entryArray[] = $key . " = " . $value . ",";
				}
			}
			$this->pString .= join("\n\t", $entryArray) . "\n}\n\n";
		}
	}
// grab any stored data and @strings for this resource from WKX_import_raw
	function raw($row)
	{
		$recordset = $this->db->select(array('WKX_import_raw'), array('text', 'stringId', 'importType'), 
			"WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($row['resourceId']) . 
			" AND " . $this->db->formatField('importType') . "=" . $this->db->tidyInput('bibtex'));
		if(!$this->db->numRows($recordset))
			return;
		$stringIdFound = FALSE;
		while($rawRow = $this->db->loopRecordSet($recordset))
		{
			$rawEntries = unserialize(base64_decode($rawRow['text']));
			foreach($this->stringIdArray as $stringId)
			{
				if($rawRow['stringId'] == $stringId)
				{
					$stringIdFound = TRUE;
					break;
				}
			}
			if($stringIdFound)
				break;
			if(array_search($rawRow['stringId'], $this->stringIdArray) === FALSE)
			{
				$recordset = $this->db->select(array('WKX_bibtex_string'), array('text'), 
					"WHERE " . $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($rawRow['stringId']));
				$rawString = unserialize(base64_decode($this->db->fetchOne($recordset))) . "\n\n";
				if($rawString)
					preg_match_all("/@STRING{(.*)}/", $rawString, $strings);
				foreach($strings[1] as $string)
				{
					$split = explode("=", $string, 2);
					if(array_search(trim($split[0]), $this->rawString) === FALSE)
						$this->rawString[trim($split[0])] = trim($split[1]);
				}
				$this->orderArrayByKeyLength();
				foreach($this->rawString as $key => $value)
				{
					if(preg_match("/^[\"{](.*)[\"}]$/", trim($value), $matches))
						$value = $matches[1];
					$value = "/^" . preg_quote($value, "/") . "$/";
					if(!array_search($value, $this->strValues))
						$this->strValues[] = $value;
					if(!array_search($key, $this->strKeys))
						$this->strKeys[] = $key;
				}
				$this->stringIdArray[] = $rawRow['stringId'];
				break;
			}
		}
		$this->strValues = array_unique($this->strValues);
		$this->strKeys = array_unique($this->strKeys);
		if($rawEntries)
		{
			$rawEntries = explode("\n", $rawEntries);
			array_pop($rawEntries); // always an empty array at end so get rid of it.
			foreach($rawEntries as $entries)
			{
				$entry = explode("=", $entries, 2);
				if(!trim($entry[1]))
					continue;
				if(trim($entry[0]) == 'citation')
					$this->rawCitation = trim($entry[1]);
				else
				{
					$key = trim($entry[0]);
					$value = trim($entry[1]);
					$this->rawEntries[$key] = $value;
				}
			}
		}
	}
// convert special characters to TeX codes
	function convertTex($string, $type = FALSE)
	{
// As web browser encoding is set to UTF-8, all input in the db is stored as UTF-8 - convert back to ISO-8859-1
		$c = utf8_decode($string);
		if($type == 'plain')
		{
			foreach($this->spChPlain as $key => $value)
			{
				$char = chr($key);
        			$c = preg_replace("/$char/", "$value", $c);
			}
		}
		else
		{
// '\' and '$' are special cases and must be treated separately.  Former MUST be treated first!
			$char = "\\" . chr(0x005C);	// '\'
			$rep = "\\textbackslash";
			$c = preg_replace("/$char/", $rep, $c);
//			$char = "\\" . chr(0x0024);	// '$'
//			$rep = "\\textdollar";
//			$c = preg_replace("/$char/", $rep, $c);
			foreach($this->spCh as $key => $value)
			{
				$match[] = "/" . preg_quote(chr($key)) . "/";
				$replace[] = $value;
			}
        		$c = preg_replace($match, $replace, $c);
		}
		return $c;
	}
// convert @STRING from raw database @string fields.
	function convertCharacter($string, $type = FALSE)
	{
		$c = $this->convertTex($string, $type);
// Do @string substitutions
		if(!empty($this->strValues))
		{
			$replace = preg_replace($this->strValues, $this->strKeys, $c);
// If a replacement has occurred, $replace != $c so return without quotes
			if($replace != $c)
				return $replace . ",";
		}
// no replacement so return quoted
		return "\"" . $c . "\",";
	}
// convert @string from WIKINDX stored fields
	function convertCharacter2($string, $replace, $pattern, $type = FALSE)
	{
		$c = $this->convertTex($string, $type);
// Do @string substitutions
		$replace = preg_replace($pattern, $replace, $c);
// If a replacement has occurred, $replace != $c so return without quotes
		if($replace != $c)
			return $replace . ",";
// no replacement so return quoted
		return "\"" . $c . "\",";
	}
// load default arrays
	function loadArrays()
	{
// need to use English constants for BibTeX
		include_once("languages/en/CONSTANTS.php");
		$constants = new CONSTANTS_en();
		include_once("core/file/BIBTEXCONFIG.php");
		$config = new BIBTEXCONFIG();
		$config->bibtex();
		$temp = $config->bibtexSpCh;
// We need to remove first two elements of array as we don't want to convert '{' and '}'. Because the keys of the original 
// array are hexadecimal characters, this means array_shift will treat them as integer keys and will modify the array 
// keys - we don't want this!
		$index = 0;
		foreach($temp as $key => $value)
		{
			if($index >= 2)
				$this->spCh[$key] = $value;
			$index++;
		}
		$this->spChPlain = $config->bibtexSpChPlain;
		$constants->convertNumbers();
		$this->editionArray = $constants->cardinalToOrdinalWord();
		$this->monthArray = $constants->monthToShortName();
	}
// store surname of first author for BibTeX citation purposes.
// $this->cite[] holds existing citations which must not be repeated.
// Ensure $cite has no spaces, commas etc.
	function citeFormat($row)
	{
		if(!isset($this->cite))
			$this->cite = array();
		if($this->session->getVar("export_useOriginalCitation") && 
			$this->rawCitation && !array_key_exists($this->rawCitation, $this->cite))
		{
			$this->cite[] = $this->rawCitation;
			return trim($this->rawCitation);
		}
		if($row['creator1'])
		{
			$recordset = $this->db->select(array('WKX_creator'), array('surname'), 
				" WHERE " . $this->db->formatField('id') . "=" . 
				$this->db->tidyInput($row['creator1']));
			$name = $this->db->fetchRow($recordset);
			$cite = strtolower($this->convertCharacter(stripslashes($name['surname']), 'plain'));
			$cite = preg_replace("/\W/", '', $cite);
		}
		else if($row['creator2'])
		{
			$recordset = $this->db->select(array('WKX_creator'), array('surname'), 
				" WHERE " . $this->db->formatField('id') . "=" . 
				$this->db->tidyInput($row['creator2']));
			$name = $this->db->fetchRow($recordset);
			$cite = strtolower($this->convertCharacter(stripslashes($name['surname']), 'plain'));
			$cite = preg_replace("/\W/", '', $cite);
		}
		else
			$cite = 'anon';
		for($i = 1; $i < 100000; $i++)
		{
			if(!array_key_exists($cite . '.' . $i, $this->cite))
			{
				$this->cite[$cite . '.' . $i] = FALSE;
				break;
			}
		}
		return $cite . '.' . $i;
	}
// format names.
	function nameFormat($row, $type, $bibField)
	{
		if(!$row[$type])
			return;
		$creatorIds = explode(",", $row[$type]);
		foreach($creatorIds as $id)
			$condition[] = $this->db->formatField('id') . "=" . $this->db->tidyInput($id);
		$recordset = $this->db->select(array('WKX_creator'), 
			array('surname', 'firstname', 'initials', 'prefix', 'id'), 
			" WHERE " . implode(' OR ', $condition));
		while($creatorRow = $this->db->loopRecordSet($recordset))
		{
			$name = $this->common->formatName($creatorRow, 'bibtex');
			if($name)
				$mapName[$creatorRow['id']] = $name;
		}
		foreach($creatorIds as $id)
			$nameArray[] = $mapName[$id];
		if(isset($nameArray))
			return $bibField . " = " . $this->convertCharacter(join(' and ', $nameArray));
	}
// Deal with month/day
	function formatDate($row)
	{
// NB 3-letter month abbreviation must not be quoted
		if(!$row['miscField3'])
			return '';
		$startMonth = strtolower($this->monthArray[$row['miscField3']]);
// if there's a day, append it
		if($row['miscField2'])
			$startDay = "\" " . $row['miscField2'] . "\"";
		if(isset($startDay) && $row['miscField5'] && $row['miscField6'] && 
			($row['miscField3'] == $row['miscField6']))
			$date = "$startMonth # \"" . $startDay . "--" . $row['miscField5'] . "\"";
		else if(isset($startDay) && $row['miscField5'] && $row['miscField6'])
			$date = "$startMonth # " . $startDay . " # \"--\" " . 
			strtolower($this->monthArray[$row['miscField6']]) . " # \" " . $row['miscField5'] . "\"";
		else if($row['miscField6'])
			$date = "$startMonth # " . "\"/\"" . " # " . strtolower($this->monthArray[$row['miscField6']]);
		else if(isset($startDay))
			$date = "$startMonth # " . $startDay;
		else
			$date = $startMonth;
		return $date;
	}
// Error handling
	function failure($error)
	{
		$this->template->setVar('body', $error);
		$pString = $this->template->process();
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $pString);
	}
	function orderArrayByKeyLength()
	{
		uksort($this->rawString, array($this, "cmp"));
	}
// user function for uksort above
	function cmp($a, $b)
	{
		if(preg_match_all("/./", $a, $throwAway) > preg_match_all("/./", $b, $throwAway2))
			return 0;
		return preg_match_all("/./", $a, $throwAway) > preg_match_all("/./", $b, $throwAway2) ? -1 : 1;
	}
}
?>
