<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BibTeX TAG class.
*****/
class TAG
{
// Constructor
	function TAG($db)
	{
		$this->db = $db;
	}
// Get tags from WKX_tag.  Return associative array of id => group.
	function grabAll()
	{
		include_once("core/html/HTML.php");
		$html = new HTML();
		$recordset = $this->db->select(array("WKX_tag"), array("id", "tag"), 
			'ORDER BY ' . $this->db->tidyInputClause('tag'));
		while($row = $this->db->loopRecordSet($recordset))
			$tags[$row['id']] = $html->dbToFormTidy($row['tag']);
		if(isset($tags))
			return $tags;
		return FALSE;
	}
// return a SQL condition clause when selecting by tag
	function selectCondition($input)
	{
		$condition = '';
		$selectArray = explode(",", $input['tag']);
		foreach($selectArray as $key => $value)
			$conditionArray[] = "FIND_IN_SET(" . $this->db->tidyInput($value) . ", " . 
			$this->db->formatfield('tag') . ")";
		$condition .= implode(" OR ", $conditionArray);
		return $condition;
	}
// check to see if tag already exists
	function checkExists($tag)
	{
		$condition = " WHERE LOWER(" . $this->db->formatField('tag') . ")=" . 
				$this->db->tidyInput(strtolower($tag));
		$recordset = $this->db->select(array('WKX_tag'), array('id'), $condition);
		if($this->db->numRows($recordset))
			return $this->db->fetchOne($recordset);
		return FALSE;
	}
// remove resource-less tags
	function removeHanging($id)
	{
		$recordset = $this->db->select(array('WKX_resource_misc'), 
			array('id'), " WHERE " . $this->db->formatField('tag') . " = $id");
		if(!$this->db->numRows($recordset))
			$this->db->delete('WKX_tag', " WHERE " . $this->db->formatField('id') . "=" . $id);
		$this->db->optimize('WKX_tag');
	}
}
?>
