<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	RIS Map class.
*	Provides mappings for Endnote export/import
*
*	$Header: /cvsroot/wikindx/wikindx3/core/file/RISMAP.php,v 1.2 2005/06/11 03:11:48 sirfragalot Exp $
*****/
class RISMAP
{
/*
* Constructor
*
* @author Mark Grimshaw
* @version 1
*/
	function RISMAP()
	{
		$this->loadMap();
	}
/*
* Create arrays based on database table and resource type.
* The arrays are named for WIKINDX resource types.
* The key of the resource_xxx arrays is the database field within the WKX_resource_xxx database table. For exporting 
* RIS files this is not needed but will prove useful should there be an eventual RIS import.
* The key of the resource_xxx array is the WIKINDX field in that table while the value is the RIS 
* equivalent field.  For an export, these keys can be found as the fields in the SQL $row assoc. array.
*
* The database matrix can be found in docs/resourceDatabaseMatrix.html
*
* Some things must be sorted out on the fly in the import/export code:
* 1/ Running time for films comes from miscField1 and miscField4.
* 2/ All year1 fields are dealt with in the import code.
* 3/ WIKINDX book and book_article types can have a reprintYear in `year2`.  If a book has this in addition to a 
* publicationYear in `year1` then we need to switch the two fields so that `year1` is Endnote's 'Original Publication'
* field and `year2` is Endnote's 'Year'.
* 4/ Most dates (newspaper, magazine, hearing etc.) have to be created on the fly from database fields `miscField2`
* (day) and `miscField3` (month).
* 5/ A WIKINDX 'title' is comprised of `subtitle`, `title` and `noSort` fields.
*
* @author Mark Grimshaw
* @version 1
*/
	function loadMap()
	{
// WIKINDX resource types (keys) and their RIS equivalent (values).
		$this->types = array(
				'book'			=>	'BOOK',
				'book_article'		=>	'CHAP',
				'journal_article'	=>	'JOUR',
				'newspaper_article'	=>	'NEWS',
				'magazine_article'	=>	'MGZN',
				'proceedings'		=>	'GEN',
				'conference_paper'	=>	'GEN',
				'proceedings_article'	=>	'CONF',
				'thesis'		=>	'THES',
				'web_article'		=>	'ELEC',
				'film'			=>	'MPCT',
				'broadcast'		=>	'GEN',
				'music_album'		=>	'SOUND',
				'music_track'		=>	'SOUND',
				'music_score'		=>	'MUSIC',
				'artwork'		=>	'ART',
				'software'		=>	'COMP',
				'audiovisual'		=>	'ADVS',
				'database'		=>	'ELEC',
				'government_report'	=>	'GEN',
				'report'		=>	'RPRT',
				'hearing'		=>	'HEAR',
				'statute'		=>	'STAT',
				'legal_ruling'		=>	'GEN',
				'case'			=>	'CASE',
				'bill'			=>	'BILL',
				'patent'		=>	'PAT',
				'personal'		=>	'PCOMM',
				'unpublished'		=>	'UNPB',
				'classical'		=>	'GEN',
				'manuscript'		=>	'GEN',
				'map'			=>	'MAP',
				'chart'			=>	'GEN',
				'miscellaneous'		=>	'GEN',
			);
// Book resource type
		$this->book = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field1'	=>	'T3', // Series Title
					'field2'	=>	'VL', // Edition
					'field4'	=>	'IS', // Volume
				),
				'resource_misc'	=>	array(
					'miscField4'	=>	'M1', // Number of Volumes
					),
				'resource_year'	=>	array(  // empty array required
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Author
					'creator2'	=>	'A2', // Editor
					'creator5'	=>	'A3', // Series Editor
				),
			);
		$this->book['resource_publisher']['publisherName'] = 'PB';
		$this->book['resource_publisher']['publisherLocation'] = 'CY';
		$this->book['resource_collection'] = array(); // need empty array
// book article/chapter resource type
		$this->book_article = $this->book;
		$this->book_article['resource_collection']['collectionTitle'] = 'T2';
// Journal article resource type
		$this->journal_article = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field1'	=>	'VL', // Volume
					'field2'	=>	'IS', // Issue
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(  // empty array required
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Author
				),
			);
		$this->journal_article['resource_publisher'] = array(); // need empty array
		$this->journal_article['resource_collection']['collectionTitle'] = 'JF'; // Journal Full Name
// Newspaper article type
		$this->newspaper_article = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'CY', // Place Published
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(  // empty array required
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->newspaper_article['resource_publisher'] = array(); // need empty array
		$this->newspaper_article['resource_collection']['collectionTitle'] = 'JF';
// proceedings article
		$this->proceedings_article = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field1'	=>	'T3', // Series Title
					'field3'	=>	'IS', // Volume
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->proceedings_article['resource_publisher']['publisherName'] = 'PB';
		$this->proceedings_article['resource_publisher']['publisherLocation'] = 'CY';
		$this->proceedings_article['resource_collection']['collectionTitle'] = 'T2';
// Web article resource type
		$this->web_article = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field1'	=>	'VL', // Volume
					'field2'	=>	'IS', // Issue
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->web_article['resource_publisher'] = array(); // need empty array
		$this->web_article['resource_collection']['collectionTitle'] = 'JF';
// Thesis resource type
		$this->thesis = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field3'	=>	'VL', // Volume
					'field4'	=>	'IS', // Issue
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->thesis['resource_publisher']['publisherName'] = 'PB';
		$this->thesis['resource_publisher']['publisherLocation'] = 'CY';
		$this->thesis['resource_collection']['collectionTitle'] = 'JF'; // Abstract journal
// Film resource type
		$this->film = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field1'	=>	'CY',
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // director
				),
			);
		$this->film['resource_publisher']['publisherName'] = 'A3'; // distributor
		$this->film['resource_collection'] = array(); // need empty array
// Broadcast resource type
		$this->broadcast = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // director
				),
			);
		$this->broadcast['resource_publisher']['publisherName'] = 'A3'; // distributor
		$this->broadcast['resource_publisher']['publisherLocation'] = 'CY';
		$this->broadcast['resource_collection'] = array(); // need empty array
// Software resource type
		$this->software = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field2'	=>	'M3', // Medium
					'field4'	=>	'IS', // Version
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Programmer
				),
			);
		$this->software['resource_publisher']['publisherName'] = 'PB';
		$this->software['resource_publisher']['publisherLocation'] = 'CY';
		$this->software['resource_collection'] = array(); // need empty array
// Artwork resource type
		$this->artwork = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field2'	=>	'M1', // Medium
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->artwork['resource_publisher']['publisherName'] = 'PB';
		$this->artwork['resource_publisher']['publisherLocation'] = 'CY';
		$this->artwork['resource_collection'] = array(); // need empty array
// Audiovisual resource type
		$this->audiovisual = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
				),
				'resource_misc'	=>	array(
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->audiovisual['resource_publisher']['publisherName'] = 'PB';
		$this->audiovisual['resource_publisher']['publisherLocation'] = 'CY';
		$this->audiovisual['resource_collection'] = array(); // need empty array
// case resource type
		$this->case = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field1'	=>	'CY', // Reporter
					'field4'	=>	'IS', // Reporter Volume
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator3'	=>	'A1', // Counsel
				),
			);
		$this->case['resource_publisher']['publisherName'] = 'PB'; // Court
		$this->case['resource_collection'] = array(); // need empty array
// bill resource type
		$this->bill = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field2'	=>	'CY', // Code
					'field5'	=>	'VL', // Bill Number
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array( // we require an empty array to still be present
				),
			);
		$this->bill['resource_publisher'] = array(); // need empty array
		$this->bill['resource_collection'] = array(); // need empty array
// classical resource type
		$this->classical = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field4'	=>	'T2', // Volume
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Attribution
				),
			);
		$this->classical['resource_publisher'] = array(); // need empty array
		$this->classical['resource_collection'] = array(); // need empty array
// Conference Paper resource type
		$this->conference_paper = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->conference_paper['resource_publisher']['publisherName'] = 'PB';
		$this->conference_paper['resource_publisher']['publisherLocation'] = 'CY';
		$this->conference_paper['resource_collection'] = array(); // need empty array
// Legal Rule/Regulation resource type
		$this->legal_ruling = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field3'	=>	'VL', // Edition
					'field4'	=>	'IS', // Rule Number
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->legal_ruling['resource_publisher']['publisherName'] = 'PB';
		$this->legal_ruling['resource_publisher']['publisherLocation'] = 'CY';
		$this->legal_ruling['resource_collection'] = array(); // need empty array
// Government Report/Documentation resource type
		$this->government_report = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field2'	=>	'A3', // Department
					'field3'	=>	'VL', // Edition
					'field5'	=>	'IS', // Rule Number
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
					),
			);
		$this->government_report['resource_publisher']['publisherName'] = 'PB';
		$this->government_report['resource_collection'] = array(); // need empty array
// Report/Documentation resource type
		$this->report = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field2'	=>	'M1', // Type of Work
					'field5'	=>	'VL', // Report number
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
					),
			);
		$this->report['resource_publisher']['publisherName'] = 'PB';
		$this->report['resource_publisher']['publisherLocation'] = 'CY';
		$this->report['resource_collection'] = array(); // need empty array
// Hearing resource type
		$this->hearing = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					'field1'	=>	'CY', // Committee
					'field2'	=>	'PB', // Legislative Body
					'field4'	=>	'VL', // Document Number
					),
				'resource_misc'	=>	array(
					),
				'resource_year'	=>	array(
					),
				'resource_creator' =>	array(  // empty array required
					),
			);
		$this->hearing['resource_publisher']['publisherName'] = array(); // need empty array
		$this->hearing['resource_collection'] = array(); // need empty array
// Online database resource type
		$this->database = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->database['resource_publisher']['publisherName'] = 'PB';
		$this->database['resource_collection'] = array(); // need empty array
// Magazine article type
		$this->magazine_article = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field4'	=>	'VL',
					'field3'	=>	'IS',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(  // empty array required
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->magazine_article['resource_publisher'] = array(); // need empty array
		$this->magazine_article['resource_collection']['collectionTitle'] = 'JF';
// Manuscript type
		$this->manuscript = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'M1', // Type of Work
					'field3'	=>	'IS', // Edition
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->manuscript['resource_publisher'] = array(); // need empty array
		$this->manuscript['resource_collection']['collectionTitle'] = 'T2';
// Map type
		$this->map = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'M2', // Type of Work
					'field3'	=>	'VL', // Edition
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Cartographer
				),
			);
		$this->map['resource_publisher']['publisherName'] = 'PB';
		$this->map['resource_publisher']['publisherLocation'] = 'CY';
		$this->map['resource_collection'] = array(); // need empty array
// Chart type
		$this->chart = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field1'	=>	'T2', // Name of File
					'field2'	=>	'T3', // Image Source Program
					'field5'	=>	'VL', // Version
					'field6'	=>	'IS',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Created By
				),
			);
		$this->chart['resource_publisher']['publisherName'] = 'PB';
		$this->chart['resource_publisher']['publisherLocation'] = 'CY';
		$this->chart['resource_collection'] = array(); // need empty array
// Statute type
		$this->statute = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'CY', // Code
					'field5'	=>	'VL', // Code Number
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(  // empty array required
				),
			);
		$this->statute['resource_publisher'] = array(); // need empty array
		$this->statute['resource_collection'] = array(); // need empty array
// Patent type
		$this->patent = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field3'	=>	'VL', // Application Number
					'field4'	=>	'M3', // Patent Type
					'field7'	=>	'M1', // International Patent Classification
					'field8'	=>	'IS', // Patent Number
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Inventor
				),
			);
		$this->patent['resource_publisher']['publisherName'] = 'A2'; // Assignees
		$this->patent['resource_publisher']['publisherLocation'] = 'CY';
		$this->patent['resource_collection'] = array(); // need empty array
// Personal Communication type
		$this->personal = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'M1',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
					'creator2'	=>	'A2', // Recipient
				),
			);
		$this->personal['resource_publisher'] = array(); // need empty array
		$this->personal['resource_collection'] = array(); // need empty array
// Unpublished type
		$this->unpublished = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->unpublished['resource_publisher'] = array(); // need empty array
		$this->unpublished['resource_collection'] = array(); // need empty array
// proceedings (complete set)
		$this->proceedings = array(
				'resource'	=>	array(
					'url'		=>	'UR', // URL
					'isbn'		=>	'SN', // ISBN/ISSN
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array( // we require an empty array to still be present
				),
			);
		$this->proceedings['resource_publisher']['publisherName'] = 'PB';
		$this->proceedings['resource_publisher']['publisherLocation'] = 'CY';
		$this->proceedings['resource_collection'] = array(); // need empty array
// Music Album type
		$this->music_album = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'M3', // medium
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A2', // Performer
					'creator2'	=>	'A1', // Composer
				),
			);
		$this->music_album['resource_publisher']['publisherName'] = 'PB';
		$this->music_album['resource_publisher']['publisherLocation'] = 'CY';
		$this->music_album['resource_collection'] = array(); // need empty array
// Music Track type
		$this->music_track = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field2'	=>	'M3', // medium
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A2', // Performer
					'creator2'	=>	'A1', // Composer
				),
			);
		$this->music_track['resource_publisher']['publisherName'] = 'PB';
		$this->music_track['resource_publisher']['publisherLocation'] = 'CY';
		$this->music_track['resource_collection']['collectionTitle'] = 'M1';
// Music Score type
		$this->music_score = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
					'field3'	=>	'VL', // Edition
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1', // Composer
					'creator2'	=>	'A2', // Editor
				),
			);
		$this->music_score['resource_publisher']['publisherName'] = 'PB';
		$this->music_score['resource_publisher']['publisherLocation'] = 'CY';
		$this->music_score['resource_collection'] = array(); // need empty array
// Miscellaneous resource type
		$this->miscellaneous = array(
				'resource'	=>	array(
					'url'		=>	'UR',
					'isbn'		=>	'SN',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
				),
				'resource_creator' =>	array(
					'creator1'	=>	'A1',
				),
			);
		$this->miscellaneous['resource_publisher']['publisherName'] = 'PB';
		$this->miscellaneous['resource_publisher']['publisherLocation'] = 'CY';
		$this->miscellaneous['resource_collection'] = array(); // need empty array
	}
}
?>
