<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* FILE class
*
*****/
class FILE
{
// Constructor
	function FILE($db)
	{
		$this->db = $db;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		$this->pString = '';
		$this->dirName = "files/" . session_id();
	}
// If $noMenu, display Resources submenu links
	function display($noMenu = FALSE)
	{
		include_once("core/html/MISC.php");
		$this->template->setVar('heading', $this->messages->text("heading", "files"));
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('file');
			$this->template->setVar('noMenu', $pString);
			return $this->template->process();
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// tidy up the files directory by removing all files and folders older than 'setup_fileDeleteSeconds'
	function tidyFiles()
	{
// failure is an option;
		if(!$dh = @opendir("files"))
			return;
		$now = time();
		while(false !== ($dir = readdir($dh)))
		{
        		if(($dir == ".") || ($dir == "..") || ($dir == 'CVS'))
				continue;
			$outerDir = "files/" . $dir;
			if(is_dir($outerDir))
			{
				if(!$d = @opendir($outerDir))
					continue;
				$numFiles = 0;
				while(false !== ($f = readdir($d)))
				{
        				if(($f == ".") || ($f == "..") || ($f == 'CVS') || ($f == 'FILE'))
						continue;
					$file = $outerDir . "/" . $f;
					if(($now - filemtime($file)) >= $this->session->getVar('setup_fileDeleteSeconds'))
						unlink($file);
					$numFiles++;
				}
// if !$numFiles, this directory is empty and can be deleted.  NB - this actually happens the next time around
// if this time has deleted some files from that directory!
// Since windows can't unlink directories, we ignore warnings.
				if(!$numFiles)
					@rmdir($outerDir);
			}
		}
	}
// list and HTML format all files in this sessionID's folder
	function listFiles()
	{
		if(!$dh = @opendir($this->dirName))
			return array(FALSE, FALSE, FALSE);
		while(false !== ($file = readdir($dh)))
		{
        		if($file == "." || $file == "..")
				continue;
// list only BibTeX, RIS, TXT (Endnote), HTML and RTF files
			if(!preg_match("/\.bib|\.rtf|\.ref|\.txt|\.html/", $file))
				continue;
			$array[$file] = filemtime($this->dirName . '/' . $file);
		}
		closedir($dh);
		asort($array, SORT_NUMERIC);
		$array = array_reverse($array);
		return array($this->dirName, $this->session->getVar('setup_fileDeleteSeconds'), $array);
	}
// create a fileName for this file.  If directory based on session ID does not exist, create it.
	function createFileName($extension)
	{
		$fileName = time() . $extension;
		if(!$dh = @opendir($this->dirName))
		{
			if(!mkdir($this->dirName))
				return FALSE;
		}
		else
			closedir($dh);
// folder (now) exists
		return $this->dirName . '/' . $fileName;
	}
// delete folder and all files within it
	function deleteAll($type, $id)
	{
		if(!$dh = @opendir($this->dirName))
			return;
		while(false !== ($file = readdir($dh)))
		{
        		if ($file != "." && $file != "..")
				unlink($this->dirName . '/' . $file);
		}
		closedir($dh);
		rmdir($dir);
	}
// Show all files in temporary directory (called from File menu)
	function show()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "files"));
		list($dirName, $deletePeriod, $array) = $this->listFiles();
		if(!$dirName)
		{
			include_once("core/messages/ERRORS.php");
			$errors = new ERRORS();
			$pString = $errors->text("file", "empty");
		}
		else
		{
			$pString = MISC::p($this->messages->text("file", "contents"));
			foreach($array AS $key => $value)
				$pString .= MISC::a("link", $key, $dirName . '/' . $key, "_blank") . MISC::br();
			$minutes = $deletePeriod/60;
			$pString .= MISC::hr();
			$pString .= MISC::p($this->messages->text("file", "warning", " $minutes "));
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
}
?>
