<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BibTeX Map class.
*	Provides mappings for BibTeX export/import
*
*	$Header: /cvsroot/wikindx/wikindx3/core/file/BIBTEXMAP.php,v 1.6 2005/06/11 03:11:48 sirfragalot Exp $
*****/
class BIBTEXMAP
{
// Constructor
	function BIBTEXMAP()
	{
		$this->loadMap();
	}
/*
* Create arrays based on database table and resource type.
* The arrays are named for WIKINDX resource types.
* The key of the resource_xxx arrays is the database field within the WKX_resource_xxx database table. For exporting 
* BibTeX files this is not needed but isused for BibTeX import.
* The key of the resource_xxx array is the WIKINDX field in that table while the value is the BibTeX 
* equivalent field.  For an export, these keys can be found as the fields in the SQL $row assoc. array in 
* core/file/export/BIBTEX.php.
*
* The database matrix can be found in docs/resourceDatabaseMatrix.html
*
* Some things must be sorted out on the fly in the import/export code:
* 1/ BibTeX only has a field 'Pages' whereas WIKINDX uses pageStart and pageEnd fields.
* 2/ The 'howpublished' key is intended for bibTex's misc types.  For web_article and 
* database resource types, this is added in the code so don't add it here.
* 3/ WIKINDX book and book_article types can have a reprintYear in `year2`.  If a book has this in addition to a 
* publicationYear in `year1` then we need to switch the two fields so that `year1` is Endnote's 'Original Publication'
* field and `year2` is Endnote's 'Year'.  They are defined here as if there were no reprintYear.
* 4/ Most dates (newspaper, magazine, hearing etc.) have to be created on the fly from database fields `miscField2`
* (day) and `miscField3` (month).
* 5/ A WIKINDX 'title' is comprised of `subtitle`, `title` and `noSort` fields.
*
* When importing a bibTeX file, you must ignore the 'howpublished' key as defined here and deal with any @misc howpublished 
* field manually in the code.
*
* The 'possible' array lists ALL possible fields that wikindx will accept for each type when importing.
*
* @author Mark Grimshaw
* @version 1
*/
	function loadMap()
	{
// WIKINDX resource types (keys) and their BibTeX equivalent (values).
// NB - mastersthesis and phdthesis sorted out on the fly in code.
		$this->types = array(
				'book'			=>	'book',
				'book_article'		=>	'inbook',
				'journal_article'	=>	'article',
				'newspaper_article'	=>	'article',
				'magazine_article'	=>	'article',
				'proceedings'		=>	'proceedings',
				'conference_paper'	=>	'misc',
				'proceedings_article'	=>	'inproceedings',
				'web_article'		=>	'misc',
				'film'			=>	'misc',
				'broadcast'		=>	'misc',
				'music_album'		=>	'misc',
				'music_track'		=>	'misc',
				'music_score'		=>	'misc',
				'artwork'		=>	'misc',
				'software'		=>	'misc',
				'audiovisual'		=>	'misc',
				'database'		=>	'misc',
				'government_report'	=>	'misc',
				'report'		=>	'techreport',
				'hearing'		=>	'misc',
				'statute'		=>	'misc',
				'legal_ruling'		=>	'misc',
				'case'			=>	'misc',
				'bill'			=>	'misc',
				'patent'		=>	'patent',
				'personal'		=>	'misc',
				'unpublished'		=>	'unpublished',
				'classical'		=>	'misc',
				'manuscript'		=>	'misc',
				'map'			=>	'misc',
				'chart'			=>	'misc',
				'miscellaneous'		=>	'misc',
			);
// Book resource type
		$this->book = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'series', // Series Title
					'field2'	=>	'edition',
					'field3'	=>	'number', // Series number
					'field4'	=>	'volume', // Volume number
				),
				'resource_misc'	=>	array(
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'editor',
				),
			);
		$this->book['resource_publisher']['publisherName'] = 'publisher';
		$this->book['resource_publisher']['publisherLocation'] = 'address';
		$this->book['resource_collection'] = array(); // need empty array
		$this->book['possible'] = array('title', 'url', 'isbn', 'series', 'edition', 'number', 'volume', 'year', 
			'author', 'editor', 'publisher', 'address');
// book article/chapter resource type
		$this->book_article = $this->book;
		$this->book_article['resource_collection']['collectionTitle'] = 'booktitle';
		$this->book_article['possible'][] = 'booktitle';
		$this->book_article['possible'][] = 'pages';
// Journal article resource type
		$this->journal_article = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISSN',
					'field1'	=>	'volume',
					'field2'	=>	'number',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->journal_article['resource_publisher'] = array(); // need empty array
		$this->journal_article['resource_collection']['collectionTitle'] = 'journal';
		$this->journal_article['possible'] = array('title', 'url', 'issn', 'number', 'volume', 'year', 'author', 
			'journal', 'pages', 'month');
// Newspaper article type
		$this->newspaper_article = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISSN',
					'field2'	=>	'address',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->newspaper_article['resource_publisher'] = array(); // need empty array
		$this->newspaper_article['resource_collection']['collectionTitle'] = 'journal';
		$this->newspaper_article['possible'] = array('title', 'url', 'issn', 'year', 'author', 'journal', 'pages', 
			'address', 'month');
// Magazine article type
		$this->magazine_article = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISSN',
					'field4'	=>	'volume',
					'field3'	=>	'number',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->magazine_article['resource_publisher'] = array(); // need empty array
		$this->magazine_article['resource_collection']['collectionTitle'] = 'journal';
		$this->magazine_article['possible'] = array('title', 'url', 'issn', 'number', 'volume', 'year', 'author', 
			'journal', 'pages', 'month');
// proceedings article
		$this->proceedings_article = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'series', // Series Title
					'field3'	=>	'volume', // Series number
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year2'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'editor',
				),
			);
		$this->proceedings_article['resource_publisher']['publisherName'] = 'organization';
		$this->proceedings_article['resource_publisher']['publisherLocation'] = 'location';
		$this->proceedings_article['resource_collection']['collectionTitle'] = 'booktitle';
		$this->proceedings_article['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'editor', 
			'publisher', 'address', 'organization', 'location', 'journal', 'pages', 'booktitle', 
			'series', 'volume');
// Conference Paper resource type -> 'misc'
		$this->conference_paper = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->conference_paper['resource_publisher']['publisherName'] = 'publisher';
		$this->conference_paper['resource_publisher']['publisherLocation'] = 'address';
		$this->conference_paper['resource_collection'] = array(); // need empty array
		$this->conference_paper['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher', 'address');
// proceedings (complete set)
		$this->proceedings = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year2'		=>	'year',
				),
				'resource_creator' =>	array( // we require an empty array to still be present
				),
			);
		$this->proceedings['resource_publisher']['publisherName'] = 'organization';
		$this->proceedings['resource_publisher']['publisherLocation'] = 'location';
		$this->proceedings['resource_collection'] = array(); // need empty array
		$this->proceedings['possible'] = array('title', 'url', 'isbn', 'year', 'organization', 'location');
// Thesis resource type
		$this->thesis = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISSN',
					'field3'	=>	'volume',
					'field4'	=>	'number',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->thesis['resource_publisher']['publisherName'] = 'school';
		$this->thesis['resource_publisher']['publisherLocation'] = 'address';
		$this->thesis['resource_collection']['collectionTitle'] = 'journal';
		$this->thesis['possible'] = array('title', 'url', 'issn', 'number', 'volume', 'year', 'author', 
			'school', 'address', 'journal', 'pages');
// Web article resource type -> 'misc' - URL dealt with in code
		$this->web_article = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISSN',
					'field1'	=>	'volume',
					'field2'	=>	'number',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year2'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->web_article['resource_publisher'] = array(); // need empty array
		$this->web_article['resource_collection']['collectionTitle'] = 'journal';
		$this->web_article['possible'] = array('title', 'url', 'issn', 'number', 'volume', 'year', 'author', 
			'journal', 'pages');
// Film resource type -> misc
		$this->film = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'address',
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // director
				),
				'howpublished'		=>	'film',
			);
		$this->film['resource_publisher']['publisherName'] = 'publisher'; // distributor
		$this->film['resource_collection'] = array(); // need empty array
		$this->film['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher', 'address');
// Broadcast resource type -> misc
		$this->broadcast = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // director
				),
				'howpublished'		=>	'broadcast',
			);
		$this->broadcast['resource_publisher']['publisherName'] = 'publisher'; // channel
		$this->broadcast['resource_publisher']['publisherLocation'] = 'address';
		$this->broadcast['resource_collection'] = array(); // need empty array
		$this->broadcast['possible'] = array('title', 'url', 'isbn', 'year', 'author', 
			'publisher', 'address');
// Music Album type -> misc
		$this->music_album = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Performer
				),
				'howpublished'		=>	'field2',
			);
		$this->music_album['resource_publisher']['publisherName'] = 'publisher';
		$this->music_album['resource_publisher']['publisherLocation'] = 'address';
		$this->music_album['resource_collection'] = array(); // need empty array
		$this->music_album['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher', 'address');
// Music Track type -> misc
		$this->music_track = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
				'howpublished'		=>	'field2',
			);
		$this->music_track['resource_publisher']['publisherName'] = 'publisher';
		$this->music_track['resource_publisher']['publisherLocation'] = 'address';
		$this->music_track['resource_collection']['collectionTitle'] = 'booktitle'; // album/collection
		$this->music_track['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher', 'address', 
			'booktitle');
// Music Score type -> misc
		$this->music_score = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field3'	=>	'edition',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Composer
					'creator2'	=>	'editor', // Editor
				),
				'howpublished'		=>	'Music Score',
			);
		$this->music_score['resource_publisher']['publisherName'] = 'publisher';
		$this->music_score['resource_publisher']['publisherLocation'] = 'address';
		$this->music_score['resource_collection'] = array(); // need empty array
		$this->music_score['possible'] = array('title', 'url', 'isbn', 'edition', 'year', 'author', 
			'editor', 'publisher', 'address');
// Software resource type -> misc
		$this->software = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field4'	=>	'edition', // Version
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Programmer
				),
				'howpublished'		=>	'field2',
			);
		$this->software['resource_publisher']['publisherName'] = 'publisher';
		$this->software['resource_publisher']['publisherLocation'] = 'address';
		$this->software['resource_collection'] = array(); // need empty array
		$this->software['possible'] = array('title', 'url', 'isbn', 'edition', 'year', 'author', 'publisher', 'address');
// Artwork resource type -> misc
		$this->artwork = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
				'howpublished'		=>	'field2',
			);
		$this->artwork['resource_publisher']['publisherName'] = 'publisher';
		$this->artwork['resource_publisher']['publisherLocation'] = 'address';
		$this->artwork['resource_collection'] = array(); // need empty array
		$this->artwork['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher', 'address');
// Audiovisual resource type -> misc
		$this->audiovisual = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'series',
					'field3'	=>	'edition',
					'field5'	=>	'volume',
				),
				'resource_misc'	=>	array(
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator5'	=>	'editor', // Series Editor
				),
				'howpublished'		=>	'field2',
			);
		$this->audiovisual['resource_publisher']['publisherName'] = 'publisher';
		$this->audiovisual['resource_publisher']['publisherLocation'] = 'address';
		$this->audiovisual['resource_collection'] = array(); // need empty array
		$this->audiovisual['possible'] = array('title', 'url', 'isbn', 'series', 'edition', 'volume', 
			'year', 'author', 'editor', 'publisher', 'address');
// Online database resource type -> misc
		$this->database = array(
				'resource'	=>	array(
					'isbn'		=>	'ISBN',
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year2'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->database['resource_publisher']['publisherName'] = 'publisher';
		$this->database['resource_collection'] = array(); // need empty array
		$this->database['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher');
// Government Report/Documentation resource type -> misc
		$this->government_report = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field2'	=>	'institution', // Department
					'field3'	=>	'edition',
					'field4'	=>	'volume',
					'field5'	=>	'number', // Issue number
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
					),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					),
				'howpublished'		=>	'Government Report',
			);
		$this->government_report['resource_publisher']['publisherName'] = 'publisher';
		$this->government_report['resource_collection'] = array(); // need empty array
		$this->government_report['possible'] = array('title', 'url', 'isbn', 'institution', 'edition', 
			'volume', 'number', 'year', 'author', 'publisher', 'pages');
// Report/Documentation resource type
		$this->report = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'series', // Series Title
					'field2'	=>	'type',
					'field5'	=>	'number', // Report number
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
					),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					),
			);
		$this->report['resource_publisher']['publisherName'] = 'institution';
		$this->report['resource_publisher']['publisherLocation'] = 'location';
		$this->report['resource_collection'] = array(); // need empty array
		$this->report['possible'] = array('title', 'url', 'isbn', 'series', 'type', 'number', 
			'year', 'author', 'institution', 'location', 'address', 'pages');
// Hearing resource type -> misc
		$this->hearing = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'booktitle', // Committee
					'field2'	=>	'journal', // Legislative Body
					'field3'	=>	'edition', // Session
					'field4'	=>	'number', // Document Number
					),
				'resource_misc'	=>	array(
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
					),
				'resource_creator' =>	array(  // empty array required
					),
				'howpublished'		=>	'Hearing',
			);
		$this->hearing['resource_publisher']['publisherName'] = 'publisher';
		$this->hearing['resource_publisher']['publisherLocation'] = 'address';
		$this->hearing['resource_collection'] = array(); // need empty array
		$this->hearing['possible'] = array('title', 'url', 'isbn', 'booktitle', 'journal', 'edition', 'number', 
			'year', 'publisher', 'address', 'pages');
// Statute type -> misc
		$this->statute = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'number', // Public Law Number
					'field2'	=>	'booktitle', // Code
					'field3'	=>	'edition', // Session
					'field5'	=>	'volume', // Code Number
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(  // empty array required
				),
				'howpublished'		=>	'Statute',
			);
		$this->statute['resource_publisher'] = array(); // need empty array
		$this->statute['resource_collection'] = array(); // need empty array
		$this->statute['possible'] = array('title', 'url', 'isbn', 'number', 'booktitle', 'edition', 'volume', 
			'year', 'pages');
// Legal Rule/Regulation resource type -> misc
		$this->legal_ruling = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'volume', // Section Number
					'field2'	=>	'type',
					'field3'	=>	'edition',
					'field4'	=>	'number', // Rule Number
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
				'howpublished'		=>	'Legal Ruling/Regulation',
			);
		$this->legal_ruling['resource_publisher']['publisherName'] = 'publisher';
		$this->legal_ruling['resource_publisher']['publisherLocation'] = 'address';
		$this->legal_ruling['resource_collection'] = array(); // need empty array
		$this->legal_ruling['possible'] = array('title', 'url', 'isbn', 'volume', 'type', 'edition', 'number', 
			'year', 'author', 'publisher', 'address', 'pages');
// case resource type -> misc
		$this->case = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'booktitle', // Reporter
					'field4'	=>	'volume', // Reporter Volume
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator3'	=>	'author', // Counsel
				),
				'howpublished'		=>	'Legal Case',
			);
		$this->case['resource_publisher']['publisherName'] = 'publisher';
		$this->case['resource_collection'] = array(); // need empty array
		$this->case['possible'] = array('title', 'url', 'isbn', 'booktitle', 'volume', 'year', 'author', 'publisher', 'pages');
// bill resource type -> misc
		$this->bill = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field2'	=>	'booktitle', // Code
					'field3'	=>	'volume', // Code Volume
					'field4'	=>	'edition', // Session
					'field5'	=>	'number', // Bill Number
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array( // we require an empty array to still be present
				),
				'howpublished'		=>	'Bill',
			);
		$this->bill['resource_publisher'] = array(); // need empty array
		$this->bill['resource_collection'] = array(); // need empty array
		$this->bill['possible'] = array('title', 'url', 'isbn', 'booktitle', 'volume', 'edition', 'number', 'year', 'pages');
// Patent type
		$this->patent = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'field8'	=>	'ISBN', // Patent Number
					'field1'	=>	'booktitle', // Published Source
					'field2'	=>	'volume', // Patent Version Number
					'field3'	=>	'number', // Application Number
					'field4'	=>	'type', // Patent Type
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Inventor
				),
			);
		$this->patent['resource_publisher']['publisherName'] = 'publisher'; // assignee
		$this->patent['resource_publisher']['publisherLocation'] = 'address';
		$this->patent['resource_collection'] = array(); // need empty array
		$this->patent['possible'] = array('title', 'url', 'isbn', 'volume', 'booktitle', 'number', 'type', 
			'year', 'author', 'publisher', 'address');
// Personal Communication type -> misc
		$this->personal = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'editor', // Recipient
				),
				'howpublished'		=>	'field2',
			);
		$this->personal['resource_publisher'] = array(); // need empty array
		$this->personal['resource_collection'] = array(); // need empty array
		$this->personal['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'editor');
// Unpublished type
		$this->unpublished = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field2'	=>	'type',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->unpublished['resource_publisher']['publisherName'] = 'institution'; // Institution
		$this->unpublished['resource_publisher']['publisherLocation'] = 'address'; // Institution Location
		$this->unpublished['resource_collection'] = array(); // need empty array
		$this->unpublished['possible'] = array('title', 'url', 'isbn', 'type', 'year', 'author', 'institution', 
			'address', 'pages');
// classical resource type -> misc
		$this->classical = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field4'	=>	'volume',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Attribution
				),
				'howpublished'		=>	'Classical Work',
			);
		$this->classical['resource_publisher'] = array(); // need empty array
		$this->classical['resource_collection'] = array(); // need empty array
		$this->classical['possible'] = array('title', 'url', 'isbn', 'volume', 'year', 'author');
// Manuscript type -> misc
		$this->manuscript = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field3'	=>	'number',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
				'howpublished'		=>	'field2',
			);
		$this->manuscript['resource_publisher'] = array(); // need empty array
		$this->manuscript['resource_collection']['collectionTitle'] = 'booktitle';
		$this->manuscript['possible'] = array('title', 'url', 'isbn', 'number', 'year', 'author', 'booktitle', 'pages');
// Map type -> misc
		$this->map = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field1'	=>	'series', // Series Title
					'field3'	=>	'edition',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Cartographer
					'creator5'	=>	'editor', // Series Editor
				),
				'howpublished'		=>	'field2',
			);
		$this->map['resource_publisher']['publisherName'] = 'publisher';
		$this->map['resource_publisher']['publisherLocation'] = 'address';
		$this->map['resource_collection'] = array(); // need empty array
		$this->map['possible'] = array('title', 'url', 'isbn', 'series', 'edition', 'year', 'author', 'editor', 			'publisher', 'address');
// Chart type -> misc
		$this->chart = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
					'field3'	=>	'size',
					'field5'	=>	'edition', // Version
					'field6'	=>	'number',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author', // Created By
				),
				'howpublished'		=>	'field4',
			);
		$this->chart['resource_publisher']['publisherName'] = 'publisher';
		$this->chart['resource_publisher']['publisherLocation'] = 'address';
		$this->chart['resource_collection'] = array(); // need empty array
		$this->chart['possible'] = array('title', 'url', 'isbn', 'size', 'edition', 'number', 'year', 'author', 
			'publisher', 'address');
// Miscellaneous resource type -> misc
		$this->miscellaneous = array(
				'resource'	=>	array(
					'url'		=>	'URL',
					'isbn'		=>	'ISBN',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
				'howpublished'		=>	'field2',
			);
		$this->miscellaneous['resource_publisher']['publisherName'] = 'publisher';
		$this->miscellaneous['resource_publisher']['publisherLocation'] = 'address';
		$this->miscellaneous['resource_collection'] = array(); // need empty array
		$this->miscellaneous['possible'] = array('title', 'url', 'isbn', 'year', 'author', 'publisher', 'address');
	}
}
?>
