<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* EIDT class
*
*****/
class EDIT
{
// Constructor
	function EDIT($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// If $noMenu, display Edit submenu links
	function display($noMenu = FALSE)
	{
		include_once("core/html/HTML.php");
		include_once("core/html/MISC.php");
		$html = new HTML();
		$this->template->setVar('heading', $this->messages->text("heading", "edit"));
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('edit');
			$this->template->setVar('noMenu', $pString);
			return $this->template->process();
		}
		return $this->template->process();
	}
// check we are allowed to edit
	function gateKeep($function)
	{
		if(!$this->session->getVar('setup_write'))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			return $authorize->initLogon();
		}
		else if(($function == 'editCreator') || ($function == 'editCreatorConfirm'))
		{
			include_once("core/creator/CREATOR.php");
			$obj = new CREATOR($this->db, $this->vars);
			if(!array_key_exists('edit_creatorId', $this->vars))
			{
				$this->session->setVar('editCreatorLock', FALSE);
				$this->session->clearArray("edit");
				return $obj->editDisplay();
			}
			else if(($function == 'editCreator') && !array_key_exists('edit_surname', $this->vars))
			{
				$this->session->setVar('editCreatorLock', FALSE);
				return $obj->editDisplayName();
			}
			else if(($function == 'editCreatorConfirm') && 
				!array_key_exists('edit_creatorExistId', $this->vars))
			{
				$this->session->setVar('editCreatorLock', FALSE);
				return $obj->editDisplayName();
			}
			if($function == 'editCreator')
				return $obj->edit();
			if($function == 'editCreatorConfirm')
				return $obj->editConfirm();
		}
		else if(($function == 'editCollection') || ($function == 'editCollectionConfirm'))
		{
			include_once("core/collection/COLLECTION.php");
			$obj = new COLLECTION($this->db, $this->vars);
			if(!array_key_exists('edit_collectionId', $this->vars))
			{
				$this->session->setVar('editCollectionLock', FALSE);
				$this->session->clearArray("edit");
				return $obj->editDisplay();
			}
			else if(($function == 'editCollection') && !array_key_exists('edit_title', $this->vars))
			{
				$this->session->setVar('editCollectionLock', FALSE);
				return $obj->editDisplayTitle();
			}
			else if(($function == 'editCollectionConfirm') && 
				!array_key_exists('edit_collectionExistId', $this->vars))
			{
				$this->session->setVar('editCollectionLock', FALSE);
				return $obj->editDisplayTitle();
			}
			if($function == 'editCollection')
				return $obj->edit();
			if($function == 'editCollectionConfirm')
				return $obj->editConfirm();
		}
		else if(($function == 'editPublisher') || ($function == 'editPublisherConfirm'))
		{
			include_once("core/publisher/PUBLISHER.php");
			$obj = new PUBLISHER($this->db, $this->vars);
			if(!array_key_exists('edit_publisherId', $this->vars))
			{
				$this->session->setVar('editPublisherLock', FALSE);
				$this->session->clearArray("edit");
				return $obj->editDisplay();
			}
			else if(($function == 'editPublisher') && !array_key_exists('edit_publisher', $this->vars))
			{
				$this->session->setVar('editPublisherLock', FALSE);
				return $obj->editDisplayPublisher();
			}
			else if(($function == 'editPublisherConfirm') && 
				!array_key_exists('edit_publisherExistId', $this->vars))
			{
				$this->session->setVar('editPublisherLock', FALSE);
				return $obj->editDisplayPublisher();
			}
			if($function == 'editPublisher')
				return $obj->edit();
			if($function == 'editPublisherConfirm')
				return $obj->editConfirm();
		}
		else if(($function == 'editKeyword') || ($function == 'editKeywordConfirm'))
		{
			include_once("core/keyword/KEYWORD.php");
			$obj = new KEYWORD($this->db, $this->vars);
			if(!array_key_exists('edit_keywordId', $this->vars))
			{
				$this->session->setVar('editKeywordLock', FALSE);
				$this->session->clearArray("edit");
				return $obj->editDisplay();
			}
			else if(($function == 'editKeyword') && !array_key_exists('edit_keyword', $this->vars))
			{
				$this->session->setVar('editKeywordLock', FALSE);
				return $obj->editDisplayKeyword();
			}
			else if(($function == 'editKeywordConfirm') && 
				!array_key_exists('edit_keywordExistId', $this->vars))
			{
				$this->session->setVar('editKeywordLock', FALSE);
				return $obj->editDisplayKeyword();
			}
			if($function == 'editKeyword')
				return $obj->edit();
			if($function == 'editKeywordConfirm')
				return $obj->editConfirm();
		}
	}
}
?>
