<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Creator class.
*****/
class CREATOR
{
// Constructor
	function CREATOR($db, $vars = FALSE)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/html/CLOSE.php");
		$this->names = array("creator1", "creator2", "creator3", "creator4", "creator5",);
	}
// Get creators from WKX_creators.  Return associative array of id => creator
	function grabAll($userBib = FALSE, $nameType = FALSE)
	{
		include_once("core/html/HTML.php");
		$html = new HTML();
		$condition = FALSE;
		if($userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($userBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$bibConditionArray[] = $this->db->tidyInput($resourceId);
			$condition .= " (" . $this->db->formatField("WKX_resource_creator.id") . " = " . 
				implode(" OR " . $this->db->formatField("WKX_resource_creator.id") . " = ",
				$bibConditionArray) . ")";
			$sql = $this->db->selectNoExecute(array('WKX_creator'), array(array('WKX_creator.id' => 'id'), 
				"surname", "initials", "firstname", "prefix"));
			$join = " LEFT JOIN " . $this->db->formatTable("WKX_resource_creator") . " ON ";
			if($nameType)
				$join .= "FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField($nameType) . ")";
			else
			{
				foreach($this->names as $type)
				{
					$joinArray[] = "FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
					$this->db->formatField($type) . ")";
				}
				$join .= join(" OR ", $joinArray);
			}
/*
			$join = " LEFT JOIN " . $this->db->formatTable("WKX_resource_creator") . " ON " . 
				" FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField("creator1") . ")
				 OR 
				FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField("creator2") . ")
				 OR 
				FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField("creator3") . ")
				 OR 
				FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField("creator4") . ")
				 OR 
				FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField("creator5") . ")";
*/
			$sql .= $join . " WHERE " . $condition. ' ORDER BY ' . $this->db->tidyInputClause('surname');
		}
		else
		{
			if($nameType)
			{
				$condition = " WHERE FIND_IN_SET(" . $this->db->formatField("WKX_creator.id") . ", " . 
				$this->db->formatField("WKX_resource_creator.$nameType") . ")";
				$sql = $this->db->selectNoExecute(array("WKX_creator", "WKX_resource_creator"), 
				array("WKX_creator.id", "surname", "initials", "firstname", "prefix"), $condition . 
				" ORDER BY " . $this->db->tidyInputClause("surname"));
			}
			else
				$sql = $this->db->selectNoExecute(array("WKX_creator"), array("WKX_creator.id", "surname", 
				"initials", "firstname", "prefix"), " ORDER BY " . $this->db->tidyInputClause("surname"));
		}
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$name = $row['prefix'] . " " . $row['surname'];
			if($row['firstname'])
				$name .= ", " . $row['firstname'] . " ";
			else if($row['initials'])
				$name .= ", " . implode(".", explode(" ", $row['initials'])) . ".";
			else
				$name .= implode(".", explode(" ", $row['initials']));
			$creators[$row['id']] = $html->dbToFormTidy(trim($name));
		}
		if(isset($creators))
			return $creators;
		return FALSE;
	}
// return a SQL condition clause when selecting by creator
	function selectCondition($input)
	{
		$condition = '';
		$selectArray = explode(",", $input['creator']);
		foreach($selectArray as $key => $value)
		{
			$creatorArray = array();
			foreach($this->names as $creator)
				$creatorArray[] = "FIND_IN_SET(" . $this->db->tidyInput($value) . ", " . 
				$this->db->formatfield($creator) . ")";
			$conditionArray[] = "(" . implode(" OR ", $creatorArray) . ")";
		}
		$condition .= implode(" " . $input['creatorMethod'] . " ", $conditionArray);
		return $condition;
	}
// write names to WKX_creator and return creator id array.
	function writeCreatorTable($sessionVars, $id = FALSE)
	{
		$this->createNames($sessionVars);
		$names = $this->names;
		foreach($names as $name)
		{
			if(!isset($this->$name))
				continue;
			$ids = array();
			foreach($this->$name as $key => $nameArray)
			{
				$fields = $values = array();
				if(array_key_exists('id', $nameArray))
				{
					$ids[] = $nameArray['id'];
					continue;
				}
				$surname = array_key_exists('surname', $nameArray) ? 
					$this->html->removeNl($nameArray['surname']) : FALSE;
				$firstname = array_key_exists('firstname', $nameArray) ? 
					$this->html->removeNl($nameArray['firstname']) : FALSE;
				$initials = array_key_exists('initials', $nameArray) ? 
					$this->html->removeNl($nameArray['initials']) : FALSE;
				$prefix = array_key_exists('prefix', $nameArray) ? 
					$this->html->removeNl($nameArray['prefix']) : FALSE;
// given name doesn't exist so now write to db
				if($surname)
				{
					$fields[] = "surname";
					$values[] = $surname;
				}
				if($firstname)
				{
					$fields[] = "firstname";
					$values[] = $firstname;
				}
				if($initials)
				{
					$fields[] = "initials";
					$values[] = $initials;
				}
				if($prefix)
				{
					$fields[] = "prefix";
					$values[] = $prefix;
				}
				if(isset($fields))
				{
					if($id = $this->checkExists($surname, $firstname, $initials, $prefix))
						$ids[] = $id;
					else
					{
						$this->db->insert('WKX_creator', $fields, $values);
						$id = $this->db->lastAutoId('WKX_creator');
						$ids[] = $id;
					}
				}
			}
			if(!empty($ids))
				$idArray[$name] = $ids;
		}
		if(!isset($idArray))
			return FALSE;
		foreach($idArray as $key => $value)
			$array[$key] = $value;
		return $array;
	}
// create name arrays from user input
	function createNames($sessionVars)
	{
		foreach($this->names as $name)
		{
			$input = array();
			foreach($sessionVars as $key => $value)
			{
				$base = $name . "_";
				if(preg_match("/^$base(.*)/", $key, $match))
					$input[$match[1]] = trim($value);
			}
			if(empty($input))
				continue;
// split on "_"
			foreach($input as $key => $value)
			{
				$components = explode("_", $key);
				if($components[1] == 'initials')
					${$name}[$components[0]][$components[1]] = $this->formatInitials(trim($value));
				else
					${$name}[$components[0]][$components[1]] = trim($value);
			}
			$this->$name = $$name;
			ksort($this->$name);
		}
	}
// Does this creator already exist in the database?
	function checkExists($surname, $firstname, $initials, $prefix)
	{
		if($surname)
			$conditions[] = "LOWER(" . $this->db->formatField('surname') . ")=" . 
				$this->db->tidyInput(strtolower($surname));
		else
			$conditions[] = "LOWER(" . $this->db->formatField('surname') . ") IS NULL";
		if($firstname)
			$conditions[] = "LOWER(" . $this->db->formatField('firstname') . ")=" . 
				$this->db->tidyInput(strtolower($firstname));
		else
			$conditions[] = "LOWER(" . $this->db->formatField('firstname') . ") IS NULL";
		if($initials)
			$conditions[] = "LOWER(" . $this->db->formatField('initials') . ")=" . 
				$this->db->tidyInput(strtolower($initials));
		else
			$conditions[] = "LOWER(" . $this->db->formatField('initials') . ") IS NULL";
		if($prefix)
			$conditions[] = "LOWER(" . $this->db->formatField('prefix') . ")=" . 
				$this->db->tidyInput(strtolower($prefix));
		else
			$conditions[] = "LOWER(" . $this->db->formatField('prefix') . ") IS NULL";
		$condition = " WHERE " . implode(" AND ", $conditions);
		$recordset = $this->db->select(array('WKX_creator'), array('id'), $condition);
		if($this->db->numRows($recordset))
			return $this->db->fetchOne($recordset);
		return FALSE;
	}
// Format initials prior to storing in database
// Initials are stored uppercase, unpunctuated and space-delimited.
// In the final result, they can only consist of a-Z and space characters
	function formatInitials($raw)
	{
		return implode(' ', preg_split('//', 
			strtoupper(preg_replace('/\W+/', '', $raw)), -1, PREG_SPLIT_NO_EMPTY));
	}
// Remove resource-less creators - done after a row has been deleted from WKX_resource_creators.
	function removeHangingNoRow($resourceId)
	{
		$oldCreatorIds = array();
		$types = $this->names;
		$recordset = $this->db->select(array('WKX_resource_creator'), $types, 
			" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
		while($row = $this->db->loopRecordSet($recordset))
		{
			foreach($types as $type)
				$oldCreatorIds = array_merge(explode(',',  $row[$type]), $oldCreatorIds);
		}
		return $oldCreatorIds;
	}
// Does this creator ID have a resource attached to it?  - done after a row has been deleted from WKX_resource_creators.
	function checkAttachedNoRow($ids)
	{
		$types = $this->names;
		foreach($ids as $id)
		{
			$condition = array();
			foreach($types as $type)
				$condition[] = "FIND_IN_SET(" . $this->db->tidyInput($id) . ", " . 
				$this->db->formatField($type) . ")";
			$recordset = $this->db->select(array('WKX_resource_creator'), array('id'), 
				" WHERE " . implode(" OR ", $condition));
			if(!$this->db->numRows($recordset))
				$this->db->delete('WKX_creator', " WHERE " . $this->db->formatField('id') . "=" . $id);
		}
		$this->db->optimize('WKX_creator');
	}
// Remove resource-less creators - done before update to WKX_resource_creator while that row exists.
	function removeHanging($resourceId, $newCreatorIds)
	{
		$oldCreatorIds = array();
		$types = $this->names;
		$recordset = $this->db->select(array('WKX_resource_creator'), $types, 
			" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
		while($row = $this->db->loopRecordSet($recordset))
		{
			foreach($types as $type)
				$oldCreatorIds = array_merge(explode(',',  $row[$type]), $oldCreatorIds);
		}
		foreach($newCreatorIds as $array)
				$oldCreatorIds = array_diff($oldCreatorIds, $array);
		foreach($oldCreatorIds as $id)
		{
			if($found = $this->checkAttached($id))
			{
				if($found == $resourceId)
					$this->db->delete('WKX_creator', 
						" WHERE " . $this->db->formatField('id') . "=" . $id);
			}
		}
		$this->db->optimize('WKX_creator');
	}
// Does this creator ID have a resource attached to it?  Done prior to updating WKX_resource_creator
	function checkAttached($creatorId)
	{
		if(!$creatorId)
			return FALSE;
		$types = $this->names;
		foreach($types as $type)
			$condition[] = "FIND_IN_SET(" . $this->db->tidyInput($creatorId) . ", " . 
			$this->db->formatField($type) . ")";
		$recordset = $this->db->select(array('WKX_resource_creator'), array('id'), 
			" WHERE " . implode(" OR ", $condition));
		if($this->db->numRows($recordset) == 1)
			return $this->db->fetchOne($recordset);
		return FALSE;
	}
// display the list of names:
	function editDisplay($message = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "creator") . ")"));
		$pString = $message ? $message : FALSE;
		$creators = $this->grabAll();
		if(!$creators)
		{
			$this->template->setVar('body', $this->messages->text("misc", "noCreators"));
			return $this->template->process();
		}
		$pString .= FORM::formHeader("editCreator");
		$pString .= FORM::selectFBoxValue(FALSE, "edit_creatorId", $creators, 20);
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display the editing form:
	function editDisplayName()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "creator") . ")"));
		$this->checkInput1();
		$sessionVars = $this->fromDbToSession($this->vars['edit_creatorId']);
		$pString = FORM::formHeader("editCreator");
		$pString .= FORM::hidden("edit_creatorId", $this->vars['edit_creatorId']);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("firstname", $sessionVars) ? $sessionVars["firstname"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "firstname"), 
			"edit_firstname", $text, 30, 255));
		$text = array_key_exists("initials", $sessionVars) ? $sessionVars["initials"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "initials"), 
			"edit_initials", $text, 6, 5));
		$text = array_key_exists("prefix", $sessionVars) ? $sessionVars["prefix"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "prefix"), 
			"edit_prefix", $text, 11, 10));
		$text = array_key_exists("surname", $sessionVars) ? $sessionVars["surname"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "surname"), 
			"edit_surname", $text, 30, 255) . " " . MISC::span('*', 'required'));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd() . MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database
	function edit()
	{
		if($this->session->getVar('editCreatorLock'))
			$this->badInput($this->errors->text("done", "creator"));
		$this->checkInput2();
		$fields[] = 'surname';
		$values[] = $surname = trim($this->vars['edit_surname']);
		if(trim($this->vars['edit_firstname']))
		{
			$fields[] = 'firstname';
			$values[] = $firstname = trim($this->vars['edit_firstname']);
		}
		else
		{
			$firstname = FALSE;
			$nulls[] = 'firstname';
		}
		if(trim($this->vars['edit_initials']))
		{
			$initials = $this->formatInitials(trim($this->vars['edit_initials']));
			$fields[] = 'initials';
			$values[] = $initials;
		}
		else
		{
			$initials = FALSE;
			$nulls[] = 'initials';
		}
		if(trim($this->vars['edit_prefix']))
		{
			$fields[] = 'prefix';
			$values[] = $prefix = trim($this->vars['edit_prefix']);
		}
		else
		{
			$prefix = FALSE;
			$nulls[] = 'prefix';
		}
		if($creatorExistId = $this->checkExists($surname, $firstname, $initials, $prefix))
		{
			if($creatorExistId != $this->vars['edit_creatorId'])
				return $this->confirmDuplicate($creatorExistId, $surname, 
				$firstname, $initials, $prefix);
		}
		foreach($fields as $field)
			$updateArray[$field] = array_shift($values);
		$this->db->update('WKX_creator', $updateArray, 
			"WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($this->vars['edit_creatorId']));
// set to NULL empty firstname and initials fields
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_creator', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . 
				$this->db->tidyInput($this->vars['edit_creatorId']));
// lock reload
		$this->session->setVar('editCreatorLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("creator")));
	}
/**
* The new name equals one already in the database. Confirm that this edited one is to be removed and 
* all references to it replaced by the existing one.
*/
	function confirmDuplicate($creatorExistId, $surname, $firstname, $initials, $prefix)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "creator") . ")"));
		$pString = $this->errors->text("warning", "creatorExists");
		$pString .= MISC::p($this->messages->text("creators", "creatorExists"));
		$pString .= FORM::formHeader("editCreatorConfirm");
		$pString .= FORM::hidden("edit_creatorId", $this->vars['edit_creatorId']);
		$pString .= FORM::hidden("edit_creatorExistId", $creatorExistId);
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database.
	function editConfirm()
	{
		if($this->session->getVar('editCreatorLock'))
			$this->badInput($this->errors->text("done", "creator"));
		$editId = $this->vars['edit_creatorId'];
		$existId = $this->vars['edit_creatorExistId'];
// Delete old creator
		$this->db->delete("WKX_creator", "WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($editId));
// Select all resources referencing this old creator and replace reference with existing creator
		$sql = $this->db->selectNoExecute(array("WKX_resource_creator"), array('id', 'creator1', 'creator2', 
			'creator3', 'creator4', 'creator5'));
		$creators = array('creator1', 'creator2', 'creator3', 'creator4', 'creator5');
		foreach($creators as $creator)
			$conditions[] = "FIND_IN_SET(" . $this->db->tidyInput($editId) . 
			"," . $this->db->formatField($creator) . ")";
		$condition = "WHERE " . join(" OR ", $conditions);
		$recordset = $this->db->query($sql . $condition);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$updateArray = array();
			foreach($creators as $creator)
			{
				if($row[$creator])
				{
					$oldArray = explode(",", $row[$creator]);
// If $existId already in db field, simply remove editId
					if(array_search($existId, $oldArray) !== FALSE)
					{
						unset($oldArray[array_search($editId, $oldArray)]);
						$updateArray[$creator] = join(",", $oldArray);
					}
// else, if this creator field has $editId in it, replace it with $existId
					else if(($editIndex = array_search($editId, $oldArray)) !== FALSE)
					{
						$oldArray[$editIndex] = $existId;
						$updateArray[$creator] = join(",", $oldArray);
					}
				}
			}
			if(!empty($updateArray))
				$this->db->update('WKX_resource_creator', $updateArray, 
					"WHERE " . $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($row['id']));
		}
// lock reload
		$this->session->setVar('editCreatorLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("creator")));
	}
// from database to session
	function fromDbToSession($id)
	{
		$recordset = $this->db->select(array('WKX_creator'), 
			array("surname", "firstname", "initials", "prefix"), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($id));
		$row = $this->db->fetchRow($recordset);
		if($row['initials'])
			$this->session->setVar("edit_initials", 
			implode("", explode(" ", $this->html->dbToFormTidy($row['initials']))));
		if($row['firstname'])
			$this->session->setVar("edit_firstname", $this->html->dbToFormTidy($row['firstname']));
		if($row['prefix'])
			$this->session->setVar("edit_prefix", $this->html->dbToFormTidy($row['prefix']));
		$this->session->setVar("edit_surname", $this->html->dbToFormTidy($row['surname']));
		return $this->session->getArray("edit");
	}
// Check we have appropriate input
	function checkInput1()
	{
		if(!array_key_exists('edit_creatorId', $this->vars) || !$this->vars['edit_creatorId'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Check we have appropriate input
	function checkInput2()
	{
		if(!array_key_exists('edit_creatorId', $this->vars) || !$this->vars['edit_creatorId'])
			$this->badInput($this->errors->text("inputError", "missing"));
		if(!array_key_exists('edit_surname', $this->vars) || !trim($this->vars['edit_surname']))
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Error handling - send them back to view creator list.
	function badInput($error)
	{
		new CLOSE($this->db, $this->editDisplay($error));
	}
}
?>
