<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*
*	Cookie functions
*
*****/
class COOKIE
{
// Constructor
	function COOKIE()
	{
// whatever array cookie variables are in, we grab 'em.
		global $HTTP_COOKIE_VARS;
		if(isset($_COOKIE))
			$this->cookieVars = &$_COOKIE;
		else if(isset($HTTP_COOKIE_VARS))
			$this->cookieVars = &$HTTP_COOKIE_VARS;
	}
// Set a cookie if user requests through mywikindx 'remember me' checkbox
// store only username and password so user does not have to go through initial authentication
	function storeCookie($username)
	{
		$valueArray = array('username' => $username);
		$value = base64_encode(serialize($valueArray));
		$expire = 60*60*24*100; // 100 days
		$path = "/";
// we don't fail if this cookie can't be set.
		setcookie("wikindx", $value, time() + $expire, $path);
	}
// remove cookie
	function deleteCookie()
	{
		setcookie("wikindx", "", time() - 3600, "/");
	}
// get a cookie
	function grabCookie($db)
	{
		if(array_key_exists('wikindx', $this->cookieVars))
			$cookieArray = unserialize(base64_decode($this->cookieVars['wikindx']));
		else
			return FALSE; // no cookie set
		if(!array_key_exists('username', $cookieArray) || !$cookieArray['username'])
			return FALSE; // invalid cookie
// cookie set so check for valid username
		$recordSet = $db->select(array('WKX_users'), array('username', 'id', 'admin'), 
			" WHERE " . $db->formatField('username') . "=" . $db->tidyInput($cookieArray['username']));
		if(!$db->numRows($recordSet))
			return FALSE;
		include_once("core/user/USER.php");
		$user = new USER($db);
		$user->environment($db->fetchRow($recordSet));
		return TRUE;
	}
}
?>
