<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Collection class.
*	A collection is a journal, edited book, CD etc. - something which has 
*	multiple resources within it.
*****/
class COLLECTION
{
// Constructor
	function COLLECTION($db, $vars = FALSE)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/collection/COLLECTIONMAP.php");
		$this->map = new COLLECTIONMAP();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/html/CLOSE.php");
	}
// Get collection from WKX_collection.  Return associative array of id => collection
	function grabAll($type = FALSE, $userBib = FALSE)
	{
		if($type)
			$condition[] = "(". $this->db->formatField('collectionType') . "=" . 
			$this->db->tidyInput($this->map->collectionTypes[$type]) . ")";
		if($userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($userBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$bibConditionArray[] = $this->db->tidyInput($resourceId);
			$condition[] = " (WKX_resource_misc.id = " . 
				implode(" OR WKX_resource_misc.id = ", $bibConditionArray) . ")";
			$sql = $this->db->selectNoExecute(array('WKX_collection'), array(array('WKX_collection.id' => 'id'), 
				"collectionTitle", "collectionTitleShort"));
			$join = " LEFT JOIN " . $this->db->formatTable("WKX_resource_misc") . " ON " . 
				$this->db->formatField("WKX_collection.id") . "=" . 
				$this->db->formatField("collection");
			$sql .= $join;
		}
		else
			$sql = $this->db->selectNoExecute(array("WKX_collection"), 
			array("id", "collectionTitle", "collectionTitleShort"));
		if(isset($condition))
			$condition = " WHERE " . join(" AND ", $condition);
		else
			$condition = FALSE;
		$sql .= $condition . " ORDER BY " . $this->db->tidyInputClause("collectionTitle");
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$short = $row['collectionTitleShort'] ? 
				": " . $this->html->dbToFormTidy($row['collectionTitleShort']) : FALSE;
			$collections[$row['id']] = $this->html->dbToFormTidy($row['collectionTitle']) . $short;
		}
		if(isset($collections))
			return $collections;
		return FALSE;
	}
// return a SQL condition clause when selecting by collection
// For use in WKX_resource_misc
	function selectCondition($input)
	{
		$condition = '';
		$selectArray = explode(",", $input['collection']);
		foreach($selectArray as $key => $value)
			$conditionArray[] = $this->db->formatfield('collection') . "=" . $this->db->tidyInput($value);
		$condition .= implode(" " . $input['collectionMethod'] . " ", $conditionArray);
		return $condition;
	}
// write to WKX_collection
	function writeCollectionTable($sessionVars, $id = FALSE)
	{
		if(array_key_exists('collection_id', $sessionVars))
			return $sessionVars['collection_id'];
		$title = array_key_exists('collection', $sessionVars) ? 
			stripslashes($this->html->removeNl($sessionVars['collection'])) : FALSE;
		$short = array_key_exists('collectionShort', $sessionVars) ? 
			stripslashes($this->html->removeNl($sessionVars['collectionShort'])) : FALSE;
		$type = array_key_exists('type', $sessionVars) ? 
			stripslashes($this->html->removeNl($sessionVars['type'])) : FALSE;
		$collectionType = array_key_exists($type, $this->map->collectionTypes) ? 
			$this->map->collectionTypes[$type] : FALSE;
		if(!$title || !$collectionType)
			return FALSE;
//		if($id = $this->checkExists($title, $short, $collectionType))
//			return $id;
		list($id, $collectionTypeDB) = $this->checkExists($title, $short);
		if($id)
		{
			if(($collectionType != $collectionTypeDB))
				$this->db->update('WKX_collection', array('collectionType' => $collectionType), 
					" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($id));
			return $id;
		}
// collection not yet in db, so write to db.
		$fields[] = "collectionTitle";
		$values[] = $title;
		if($short)
		{
			$fields[] = "collectionTitleShort";
			$values[] = $short;
		}
		if($collectionType)
		{
			$fields[] = "collectionType";
			$values[] = $collectionType;
		}
		if(!isset($fields))
			return FALSE;
		$this->db->insert('WKX_collection', $fields, $values);
		return $this->db->lastAutoId('WKX_collection');
	}
// check to see if collection title already exists
	function checkExists($title, $short, $collectionType = FALSE)
	{
		if(!$short)
		{
			$condition = " WHERE LOWER(" . $this->db->formatField('collectionTitle') . ")=" . 
				$this->db->tidyInput(strtolower($title)) . 
				" AND " . $this->db->formatField('collectionTitleShort') . " IS NULL";
			if($collectionType)
				$condition .= " AND " . $this->db->formatField('collectionType') . 
				"=" . $this->db->tidyInput($collectionType);
		}
		else
		{
			$condition = " WHERE LOWER(" . $this->db->formatField('collectionTitle') . ")=" . 
				$this->db->tidyInput(strtolower($title)) . 
				" AND 
				LOWER(" . $this->db->formatField('collectionTitleShort') . 
				")=" . $this->db->tidyInput(strtolower($short));
			if($collectionType)
				$condition .= " AND " . $this->db->formatField('collectionType') . 
				"=" . $this->db->tidyInput($collectionType);
		}
		$recordset = $this->db->select(array('WKX_collection'), array('id', 'collectionType'), $condition);
		if($this->db->numRows($recordset))
		{
			$row = $this->db->fetchRow($recordset);
			return array($row['id'], $row['collectionType']);
		}
		return FALSE;
	}
// Remove resource-less collection
	function removeHanging($id = FALSE)
	{
		if($id)
		{
			$recordset = $this->db->select(array('WKX_resource_misc'), 
				array('id'), 
				" WHERE " . $this->db->formatField('collection') . " = $id");
			if(!$this->db->numRows($recordset))
				$this->db->delete('WKX_collection', 
					" WHERE " . $this->db->formatField('id') . "=" . $id);
		}
		else
		{
			$recordset = $this->db->select(array('WKX_collection'), array('id'));
			while($row = $this->db->loopRecordSet($recordset))
				$collectionIds[] = $row['id'];
			$recordset = $this->db->select(array('WKX_resource_misc'), array("collection"));
			while($row = $this->db->loopRecordSet($recordset))
			{
				if($row['collection'])
					$miscCollectionIds[] = $row['collection'];
			}
			if(isset($collectionIds))
			{
				$deleteIds = isset($miscCollectionIds) ? 
					array_diff($collectionIds, $miscCollectionIds) : $collectionIds;
				foreach($deleteIds as $id)
					$this->db->delete('WKX_collection', 
						" WHERE " . $this->db->formatField('id') . "=" . $id);
			}
		}
		$this->db->optimize('WKX_collection');
	}
// display the list of collection:
	function editDisplay($message = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "collection") . ")"));
		$pString = $message ? $message : FALSE;
		$collections = $this->grabAll();
		if(!$collections)
		{
			$this->template->setVar('body', $this->messages->text("misc", "noCollections"));
			return $this->template->process();
		}
		$pString .= FORM::formHeader("editCollection");
		$pString .= FORM::selectFBoxValue(FALSE, "edit_collectionId", $collections, 20);
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display the editing form:
	function editDisplayTitle()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "title") . ")"));
		$this->checkInput1();
		$sessionVars = $this->fromDbToSession($this->vars['edit_collectionId']);
		$pString = FORM::formHeader("editCollection");
		$pString .= FORM::hidden("edit_collectionId", $this->vars['edit_collectionId']);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("title", $sessionVars) ? $sessionVars["title"] : FALSE;
		$short = array_key_exists("titleShort", $sessionVars) ? $sessionVars["titleShort"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "collection"), 
			"edit_title", $text, 60, 255) . " " . MISC::span('*', 'required'));
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "collectionShort"), 
			"edit_titleShort", $short, 20, 255));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd() . MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database
	function edit()
	{
		if($this->session->getVar('editCollectionLock'))
			$this->badInput($this->errors->text("done", "collection"));
		$this->checkInput2();
		$fields[] = 'collectionTitle';
		$values[] = $this->vars['edit_title'];
		if(trim($this->vars['edit_titleShort']))
		{
			$fields[] = 'collectionTitleShort';
			$values[] = $this->vars['edit_titleShort'];
		}
		else
			$nulls[] = 'collectionTitleShort';
		foreach($fields as $field)
			$updateArray[$field] = array_shift($values);
		if($collectionExistId = $this->checkExists(trim($this->vars['edit_title']), 
			trim($this->vars['edit_titleShort'])))
		{
			if($collectionExistId != $this->vars['edit_collectionId'])
				return $this->confirmDuplicate($collectionExistId);
		}
		$this->db->update('WKX_collection', $updateArray, 
			"WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($this->vars['edit_collectionId']));
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_collection', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->vars['edit_collectionId']);
// lock reload
		$this->session->setVar('editCollectionLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("collection")));
	}
/**
* The new name equals one already in the database. Confirm that this edited one is to be removed and 
* all references to it replaced by the existing one.
*/
	function confirmDuplicate($collectionExistId)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "collection") . ")"));
		$pString = $this->errors->text("warning", "collectionExists");
		$pString .= MISC::p($this->messages->text("misc", "collectionExists"));
		$pString .= FORM::formHeader("editCollectionConfirm");
		$pString .= FORM::hidden("edit_collectionId", $this->vars['edit_collectionId']);
		$pString .= FORM::hidden("edit_collectionExistId", $collectionExistId);
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database.
	function editConfirm()
	{
		if($this->session->getVar('editCollectionLock'))
			$this->badInput($this->errors->text("done", "collection"));
		$editId = $this->vars['edit_collectionId'];
		$existId = $this->vars['edit_collectionExistId'];
// Delete old collection
		$this->db->delete("WKX_collection", "WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($editId));
// Select all resources referencing this old collection and replace reference with existing collection.
		$sql = $this->db->selectNoExecute(array("WKX_resource_misc"), array('id'), 
			" WHERE " . $this->db->formatField('collection') . "=" . $this->db->tidyInput($editId)
			);
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$this->db->update('WKX_resource_misc', array('collection' => $existId), 
				"WHERE " . $this->db->formatField('id') . "=" . 
				$this->db->tidyInput($row['id']));
		}
// lock reload
		$this->session->setVar('editCollectionLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("collection")));
	}
// from database to session
	function fromDbToSession($id)
	{
		$recordset = $this->db->select(array('WKX_collection'), array("collectionTitle", "collectionTitleShort"), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($id));
		$title = $this->db->fetchRow($recordset);
		$this->session->setVar("edit_title", $this->html->dbToFormTidy($title['collectionTitle']));
		if($title['collectionTitle'])
			$this->session->setVar("edit_titleShort", 
			$this->html->dbToFormTidy($title['collectionTitleShort']));
		return $this->session->getArray("edit");
	}
// Check we have appropriate input
	function checkInput1()
	{
		if(!array_key_exists('edit_collectionId', $this->vars) || !$this->vars['edit_collectionId'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Check we have appropriate input
	function checkInput2()
	{
		if(!array_key_exists('edit_collectionId', $this->vars) || !$this->vars['edit_collectionId'])
			$this->badInput($this->errors->text("inputError", "missing"));
		if(!array_key_exists('edit_title', $this->vars) || !trim($this->vars['edit_title']))
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Error handling - send them back to view creator list.
	function badInput($error)
	{
		new CLOSE($this->db, $this->editDisplay($error));
	}
}
?>
