/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
// MG 14/Dec/2004 - added licence information.

var citeTargetId; // use to hold the target element Id

// NOTE: Look at bottom of file for 'onload' events

function setCiteTarget(){
 var queryString = location.href;
 queryString = queryString.match(/method=.+$/i);
 var method = queryString[0].split('=');
 method = method[1];
 citeTargetId = method+'Text';
 // special cases
 if (method == 'quoteComment' || method == 'paraphraseComment'){
  citeTargetId = method;
 }
}

function handleCiteForm(e){
 if (isValidCiteForm(e)){ // validate that cite data exists
  setCiteInParent(); // we have data, send it over
  window.close();
 }
}

function setCiteInParent(){
 var citeString = getCiteString();
 var targetElement = window.opener.document.getElementById(citeTargetId);
 targetElement.value += ' ' + citeString; // append [cite] to existing <textarea> value
}

function getCiteString(){
 var citeSelect = document.getElementById('cite');
 var pageStart = document.forms[0].elements['pageStart'];
 var pageEnd = document.forms[0].elements['pageEnd'];
 var citeString = '[cite]'+ citeSelect.value; // resource Id
 if (pageStart.value.length > 0){ // page start exists
  citeString += ':' + pageStart.value;
  if (pageEnd.value.length > 0){ // page end exists
   citeString += '-'+pageEnd.value;
  }
 }
 else if (pageEnd.value.length > 0){ // no page start, but page end exists
  citeString += ':' + pageEnd.value;
 }
 citeString += '[/cite]';
 return citeString;
}

function isValidCiteForm(e){
 // check <select> list
 var citeSelect = document.getElementById('cite');
 var citeSelectOptions = citeSelect.options;
 var isCiteSelected = false;
 for (var i=0; i < citeSelectOptions.length; i++){ // check to see if any are selected
  if (citeSelectOptions[i].selected){
   isCiteSelected = true;
	break;
  }
 }
 if (isCiteSelected == false){ // no <option> was selected
  alert('Please select a resource to cite.');
  citeSelect.focus();
  return false;
 }
 return true;
}

// NOTE: The following assumes the DOM has already been loaded and formed
setCiteTarget();
var citeForm = document.getElementsByTagName('form').item(0);
citeForm.onsubmit = handleCiteForm;