<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/**
*	CITEFORMAT class.
*	Format citations according to the requested style.
*
*	@author		Mark Grimshaw
*	@version	1
*/

class CITEFORMAT
{
	function CITEFORMAT($db, $vars, $output = 'html')
	{
		$this->db = $db;
		$this->vars = $vars;
		$this->output = $output;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/CLOSEPOPUP.php");
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/styles/BIBFORMAT.php");
		$this->bf = new BIBFORMAT();
		$this->bf->type = 'citation';
		$this->bf->output = $this->output;
		include_once("core/styles/STYLEMAP.php");
		$this->map = new STYLEMAP();
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
/**
* Load the citation array which has been written to session in core/styles/BIBSTYLE.php.
*/
		if(!$this->session->getVar("cite_citation"))
		{
			$setupStyle = $this->session->getVar("setup_style");
			list($info, $citation, $styleCommon, $styleTypes) =
				$this->bf->loadStyle("styles/bibliography/", $setupStyle);
			$this->session->setVar("style_name", $info['name']);
			$this->session->setVar("cite_citation", base64_encode(serialize($citation)));
			$this->session->setVar("style_common", base64_encode(serialize($styleCommon)));
			$this->session->setVar("style_types", base64_encode(serialize($styleTypes)));
			$this->session->delVar("style_edited");
		}
		else
			$citation = unserialize(base64_decode($this->session->getVar("cite_citation")));
		foreach($citation as $array)
		{
			if(array_key_exists('_NAME', $array) && array_key_exists('_DATA', $array))
				$this->citation[$array['_NAME']] = $array['_DATA'];
		}
		$this->parseTemplate();
	}
/**
* Parse and load the XML citation template
*
* @author	Mark Grimshaw
* @version	1
*/
	function parseTemplate()
	{
		include_once("core/admin/ADMINSTYLE.php");
		$this->template = ADMINSTYLE::parseStringToArray('citation',
			trim($this->citation['template']), $this->map);
		if(array_key_exists('independent', $this->template))
		{
			$ind1 = $this->template['independent'];
			foreach($ind1 as $key => $value)
			{
				$split = split('_', $key);
				$ind2[$split[1]] = $value;
			}
			if(isset($ind2))
				$this->template['independent'] = $ind2;
		}
	}
/**
* Format the citation string according to the bibliographic style.
*
* @author	Mark Grimshaw
* @version	1
*
* @param	string $input	String to parse for [cite]...[/cite]
* @param	boolean $link	If TRUE, make a hyperlink
* @return	string
*/
	function citeParse($input, $link = TRUE)
	{
		$this->citeLink = $link;
		$this->previousCreator = FALSE;
	       	return preg_replace_callback("/\[cite\](.*?)\[\/cite\]/i",
			array($this, "citeParseCallback"), $input);
	}
/**
* Callback function for citeParse() above.
*
* @author	Mark Grimshaw
* @version	1
*
* @param	array $matches
* @return	string
*/
	function citeParseCallback($matches)
	{
		$cite = split(":", trim($matches[1]), 2);
//print_r($matches[1]); print "<P>";
// $cite[0] = resource ID
		$id = trim($cite[0]);
		$ID = isset($this->citation['templateSuperscript']) ? '[sup]' . $id . '[/sup]' : $id;
		$this->bf->addItem($ID, 'ID');
		$recordset = $this->db->select(array('WKX_resource'), array('year1', 'creator1'),
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_year") . " ON " . 
				$this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_year.id") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_creator") . " ON " . 
				$this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_creator.id") . 
			" WHERE " . $this->db->formatField("WKX_resource.id") . "=". $this->db->tidyInput($id));
		if(!$this->db->numRows($recordset))
			return MISC::span($this->messages->text("resources", "noResult"), "error");
		$row = $this->db->fetchRow($recordset);
// Grab creator surname
		if($row['creator1'])
		{
			$ids = split(",", $row['creator1']);
			$recordset = $this->db->select(array('WKX_creator'), array('surname', 'firstname', 'initials',
				'prefix'),
				" WHERE " . $this->db->formatField('id') . "=" .
				join(" OR " . $this->db->formatField('id') ." = ", $ids));
			$index = 0;
			while($creatorRow = $this->db->loopRecordSet($recordset))
			{
				$creators[$index]['surname'] = stripslashes($creatorRow['surname']);
				$creators[$index]['firstname'] = stripslashes($creatorRow['firstname']);
				$creators[$index]['initials'] = stripslashes($creatorRow['initials']);
				$creators[$index]['prefix'] = stripslashes($creatorRow['prefix']);
				$index++;
			}
			$thisCreator = $this->bf->formatNames($creators, 'citation', $this->citation);
			if($thisCreator != $this->previousCreator)
			{
				$this->bf->addItem($thisCreator, 'creator');
				$this->previousCreator = $thisCreator;
			}
		}
// If no creator, use 'Anon'
		else
		{
			$this->bf->addItem("Anon.", 'creator');
			$this->previousCreator = "Anon.";
		}
		if((sizeof($cite) == 2) && trim($cite[1]))
		{
			$split = split('-', trim($cite[1]));
			$end = (sizeof($split) == 2) ? $split[1] : FALSE;
			$this->bf->formatPages($split[0], $end, $this->citation);
		}
/**
* Year format
* 0 -> 1998
* 1 -> '98
* 2 -> 98
*/
		if($this->citation['yearFormat'] == 1)
			$year = "'" . substr($row['year1'], -2);
		else if($this->citation['yearFormat'] == 2)
		{
			$year = substr($row['year1'], -2);
			if($this->utf8->utf8_strlen($year) == 1)
				$year = "0" . $year;
		}
		else
			$year = $row['year1'];
		$this->bf->addItem($year, "year");
// get pages from input
		$pages = ((sizeof($cite) == 2) && trim($cite[1])) ? ": " . trim($cite[1]) : FALSE;
//print_r($this->bf->item); print "<P>";
		$pString = $this->bf->htmlOrRtf($this->bf->map($this->template));
		unset($this->bf->item);
//print "$pString<P>";
		if($this->citeLink)
			return MISC::a("link", $pString, "index.php?action=resourceView" .
			htmlentities("&id=" . $id));
		else
			return $pString;
	}
}
?>