<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	CITE class.
*
*	Citation handling
*****/

/*
This is the main file to handle citations.

For users with javascript turned off, the hyperlinks to this page should not display at all.
*/

class CITE
{
// Constructor
	function CITE($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/CLOSEPOPUP.php");
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// display the citation pop-up window with a select box of resources, page number text boxes and submit button.
// $this->vars['method'] will be 'abstract', 'note', 'musing', 'quote', 'quoteComment', 'paraphrase' or 'paraphraseComment' 
// referring to the textarea box into which to insert the citation.  Abstract, notes and musings have one textarea, quotes 
// and paraphrases have two (the quote/paraphrase and its comment).
	function display()
	{
		$pString = '';
		$this->template->setVar("heading", $this->messages->text("heading", "citations"));
		include_once("core/list/LISTCOMMON.php");
		$this->common = new LISTCOMMON($this->db, $this->vars);
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "plain");
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		if($userBibCondition = $this->common->userBibCondition())
			$userBibCondition = " WHERE " . $userBibCondition;
		$recordset = $this->db->select(array("WKX_resource"), $stmt->listFields('creator'), 
			$stmt->listJoin('creator', $userBibCondition));
		$pString .= FORM::formHeader("addCitation"); // parameter is the form action
		while($row = $this->db->loopRecordSet($recordset))
			$select[$row['resourceId']] = $bibStyle->process($row);
// Create select box
		$pString .= FORM::selectFBoxValue(FALSE, "cite", $select, "30", "120");
// Create optional page start and page end boxes and submit button.
		$pString .= MISC::p(FORM::textInput($this->messages->text("resources", "page"), 'pageStart', FALSE, 6, 5) . 
		" - " . FORM::textInput(FALSE, 'pageEnd', FALSE, 6, 5) . "&nbsp;&nbsp;" . 
		FORM::formSubmit("Cite"));
		$pString .= FORM::formEnd();
// Include JavaScript file
		$pString .= MISC::jsExternal('core/cite/cite.js');
		$this->template->setVar('body', $pString);
		new CLOSEPOPUP($this->template->process());
	}
// Make the citation hyperlink
	function makeCiteLink($method)
	{
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		$icons->getIconInfo("cite");
		$linkStyle = $icons->citeExists ? "imgLink linkCiteHidden" : "link linkCiteHidden";
		return "&nbsp;&nbsp;" . MISC::a($linkStyle, $icons->cite, 
			"javascript:openCiteWindow('index.php?action=citeDisplay" . "&amp;method=$method')"); // link is actually a JavaScript call
	}
// show citations about this resource
	function showCitations($resourceId)
	{
		$pString = FALSE;
		$sql = $this->db->selectNoExecute(
			array("WKX_resource"), array(array("WKX_resource.id" => "resourceId", 
			"WKX_resource_note.text" => "note")), 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_abstract") . 
				" ON " . $this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_abstract.id") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_note") . 
				" ON " . $this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_note.id") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_quote") . 
				" ON " . $this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_quote.resourceId") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_quote_text") . 
				" ON " . $this->db->formatField("WKX_resource_quote.id") . "=" . 
				$this->db->formatField("WKX_resource_quote_text.id") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_quote_comment") . 
				" ON " . $this->db->formatField("WKX_resource_quote.id") . "=" . 
				$this->db->formatField("WKX_resource_quote_comment.quoteId") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_paraphrase") . 
				" ON " . $this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_paraphrase.resourceId") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_paraphrase_text") . 
				" ON " . $this->db->formatField("WKX_resource_paraphrase.id") . "=" . 
				$this->db->formatField("WKX_resource_paraphrase_text.id") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_paraphrase_comment") . 
				" ON " . $this->db->formatField("WKX_resource_paraphrase.id") . "=" . 
				$this->db->formatField("WKX_resource_paraphrase_comment.paraphraseId") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_musing") . 
				" ON " . $this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_musing.resourceId") . 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_musing_text") . 
				" ON " . $this->db->formatField("WKX_resource_musing.id") . "=" . 
				$this->db->formatField("WKX_resource_musing_text.id") . 
			" WHERE (" . 
					$this->db->formatField("WKX_resource_abstract.abstract") . 
//					" REGEXP '\\\[cite\\\]$resourceId.*\\\[/cite\\\]' 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				" OR " . 
					$this->db->formatField("WKX_resource_note.text") . 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				" OR " . 
					$this->db->formatField("WKX_resource_quote_text.text") . 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				" OR " . 
					$this->db->formatField("WKX_resource_quote_comment.comment") . 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				" OR " . 
					$this->db->formatField("WKX_resource_paraphrase_text.text") . 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				" OR " . 
					$this->db->formatField("WKX_resource_paraphrase_comment.comment") . 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				" OR " . 
					$this->db->formatField("WKX_resource_musing_text.text") . 
//					" REGEXP " . $this->db->tidyInput("\\[cite\\]$resourceId.*\\[/cite\\]") . 
					" LIKE " . $this->db->tidyInput("%\\[cite\\]$resourceId%") . 
				")"
			);
// If we are browsing a user bibliography, we return only results this bibliography
		if($useBib = $this->session->getVar("mywikindx_bibliography_use"))
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($useBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			$bibCondition = "(" . $this->db->formatfield('WKX_resource.id') . " = ";
			foreach($bibsArray as $id)
			{
				if($id == $resourceId)
					continue;
				$conditionArray[] = $this->db->tidyInput($id);
			}
			if(!isset($conditionArray))
				return $pString;
			$bibCondition .= implode(" OR " . $this->db->formatfield('WKX_resource.id') . " = ", 
				$conditionArray) . ")";
			$sql .= " AND " . $bibCondition;
			$title = unserialize($this->session->getVar('mywikindx_bibliographies'));
			$link = $this->messages->text("resources", "citedResources", " " . $title[1]);
			$recordset = $this->db->query($sql);
			while($line = $this->db->loopRecordSet($recordset))
				$bibCitedResources[] = $line['resourceId'];
			if(isset($bibCitedResources))
			{
				$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
				$pString .= TABLE::trStart();
				$pString .= TABLE::td(MISC::span(MISC::a("link", $link, 
					"index.php?action=listCiteProcess"), "small"));
				$pString .= TABLE::trEnd();
				$pString .= TABLE::tableEnd();
				$this->session->setVar("list_citeIds", join(",", $bibCitedResources));
				return $pString;
			}
		}
// Results from the Master Bibliography
		$link = $this->messages->text("resources", "citedResources", " " . 
			$this->messages->text("user", "masterBib"));
		$masterSql = $sql . " AND (" . $this->db->formatField('WKX_resource.id') . " != " . 
			$this->db->tidyInput($resourceId) . ")";
		$recordset = $this->db->query($masterSql);
		while($line = $this->db->loopRecordSet($recordset))
			$masterCitedResources[] = $line['resourceId'];
		if(isset($masterCitedResources))
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::span(MISC::a("link", $link, 
				"index.php?action=listCiteProcess"), "small"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$this->session->setVar("list_citeIds", join(",", $masterCitedResources));
		}
		return $pString;
	}
}
?>
