<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Logging on and system authorisation class.
*****/
class AUTHORIZE
{
// Constructor
	function AUTHORIZE($db)
	{
		$this->db = $db;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/user/USER.php");
		$this->user = new USER($this->db);
// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// gatekeeper to the system.  Order is important!
	function gatekeep($vars)
	{
// logging out
		if(isset($vars["action"]) && ($vars["action"] == 'logout'))
			$this->logout();
// User supplying username and password to logon to WIKINDX.
// $auth->logonCheck() dies after printing logon screen if bad comparison.
		else if(isset($vars["action"]) && ($vars["action"] == 'logon') &&
			isset($vars["password"]) && isset($vars["username"]))
		{
			$this->logonCheck($vars['username'], $vars['password']);
// clear previous mywikindx session and, if this user has bibliographies, initialise mywikindx_bibliographies
// FALSE means go to front of WIKINDX
			return FALSE;
		}
// User requesting readOnly access - clear previous sessions
		else if(isset($vars["action"]) && ($vars["action"] == 'readOnly'))
		{
// First delete any pre-existing session in case this user has been logging on and off as different users
// session array 'setup' is deleted at logout()
			$this->session->clearArray('preferences');
			$this->session->clearArray('config');
			$this->session->clearArray('mywikindx');
			$this->session->clearArray('sql');
			$this->session->clearArray('search');
			$this->session->clearArray('powerSearch');
			$this->session->clearArray('style');
			$this->session->clearArray('cite');
			$this->session->setVar("setup_readOnly", TRUE);
// populate session with default values from WKX_config
			$this->user->writeSessionPreferences(FALSE, 'WKX_config');
// FALSE means go to front of WIKINDX
			return FALSE;
		}
// User registration
		else if($this->session->getVar("setup_userRegistration") && $this->session->getVar("setup_multiUser"))
		{
			if($vars["action"] == 'initRegisterUser')
			{
				include_once("core/admin/ADMINUSER.php");
				$obj = new ADMINUSER($this->db, $vars);
				$pString =$obj->initRegister();
				if(!$this->session->getVar("setup_readOnly"))
				{
					include_once("core/html/CLOSENOMENU.php");
					new CLOSENOMENU($this->db, $pString);
				}
				else
				{
					include_once("core/html/CLOSE.php");
					new CLOSE($this->db, $pString);
				}
			}
			else if($vars["action"] == 'registerUser')
			{
				include_once("core/admin/ADMINUSER.php");
				$obj = new ADMINUSER($this->db, $vars);
				$pString =$obj->register();
				if(!$this->session->getVar("setup_readOnly"))
				{
					include_once("core/html/CLOSENOMENU.php");
					new CLOSENOMENU($this->db, $pString);
				}
				else
				{
					include_once("core/html/CLOSE.php");
					new CLOSE($this->db, $pString);
				}
			}
			else if($vars["action"] == 'registerConfirm')
			{
				include_once("core/admin/ADMINUSER.php");
				$obj = new ADMINUSER($this->db, $vars);
				$pString =$obj->registerConfirm();
				if(!$this->session->getVar("setup_readOnly"))
				{
					include_once("core/html/CLOSENOMENU.php");
					new CLOSENOMENU($this->db, $pString);
				}
				else
				{
					include_once("core/html/CLOSE.php");
					new CLOSE($this->db, $pString);
				}
			}
			else if($vars["action"] == 'registerUserAdd')
			{
				include_once("core/admin/ADMINUSER.php");
				$obj = new ADMINUSER($this->db, $vars);
				$pString =$obj->registerUserAdd();
				include_once("core/html/CLOSE.php");
				new CLOSE($this->db, $pString);
			}
		}
// access already granted
		if($this->session->getVar('setup_write') || $this->session->getVar("setup_readOnly"))
			return TRUE;
		include_once("core/cookie/COOKIE.php");
		$cookie = new COOKIE();
// grabCookie() returns TRUE if valid cookie - otherwise, proceed to manual logon
		if($cookie->grabCookie($this->db))
			return TRUE;
// Write and readOnly access have not yet been granted so return the logon prompt after checking for cookie
		if(!$this->session->getVar("setup_write") && !$this->session->getVar('setup_readOnly'))
		{
			$pString = $this->initLogon();
			include_once("core/html/CLOSENOMENU.php");
			new CLOSENOMENU($this->db, $pString);
		}
// FALSE indicates that index.php will print the front page of WIKINDX
		return FALSE;
	}
// Display the empty form for logging on
	function initLogon()
	{
		include_once("core/html/FORM.php");
		include_once("core/html/MISC.php");
		global $WIKINDX_RESTRICT_USER;
		$pString = '';
		$this->template->setVar('heading', $this->messages->text("heading", "logon"));
		if(!$this->session->getVar("setup_multiUser"))
			$pString .= MISC::p($this->errors->text("warning", "superadminOnly"));
		$this->template->setVar('formStart', FORM::formHeader("logon"));
		$pString .= MISC::p($this->messages->text("authorize", "writeLogon"));
/**
* For a test user (see index.php)
*/
		if($WIKINDX_RESTRICT_USER)
			$pString .= MISC::p("For test drive purposes, " .
				MISC::b("username: ") . "wikindx, " . MISC::b("password: ") . "wikindx");

		$pString .= $this->printLogonTable() . MISC::br();
// Give user the option to bypass logging in simply to read.
		$link1 = "index.php?action=readOnly";
		$link2 = "index.php?action=initRegisterUser";
		if($this->session->getVar("setup_userRegistration") && $this->session->getVar("setup_multiUser"))
			$pString .= MISC::p(MISC::a("link", $this->messages->text("authorize", "readOnly"), $link1) . 
				MISC::br() . MISC::a("link", $this->messages->text("menu", "register"), $link2), 
				FALSE, "right");
		else
			$pString .= MISC::p(MISC::a("link", $this->messages->text("authorize", "readOnly"), $link1), 
				FALSE, "right");
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// print username/password text boxes
	function printLogonTable()
	{
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left", "50%");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td("Username:&nbsp;");
		$pString .= TABLE::td(FORM::textInput(FALSE, "username"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart(FALSE);
		$pString .= TABLE::td("Password:&nbsp;");
		$pString .= TABLE::td(FORM::passwordInput(FALSE, "password"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td("&nbsp;");
		$pString .= TABLE::td(FORM::formSubmit(), FALSE, "right");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('formEnd', FORM::formEnd());
		return $pString;
	}
// Initial logon to the system.
        function logonCheck($username, $password)
        {
// If checkPassword is successful, it also sets up some session variables to allow access without reauthentication.
		if(!$this->user->checkPassword($username, $password))
			$this->failure();
        }
// log out user
        function logout()
        {
// Garbage disposal
// remove this session's files directory
		$dir = "files/" . session_id();
		if($d = @opendir($dir))
		{
			while(FALSE !== ($f = readdir($d)))
			{
        			if(($f == ".") || ($f == ".."))
					continue;
				$file = $dir . "/" . $f;
				unlink($file);
			}
			rmdir($dir);
		}
		session_destroy();
// remove any wikindx cookie that has been set
		include_once("core/cookie/COOKIE.php");
		$cookie = new COOKIE();
		$cookie->deleteCookie();
		include_once("core/html/CLOSENOMENU.php");
		new CLOSENOMENU($this->db, $this->initLogon());
        }
// failure
	function failure()
	{
// Exit back to logon prompt
		include_once("core/html/CLOSENOMENU.php");
		new CLOSENOMENU($this->db, $this->initLogon());
	}
}
?>
