<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	DELETERESOURCE class.
*
*	Delete resources
*
*	$Header: /cvsroot/wikindx/wikindx3/core/admin/DELETERESOURCE.php,v 1.24 2005/06/28 19:21:10 sirfragalot Exp $
*****/
class DELETERESOURCE
{
// Constructor
	function DELETERESOURCE($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/TABLE.php");
		include_once("core/html/FORM.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/file/TAG.php");
		$this->tag = new TAG($this->db);
	}
// check we really are admin
	function gateKeep($method)
	{
		if(!$this->session->getVar("setup_superadmin"))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			if($pString = $authorize->initLogon())
				return $pString;
		}
// else, run $method
		return $this->$method();
	}
// display options for resources
	function display($message = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "delete"));
		if(!$this->resources = $this->grabAll())
		{
			$this->template->setVar('body', $this->messages->text('misc', 'noResources'));
			return $this->template->process();
		}
		$pString = $message ? $message : FALSE;
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(FORM::formHeader("deleteResourceConfirm") . 
			FORM::selectFBoxValueMultiple(FALSE, "resource_id", $this->resources, 20, 80) . 
			MISC::br() . $this->messages->text('hint', 'multiples') . MISC::br() . 
			MISC::br() . FORM::formSubmit('Proceed to Confirm') . FORM::formEnd());
		$tags = $this->tag->grabAll();
		if($tags)
			$pString .= TABLE::td(FORM::formHeader("deleteResourceConfirm") . 
			FORM::selectFBoxValueMultiple($this->messages->text("misc", "tag"), 'bibtex_tagId', $tags, 5) . 
			MISC::br() . $this->messages->text('hint', 'multiples') . MISC::br() . 
			MISC::br() . FORM::formSubmit('Proceed to Confirm') . FORM::formEnd());
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Grab ids and titles of resources
	function grabAll()
	{
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "plain");
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$titles = FALSE;
		$recordset = $this->db->select(array("WKX_resource"), $stmt->listFields('creator'), 
			$stmt->listJoin('creator'));
		while($row = $this->db->loopRecordSet($recordset))
		{
//			$titles[$row['resourceId']] = $row['title'];
			$titles[$row['resourceId']] = $this->html->dbToFormTidy($bibStyle->process($row, TRUE));
		}
		return $titles;
	}
// Ask for confirmation of delete resource
	function confirm()
	{
		if(!$this->validateInput())
			$this->badInput($this->errors->text("inputError", "missing"), 'display');
		if($this->deleteType == 'tag')
			$this->vars['resource_id'] = $this->collectResourceFromTag();
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
// fields from WKX_resource_note, WKX_resource_category and WKX_resource_keyword:
		$sql = $this->db->selectNoExecute(array("WKX_resource"), $stmt->listFields(), $stmt->selectJoin());
		$sql .= " WHERE WKX_resource.id=";
		if(is_array($this->vars['resource_id']))
			$sql .= implode(" OR WKX_resource.id=", $this->vars['resource_id']);
		else
			$sql .= $this->vars['resource_id'];
		$recordset = $this->db->query($sql);
		if(!$numDeletes = $this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noResult"), "display");
		$this->template->setVar("heading", $this->messages->text("heading", "delete"));
// Rather than print 100s or 1000s of resources, we limit display to <= 50
		if($numDeletes <= 50)
		{
			include_once("core/styles/BIBSTYLE.php");
			$bibStyle = new BIBSTYLE($this->db, "html");
			$index = 0;
			$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
			while($row = $this->db->loopRecordSet($recordset))
			{
				$class = $index % 2 ? 'alternate2' : 'alternate1';
				$pString .= TABLE::trStart();
				$pString .= TABLE::td($bibStyle->process($row), $class);
				$pString .= TABLE::trEnd();
				$index++;
			}
			$pString .= TABLE::tableEnd();
// Encapsulating cell from body.tpl
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		}
		else
			$pString = $this->messages->text("misc", "confirmDelete", " " . $numDeletes . " ");
		$pString .= FORM::formHeader("deleteResource");
		if(is_array($this->vars['resource_id']))
			$pString .= FORM::hidden("resource_id", implode(",", $this->vars['resource_id']));
		else
			$pString .= FORM::hidden("resource_id", $this->vars['resource_id']);
		$pString .= MISC::br() . "&nbsp;" . MISC::br() . FORM::formSubmit('Confirm');
		$pString .= FORM::formEnd();
		$this->session->setVar("deleteResourceLock", FALSE);
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
	function delete()
	{
// redeleting an already deleted resource?
		if($this->session->getVar("deleteResourceLock"))
			$this->badInput($this->errors->text("done", "resource"), "display");
		if(!$this->validateInput())
			$this->badInput($this->errors->text("inputError", "missing"), 'display');
		$this->idsRaw = explode(',', $this->vars['resource_id']);
		$this->reallyDelete();
		$this->checkHanging();
		$this->decrementSummary();
		$tables = array('WKX_resource', 'WKX_keyword', 'WKX_creator', 'WKX_collection', 'WKX_publisher',
			'WKX_resource_abstract', 'WKX_resource_accessed', 'WKX_resource_category', 
			'WKX_resource_keyword', 'WKX_resource_misc', 'WKX_resource_musing', 'WKX_resource_musing_text', 
			'WKX_resource_note', 'WKX_resource_page', 'WKX_resource_paraphrase', 'WKX_resource_quote', 
			'WKX_resource_paraphrase_text', 'WKX_resource_quote_text', 'WKX_resource_summary', 
			'WKX_resource_timestamp', 'WKX_resource_year', 'WKX_import_raw', 'WKX_bibtex_string', 
			'WKX_attachments');
		foreach($tables as $table)
			$this->db->optimize($table);
// If we have 0 resources left, remove 'sql_stmt' etc. from session so it doesn't cause problems with 
// exporting bibliographies etc.
		$recordset = $this->db->select(array('WKX_database_summary'), array('totalResources'));
		if(!$this->db->fetchOne($recordset))
		{
			$this->session->delVar('sql_stmt');
			$this->session->delVar('sql_lastMulti');
			$this->session->delVar('sql_lastSolo');
		}
		$pString = $this->success->text("resource", " " . $this->messages->text("misc", "deleted") . " ");
// Lock reload.
		$this->session->setVar("deleteResourceLock", TRUE);
		return $this->display($pString);
	}
// delete resources and meta data
	function reallyDelete()
	{
// grab creator etc. ids, collection, publisher and keywords
		$this->quotes = $this->paraphrases = $this->musings = 0;
		foreach($this->idsRaw as $key => $id)
			$this->ids[$key] = $this->db->tidyInput($id);
		$condition = join(" OR WKX_resource.id=", $this->ids);
		$recordset = $this->db->select(array('WKX_resource'), array('creator1', 'creator2', 
			'creator3', 'creator4', 'creator5', 
			'publisher', 'collection', 'keywords', 'quote_keywords', 'paraphrase_keywords', 
			'musing_keywords', 'quotes', 'paraphrases', 'musings', 'tag', 'type', 'miscField1'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_creator') . " ON " . 
				$this->db->formatField('WKX_resource_creator.id') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_misc') . " ON " . 
				$this->db->formatField('WKX_resource_misc.id') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_keyword') . " ON " . 
				$this->db->formatField('WKX_resource_keyword.id') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_summary') . " ON " . 
				$this->db->formatField('WKX_resource_summary.id') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_quote') . " ON " . 
				$this->db->formatField('WKX_resource_quote.resourceId') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_paraphrase') . " ON " . 
				$this->db->formatField('WKX_resource_paraphrase.resourceId') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_musing') . " ON " . 
				$this->db->formatField('WKX_resource_musing.resourceId') . "=" . 
				$this->db->formatField('WKX_resource.id') .  
			" WHERE " . $this->db->formatField('WKX_resource.id') . "=" . $condition);
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['quotes'])
				$this->quotes += $row['quotes'];
			if($row['paraphrases'])
				$this->paraphrases += $row['paraphrases'];
			if($row['musings'])
				$this->musings += $row['musings'];
			foreach(array('creator1', 'creator2', 'creator3', 'creator4', 'creator5') as $creator)
			{
				if($row[$creator])
				{
					if(isset($this->checkCreators))
						$this->checkCreators .= "," . $row[$creator];
					else
						$this->checkCreators = $row[$creator];
				}
			}
			if($row['publisher'])
			{
				if(isset($this->checkPublishers))
					$this->checkPublishers .= "," . $row['publisher'];
				else
					$this->checkPublishers = $row['publisher'];
			}
			if(($row['type'] == 'proceedings_article') && $row['miscField1'])
			{
				if(isset($this->checkConfPublishers))
					$this->checkConfPublishers .= "," . $row['miscField1'];
				else
					$this->checkConfPublishers = $row['miscField1'];
			}
			if($row['collection'])
			{
				if(isset($this->checkCollections))
					$this->checkCollections .= "," . $row['collection'];
				else
					$this->checkCollections = $row['collection'];
			}
			if($row['keywords'])
			{
				if(isset($this->checkKeywords))
					$this->checkKeywords .= "," . $row['keywords'];
				else
					$this->checkKeywords = $row['keywords'];
			}
			if($row['quote_keywords'])
			{
				if(isset($this->checkKeywords))
					$this->checkKeywords .= "," . $row['quote_keywords'];
				else
					$this->checkKeywords = $row['quote_keywords'];
			}
			if($row['paraphrase_keywords'])
			{
				if(isset($this->checkKeywords))
					$this->checkKeywords .= "," . $row['paraphrase_keywords'];
				else
					$this->checkKeywords = $row['paraphrase_keywords'];
			}
			if($row['musing_keywords'])
			{
				if(isset($this->checkKeywords))
					$this->checkKeywords .= "," . $row['musing_keywords'];
				else
					$this->checkKeywords = $row['musing_keywords'];
			}
			if($row['tag'])
			{
				if(isset($this->checkTags))
					$this->checkTags .= "," . $row['tag'];
				else
					$this->checkTags = $row['tag'];
			}
		}
// now start delete
		$condition = $this->db->formatfield('id') . "=" . 
			join(" OR " . $this->db->formatfield('id') . "=", $this->ids);
		$this->deleteSQL('WKX_resource', $condition);
		$this->deleteSQL('WKX_resource_misc', $condition);
		$this->deleteSQL('WKX_resource_abstract', $condition);
		$this->deleteSQL('WKX_resource_creator', $condition);
		$this->deleteSQL('WKX_resource_keyword', $condition);
		$this->deleteSQL('WKX_resource_category', $condition);
		$this->deleteSQL('WKX_resource_note', $condition);
		$this->deleteSQL('WKX_resource_page', $condition);
		$this->deleteSQL('WKX_resource_summary', $condition);
		$this->deleteSQL('WKX_resource_timestamp', $condition);
		$this->deleteSQL('WKX_resource_year', $condition);
// If this resource is duplicted in WKX_import_raw
		$this->deleteSQL('WKX_import_raw', $condition);
		$condition = $this->db->formatfield('resourceId') . "=" . 
			join(" OR " . $this->db->formatfield('resourceId') . "=", $this->ids);
		$this->deleteSQL('WKX_resource_custom', $condition);
		$this->deleteSQL2('WKX_resource_paraphrase', $condition);
		$this->deleteSQL2('WKX_resource_quote', $condition);
		$this->deleteSQL2('WKX_resource_musing', $condition);
		$this->checkBibtexStringTable();
// delete these ids from any user bibliographies
		foreach($this->ids as $id)
			$conditions[] = "FIND_IN_SET($id," . $this->db->formatfield('bibliography') . ")";
		$condition = " WHERE FIND_IN_SET(" . $id . ", " . $this->db->formatfield('bibliography') . ")" . " OR " . 
			join(" OR ", $conditions);
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('id', 'bibliography'), $condition);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$dbBibs = explode(",", $row['bibliography']);
			$remainBibs = array_diff($dbBibs, $this->idsRaw);
			if(empty($remainBibs))
				$this->db->updateNull('WKX_user_bibliography', 
					array('bibliography'), " WHERE " . $this->db->formatfield('id') . 
					"=" . $this->db->tidyInput($row['id']));
			else
			{
				$updateArray = array('bibliography' => implode(",", $remainBibs));
				$this->db->update('WKX_user_bibliography', $updateArray, 
					" WHERE " . $this->db->formatfield('id') . "=" . 
					$this->db->tidyInput($row['id']));
			}
		}
// check file attachments
		$condition = $this->db->formatfield('resourceId') . "=" . 
			join(" OR " . $this->db->formatfield('resourceId') . "=", $this->ids);
		$recordSet = $this->db->select(array('WKX_attachments'), array('id', 'hashFilename'), 
			" WHERE " . $condition);
		while($row = $this->db->loopRecordSet($recordSet))
			$hashes[$row['id']] = $row['hashFilename'];
		if(isset($hashes))
		{
			foreach($hashes as $id => $hash)
			{
				$this->db->delete("WKX_attachments", " WHERE " . $this->db->formatfield('id') . "=" . 
					$this->db->tidyInput($id));
// Is file used by other resources?  If not, unlink it
				$recordSet = $this->db->select(array("WKX_attachments"), array("hashFilename"), 
					" WHERE " . $this->db->formatField("hashFilename") . "=" . $this->db->tidyInput($hash));
				if(!$this->db->numRows($recordSet)) // Unlink it
					unlink("attachments/" . $hash);
			}
		}
	}
// decrement summary table
	function decrementSummary()
	{
		$numDeletes = sizeof($this->ids);
		if($this->musings)
			$updateArray[] = $this->db->formatField('totalMusings') .  "=" . 
			$this->db->formatField('totalMusings') . "-" . $this->db->tidyInput($this->musings);
		if($this->paraphrases)
			$updateArray[] = $this->db->formatField('totalParaphrases') .  "=" . 
			$this->db->formatField('totalParaphrases') . "-" .
			$this->db->tidyInput($this->paraphrases);
		if($this->quotes)
			$updateArray[] = $this->db->formatField('totalQuotes') .  "=" . 
			$this->db->formatField('totalQuotes') . "-" . $this->db->tidyInput($this->quotes);
		if(isset($updateArray) && $numDeletes)
			$this->db->updateSingle('WKX_database_summary', 
			$this->db->formatField('totalResources') . "=" . 
			$this->db->formatField('totalResources') . 
			"-" . $this->db->tidyInput($numDeletes) . ", " . implode(', ', $updateArray));
		else if($numDeletes)
			$this->db->updateSingle('WKX_database_summary', 
			$this->db->formatField('totalResources') . "=" . 
			$this->db->formatField('totalResources') . "-" . $this->db->tidyInput($numDeletes));
	}
// check that delete of resources hasn't left any resource-less creators, keywords, publisher, collections etc.
// If so, delete them.
	function checkHanging()
	{
		include_once("core/creator/CREATOR.php");
		$creator = new CREATOR($this->db);
		include_once("core/collection/COLLECTION.php");
		$collection = new COLLECTION($this->db);
		include_once("core/publisher/PUBLISHER.php");
		$publisher = new PUBLISHER($this->db);
// Creators
		$temp = array();
		if(isset($this->checkCreators))
		{
			$creators = array('creator1', 'creator2', 'creator3', 'creator4', 'creator5');
			$checkCreators = array_unique(split(",", $this->checkCreators));
			$removeCreators = $checkCreators;
			foreach($checkCreators as $creatorId)
			{
				$condition = array();
				foreach($creators as $creatorField)
					$condition[] = " FIND_IN_SET(" . $this->db->tidyInput($creatorId) . "," . 
					$this->db->formatField($creatorField) . ")";
				$condition = " WHERE " . join(" OR ", $condition);
				$recordset = $this->db->select(array("WKX_resource_creator"), array('creator1', 'creator2', 
					'creator3', 'creator4', 'creator5'), $condition);
				if($this->db->numRows($recordset))
					unset($removeCreators[array_search($creatorId, $removeCreators)]);
			}
			if(!empty($removeCreators))
			{
				foreach($removeCreators as $key => $id)
					$removeCreators[$key] = "'$id'";
				$condition = $this->db->formatfield('id') . "=" . 
					join(" OR " . $this->db->formatfield('id') . "=", $removeCreators);
				$this->deleteSQL('WKX_creator', $condition);
			}
		}
// Collections
		$temp = array();
		if(isset($this->checkCollections))
		{
			$removeCollections = $checkCollections = array_unique(split(",", $this->checkCollections));
			foreach($checkCollections as $collectionId)
			{
				$condition = " WHERE " . $this->db->tidyInput($collectionId) . "=" . 
					$this->db->formatField('collection');
				$recordset = $this->db->select(array("WKX_resource_misc"), array('collection'), $condition);
				if($this->db->numRows($recordset))
					unset($removeCollections[array_search($collectionId, $removeCollections)]);
			}
			if(!empty($removeCollections))
			{
				foreach($removeCollections as $key => $id)
					$removeCollections[$key] = "'$id'";
				$condition = $this->db->formatfield('id') . "=" . 
					join(" OR " . $this->db->formatfield('id') . "=", $removeCollections);
				$this->deleteSQL('WKX_collection', $condition);
			}
		}
// Publishers
		$temp = array();
		if(isset($this->checkPublishers))
		{
			$checkPublishers = array_unique(split(",", $this->checkPublishers));
			if(isset($this->checkConfPublishers))
				$checkPublishers = array_merge($checkPublishers, 
				array_unique(split(",", $this->checkConfPublishers)));
			$removePublishers = $checkPublishers;
			foreach($checkPublishers as $publisherId)
			{
				$condition = " WHERE " . $this->db->tidyInput($publisherId) . "=" . 
					$this->db->formatField('publisher');
				$recordset = $this->db->select(array("WKX_resource_misc"), array('publisher'), $condition);
				if($this->db->numRows($recordset))
					unset($removePublishers[array_search($publisherId, $removePublishers)]);
				else
				{
					$condition = " WHERE " . $this->db->tidyInput($publisherId) . "=" . 
						$this->db->formatField('miscField1') . 
						" AND " . 
						$this->db->formatField('type') . '=' . $this->db->tidyInput('proceedings_article');
					$recordset = $this->db->select(array("WKX_resource_misc"), 
						array('miscField1'), 
						" LEFT JOIN " . $this->db->formatTable('WKX_resource') . 
						" ON " . $this->db->formatfield("WKX_resource_misc.id") . "=" . 
						$this->db->formatfield("WKX_resource.id"), $condition);
					if($this->db->numRows($recordset))
						unset($removePublishers[array_search($publisherId, $removePublishers)]);
				}
			}
			if(!empty($removePublishers))
			{
				foreach($removePublishers as $key => $id)
					$removePublishers[$key] = "'$id'";
				$condition = $this->db->formatfield('id') . "=" . 
					join(" OR " . $this->db->formatfield('id') . "=", $removePublishers);
				$this->deleteSQL('WKX_publisher', $condition);
			}
		}
// Keywords
		$temp = array();
		if(isset($this->checkKeywords))
		{
			include_once("core/keyword/KEYWORD.php");
			$keyword = new KEYWORD($this->db);
			$keyword->removeHanging2($this->checkKeywords);
		}
// Tags
		$temp = array();
		if(isset($this->checkTags))
		{
			$recordset = $this->db->select(array("WKX_resource_misc"), array('tag'));
			$checkTags = array_unique(split(",", $this->checkTags));
			while($row = $this->db->loopRecordSet($recordset))
			{
				foreach($row as $value)
					$temp[] = $value;
			}
			$remainTags = array_unique($temp);
			$removeTags = array_diff($checkTags, $remainTags);
			if(!empty($removeTags))
			{
				foreach($removeTags as $key => $id)
					$removeTags[$key] = "'$id'";
				$condition = $this->db->formatfield('id') . "=" . 
					join(" OR " . $this->db->formatfield('id') . "=", $removeTags);
				$this->deleteSQL('WKX_tag', $condition);
			}
		}
	}
// get array of resource ids belonging to tag ids
	function collectResourceFromTag()
	{
		$sql = " WHERE " . $this->db->formatField('tag') . "=";
		$sql .= implode(" OR " . $this->db->formatField('tag') . "=", $this->vars['bibtex_tagId']);
		$recordset = $this->db->select(array("WKX_resource_misc"), array('id'), $sql);
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noResult"), "display");
		while($row = $this->db->loopRecordSet($recordset))
			$ids[] = $row['id'];
		return $ids;
	}
// check @strings still have resources in WKX_import_raw - else delete string entries
	function checkBibtexStringTable()
	{
		$recordset = $this->db->select(array('WKX_import_raw'), array('id', 'stringId'));
// Delete all from `WKX_bibtex_string`
		if(!$this->db->numRows($recordset))
		{
			$this->db->delete('WKX_bibtex_string');
			return;
		}
		$rawStringIds = array();
		while($row = $this->db->loopRecordSet($recordset))
		{
			if(!$row['stringId'])
				continue;
			$rawStringIds[] = $row['stringId'];
		}
		if(empty($rawStringIds))
			return;
		$rawStringIds = array_unique($rawStringIds);
		$condition = $this->db->formatfield('id') . "!=" . 
			join(" AND " . $this->db->formatfield('id') . "!=", $rawStringIds);
		$this->db->delete('WKX_bibtex_string', " WHERE " . $condition);
	}
// run SQL delete statements
	function deleteSQL($table, $condition)
	{
		$this->db->delete($table, " WHERE " . $condition);
	}
// run SQL delete statements on meta data
	function deleteSQL2($table, $condition)
	{
// First get meta data id
		$recordset = $this->db->select(array($table), array('id'), " WHERE " . $condition);
		while($row = $this->db->loopRecordSet($recordset))
			$ids[] = $row['id'];
// Delete meta data parent row
		$this->db->delete($table, " WHERE " . $condition);
		if(!isset($ids) || empty($ids))
			return;
// Delete meta data child rows
		$condition = $this->db->formatfield('id') . "=" . 
			join(" OR " . $this->db->formatfield('id') . "=", $ids);
		$newTable = $table . "_text";
		$this->db->delete($newTable, " WHERE " . $condition);
		if($table != 'WKX_resource_musing')
		{
			if($table == 'WKX_resource_quote')
				$condition = $this->db->formatfield('quoteId') . "=" . 
				join(" OR " . $this->db->formatfield('quoteId') . "=", $ids);
			else if($table == 'WKX_resource_paraphrase')
				$condition = $this->db->formatfield('paraphraseId') . "=" . 
				join(" OR " . $this->db->formatfield('paraphraseId') . "=", $ids);
			$newTable = $table . "_comment";
			$this->db->delete($newTable, " WHERE " . $condition);
		}
	}
// bad Input function
	function badInput($error, $method)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->$method($error));
	}
// validate input
	function validateInput()
	{
		if(!array_key_exists('resource_id', $this->vars))
		{
			if(!array_key_exists('bibtex_tagId', $this->vars))
				return FALSE;
			else
			{
				$this->deleteType = 'tag';
				return TRUE;
			}
		}
		$this->deleteType = 'resource';
		return TRUE;
	}
}
?>
