<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	ADMINGROUP class.
*
*	Administration of categories
*****/
class ADMINGROUP
{
// Constructor
	function ADMINGROUP($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/group/GROUP.php");
		$this->group = new GROUP($this->db);
		$this->groups = $this->group->grabAll();
// Administering 'General' category (key == 1) is not allowed.
		unset($this->groups[1]);
	}
// check we really are admin
	function gateKeep($method)
	{
		if(!$this->session->getVar("setup_superadmin"))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			if($pString = $authorize->initLogon())
				return $pString;
		}
// else, run $method
		return $this->$method();
	}
// display options for categories
	function display($message = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "category"));
		$pString = '';
		if($message)
			$pString .= MISC::p($message);
		$pString .= MISC::p(MISC::a("link", $this->messages->text("category", "addLabel"), 
			"index.php?action=adminGroupAddInit"));
		if(sizeof($this->groups))
		{
			$pString .= MISC::p(MISC::a("link", $this->messages->text("category", "deleteLabel"), 
				"index.php?action=adminGroupDeleteInit"));
			$pString .= MISC::p(MISC::a("link", $this->messages->text("category", "editLabel"), 
				"index.php?action=adminGroupEditInit"));
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Add a group - display options.
	function addInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "category", 
		" (" . $this->messages->text("category", "addLabel") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("adminGroupAdd");
		$pString .= FORM::textInput(FALSE, "groupAdd", FALSE, 30, 255);
		$pString .= FORM::formSubmit('Add');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Add a group
	function add()
	{
		if(!$input = $this->validateInput('add'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'addInit');
		if(!$this->group->addSql($input))
			$this->badInput($this->errors->text("inputError", "invalid"));
		$pString = $this->success->text("category", " " . $this->messages->text("misc", "added") . " ");
		$this->groups = $this->group->grabAll();
		unset($this->groups[1]);
		return $this->display($pString);
	}
// Delete groups display.
	function deleteInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "category", 
		" (" . $this->messages->text("category", "deleteLabel") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= MISC::p($this->messages->text("category", "deleteWarning"));
		$pString .= FORM::formHeader("adminGroupDeleteConfirm");
		foreach($this->groups as $key => $value)
			$pString .= FORM::checkbox(FALSE, "groupDelete_" . $key) . " $value" . MISC::br();
		$pString .= MISC::br() . FORM::formSubmit('Delete');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Ask for confirmation of delete groups
	function deleteConfirm()
	{
		if(!$input = $this->validateInput('delete'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
		$this->template->setVar("heading", $this->messages->text("heading", "category", 
			" (" . $this->messages->text("category", "deleteLabel") . ")"));
		$groups = "'" . implode("', '", array_keys(array_intersect(array_flip($this->groups), $input))) . "'";
		$groups = html_entity_decode($groups);
		$pString = MISC::p($this->messages->text("category", "deleteConfirm", ": $groups"));
		$pString .= FORM::formHeader("adminGroupDelete");
		foreach($input as $id)
			$pString .= FORM::hidden("groupDelete_" . $id, $id);
		$pString .= MISC::br() . FORM::formSubmit('Confirm');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Delete group(s)
	function delete()
	{
		if(!$input = $this->validateInput('delete'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
// ensure that category 1 'General' is never deleted
		if($key = array_search(1, $input))
			unset($input[$key]);
		if(!$this->group->deleteSql($input))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
		$groups = "'" . implode("', '", array_keys(array_intersect(array_flip($this->groups), $input))) . "'";
		$pString = $this->success->text("category", " " . $this->messages->text("misc", "deleted") . " ");
		$this->groups = $this->group->grabAll();
		unset($this->groups[1]);
		return $this->display($pString);
	}
// display groups for editing
	function editInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "category", 
		" (" . $this->messages->text("category", "editLabel") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("adminGroupEdit");
		foreach($this->groups as $key => $value)
			$pString .= FORM::textInput(FALSE, "groupEdit_" . $key, $value, 30, 255) . MISC::br();
		$pString .= MISC::br() . FORM::formSubmit('Edit');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Edit groups
	function edit()
	{
		if(!$input = $this->validateInput('edit'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'editInit');
		if(!$this->group->updateSql($input))
			$this->badInput($this->errors->text("inputError", "invalid"));
		$pString = $this->success->text("category", " " . $this->messages->text("misc", "edited") . " ");
		return $this->display($pString);
	}
// bad Input function
	function badInput($error, $method)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->$method($error));
	}
// validate input
	function validateInput($type)
	{
		if($type == 'add')
		{
			if(!$input = trim($this->vars['groupAdd']))
				return FALSE;
		}
		else if($type == 'delete')
		{
			foreach($this->vars as $key => $value)
			{
				if(!preg_match("/groupDelete_(.*)/", $key, $match))
					continue;
				$input[] = $match[1];
			}
			if(!isset($input))
				return FALSE;
		}
		else if($type == 'edit')
		{
			foreach($this->vars as $key => $value)
			{
				if(!preg_match("/groupEdit_(.*)/", $key, $match))
					continue;
				$input[$match[1]] = $value;
			}
			if(!isset($input))
				return FALSE;
		}
		return $input;
	}
}
?>
