<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	ADMINCUSTOM class.
*
*	Administration of custom resource fields in `WKX_custom`
*****/
class ADMINCUSTOM
{
// Constructor
	function ADMINCUSTOM($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML();
	}
// check we really are admin
	function gateKeep($method)
	{
		if(!$this->session->getVar("setup_superadmin"))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			if($pString = $authorize->initLogon())
				return $pString;
		}
// else, run $method
		return $this->$method();
	}
// display options for custom fields
	function display($message = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "field"));
		$pString = '';
		if($message)
			$pString .= MISC::p($message);
		$pString .= MISC::p(MISC::a("link", $this->messages->text("custom", "addLabel"), 
			"index.php?action=customAddInit"));
		$recordset = $this->db->select(array("WKX_custom"), array('id'));
		if($this->db->numRows($recordset))
		{
			$pString .= MISC::p(MISC::a("link", $this->messages->text("custom", "deleteLabel"), 
				"index.php?action=customDeleteInit"));
			$pString .= MISC::p(MISC::a("link", $this->messages->text("custom", "editLabel"), 
				"index.php?action=customEditInit"));
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display options for adding fields
	function addInit($message = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "field", 
			" (" . $this->messages->text("custom", "addLabel") . ")"));
		$pString = '';
		if($message)
			$pString .= MISC::p($message);
		$pString .= FORM::formHeader("customAdd");
		$array = array("small" => $this->messages->text("custom", "small"), 
			"large" => $this->messages->text("custom", "large"));
		if(!$size = $this->session->getVar("custom_size"))
			$size = "small";
		$pString .= FORM::selectedBoxValue($this->messages->text("custom", "size"), 
				"custom_size", $array, $size, 2) . " " . MISC::span('*', 'required');
		$pString .= MISC::p(FORM::textInput($this->messages->text("custom", "label"), 
			"custom_label", FALSE, 50, 255) . " " . MISC::span('*', 'required'));
		$pString .= FORM::formSubmit('Add');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Create the new field
	function add()
	{
		if(!$this->validateInput('add'))
			$this->badInput($this->errors->text("inputError", "missing"), "addInit");
		$fields = array("custom_label", "custom_size");
		$values[] = trim($this->label);
		if($this->size == 'large')
			$values[] = 'L';
		else
			$values[] = 'S';
		$this->db->insert("WKX_custom", $fields, $values);
		$pString = $this->success->text("field", " " . $this->messages->text("misc", "added") . " ");
		return $this->display($pString);
	}
// display fields for editing
	function editInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "field", 
		" (" . $this->messages->text("custom", "editLabel") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("customEditDisplay");
		$recordset = $this->db->select(array("WKX_custom"), array('id', 'custom_label'));
		while($row = $this->db->loopRecordSet($recordset))
			$fields[$row['id']] = $this->html->dbToFormTidy($row['custom_label']);
		if(!isset($fields))
			$this->badInput($this->errors->text("inputError", "invalid"), "display");
		$pString .= FORM::selectFBoxValue(FALSE, "editId", $fields, 5) . MISC::br() . FORM::formSubmit('Edit');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display editing form
	function editDisplay($message = FALSE)
	{
		if(!$this->validateInput('editDisplay'))
			$this->badInput($this->errors->text("inputError", "missing"), 'editInit');
		$this->template->setVar("heading", $this->messages->text("heading", "field", 
			" (" . $this->messages->text("custom", "editLabel") . ")"));
		$pString = '';
		if($message)
			$pString .= MISC::p($message);
		$recordset = $this->db->select(array("WKX_custom"), array("custom_label"), 
			" WHERE " . $this->db->formatField("id") . "=" . 
			$this->db->tidyInput($this->vars['editId']));
		$label = $this->html->dbToFormTidy($this->db->fetchOne($recordset));
		$pString .= FORM::formHeader("customEdit");
		$pString .= FORM::hidden("editId", $this->vars['editId']);
		$pString .= MISC::p(FORM::textInput($this->messages->text("custom", "label"), 
			"custom_label", $label, 50, 255) . " " . MISC::span('*', 'required'));
		$pString .= FORM::formSubmit('Edit');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Edit field
	function edit()
	{
		if(!$this->validateInput('edit'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'editInit');
		$this->db->update("WKX_custom", 
			array("custom_label" => $this->label), 
			" WHERE " . $this->db->formatField('id') ."=" . $this->db->tidyInput($this->vars['editId']));
		$pString = $this->success->text("field", " " . $this->messages->text("misc", "edited") . " ");
		return $this->display($pString);
	}
// Delete fields display.
	function deleteInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "field", 
			" (" . $this->messages->text("custom", "deleteLabel") . ")"));
		$recordset = $this->db->select(array("WKX_custom"), array('id', 'custom_label'));
		while($row = $this->db->loopRecordSet($recordset))
			$fields[$row['id']] = $this->html->dbToFormTidy($row['custom_label']);
		if(!isset($fields))
			$this->badInput($this->errors->text("inputError", "invalid"), "display");
		$pString = '';
		if($error)
			$pString .= MISC::p($error);
		$pString .= MISC::p(MISC::b($this->messages->text("custom", "warning")));
		$pString .= FORM::formHeader("customDeleteConfirm");
		$pString .= FORM::selectFBoxValueMultiple(FALSE, "delete", $fields, 5);
		$pString .= MISC::br() . $this->messages->text("hint", "multiples") . MISC::br();
		$pString .= MISC::br() . FORM::formSubmit('Delete');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Ask for confirmation of delete groups
	function deleteConfirm()
	{
		if(!$this->validateInput('delete'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
		$this->template->setVar("heading", $this->messages->text("heading", "field", 
		" (" . $this->messages->text("custom", "deleteLabel") . ")"));
		$pString = MISC::p(MISC::b($this->messages->text("custom", "warning")));
		$pString .= FORM::formHeader("customDelete");
		foreach($this->vars['delete'] as $id)
		{
			$pString .= FORM::hidden("delete_" . $id, $id);
			$ids[] = $id;
		}
		$condition = " WHERE " . $this->db->formatField('id') ."=" . 
			join(" OR " . $this->db->formatField('id') ."=", $ids);
		$recordset = $this->db->select(array("WKX_custom"), array('custom_label'), $condition);
		while($row = $this->db->loopRecordSet($recordset))
			$fieldValues[] = "'" . stripslashes($row['custom_label']) . "'";
		$pString .= MISC::p($this->messages->text("custom", "deleteConfirm", ": " . join(", ", $fieldValues)));
		$pString .= MISC::br() . FORM::formSubmit('Confirm');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Delete field(s)
	function delete()
	{
		if(!$ids = $this->validateInput('deleteConfirm'))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
// $ids is an array of field IDs
		$condition = " WHERE " . $this->db->formatField('id') ."=" . 
			join(" OR " . $this->db->formatField('id') ."=", $ids);
		$this->db->delete('WKX_custom', $condition);
		$condition = " WHERE " . $this->db->formatField('customId') ."=" . 
			join(" OR " . $this->db->formatField('id') ."=", $ids);
		$this->db->delete('WKX_resource_custom', $condition);
		$this->db->optimize('WKX_custom');
		$this->db->optimize('WKX_resource_custom');
		$pString = $this->success->text("field", " " . $this->messages->text("misc", "deleted") . " ");
		return $this->display($pString);
	}
// bad Input function
	function badInput($error, $method)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->$method($error));
	}
// validate input
	function validateInput($type)
	{
		if($type == 'add')
		{
// Write to session
			$this->size = isset($this->vars['custom_size']) ? $this->vars['custom_size'] : FALSE;
			$this->label = isset($this->vars['custom_label']) ? trim($this->vars['custom_label']) : FALSE;
			$this->session->setVar("custom_size", $this->size);
			$this->session->setVar("custom_label", $this->label);
			if(!$this->size)
				return FALSE;
			if(!$this->label)
				return FALSE;
		}
		else if($type == 'editDisplay')
		{
			if(!array_key_exists('editId', $this->vars))
				return FALSE;
		}
		else if($type == 'edit')
		{
			$this->label = isset($this->vars['custom_label']) ? trim($this->vars['custom_label']) : FALSE;
			if(!array_key_exists('editId', $this->vars) || !$this->label)
				return FALSE;
		}
		else if($type == 'delete')
		{
			if(!array_key_exists('delete', $this->vars) || empty($this->vars['delete']))
				return FALSE;
		}
		else if($type == 'deleteConfirm')
		{
			$ids = array();
			foreach($this->vars as $key => $value)
			{
				if(!preg_match("/delete_/", $key))
					continue;
				$ids[] = $value;
			}
			if(empty($ids))
				return FALSE;
			return $ids;
		}
		return TRUE;
	}
}
?>
