; Sketchy Interpreter and Core/Extension Library Test

'(package 'foo)
(package 'foo)
'(define bar 'baz)
(define bar 'baz)
'(define f (lambda () bar))
(define f (lambda () bar))
'bar
bar
'(f)
(f)
'(package)
(package)
'bar
bar
'(f)
(f)
'(define bar ())
(define bar ())
'bar
bar
'(f)
(f)

(package 'sketchy)
:load lib/sketchy.l
(package 'sketchy-ext)
:load src/sketchy-ext.l
(package)

'(quote x)
(quote x)
'(quote (car '(x.y)))
(quote (car '(x.y)))
''x
'x
''(car '(x.y))
'(car '(x.y))

'(cons 'x 'y)
(cons 'x 'y)
'(cons 'x '())
(cons 'x '())
'(cons 'x '(y.()))
(cons 'x '(y.()))
'(cons 'x '(y))
(cons 'x '(y))

'(car '(x y))
(car '(x y))
'(car '(x.y))
(car '(x.y))
'(car '(x))
(car '(x))
'(car 'x)
(car 'x)
'(car ())
(car ())

'(cdr '(x y))
(cdr '(x y))
'(cdr '(x.y))
(cdr '(x.y))
'(cdr '(x))
(cdr '(x))
'(cdr 'x)
(cdr 'x)
'(cdr ())
(cdr ())

'(pair? 'x)
(pair? 'x)
'(pair? '())
(pair? '())
'(pair? '(x.y))
(pair? '(x.y))
'(pair? '(x y))
(pair? '(x y))

'(char? 'x)
(char? 'x)
'(char? '())
(char? '())
'(char? #\a)
(char? #\a)
'(char? #\space)
(char? #\space)
'(char? #\newline)
(char? #\newline)
'(char? #\~)
(char? #\~)

'(string? 'x)
(string? 'x)
'(string? '())
(string? '())
'(string? "")
(string? "")
'(string? "hello, world!")
(string? "hello, world!")

'(symbol? '())
(symbol? '())
'(symbol? 'foo)
(symbol? 'foo)
'(symbol? 'symbol?)
(symbol? 'symbol?)

'(eq? 'x 'x)
(eq? 'x 'x)
'(eq? eq? eq?)
(eq? eq? eq?)
'(eq? '() '())
(eq? '() '())
'(eq? 'x 'y)
(eq? 'x 'y)
'(eq? 'x '(x.y))
(eq? 'x '(x.y))
'(eq? '(x.y) '(x.y))
(eq? '(x.y) '(x.y))
'((lambda (x) (eq? x x)) '(x.y))
((lambda (x) (eq? x x)) '(x.y))

'(null? '())
(null? '())
'(null? 'x)
(null? 'x)
'(null? '(x.y))
(null? '(x.y))
'(null? '(x y))
(null? '(x y))

'(cond (#t 'first) (#t 'second))
(cond (#t 'first) (#t 'second))
'(cond (#t 'first) (#f 'second))
(cond (#t 'first) (#f 'second))
'(cond (#f 'first) (#t 'second))
(cond (#f 'first) (#t 'second))
'(cond (#f 'first) (#f 'second))
(cond (#f 'first) (#f 'second))
'(cond (#f 'first))
(cond (#f 'first))
'(cond (#t 'first) ((bottom) (bottom)))
(cond (#t 'first) ((bottom) (bottom)))
'(cond x y)
(cond x y)
'(cond ('x 'foo) (#t 'bar))
(cond ('x 'foo) (#t 'bar))
'(cond (5 'foo) (#t 'bar))
(cond (5 'foo) (#t 'bar))
'(cond ("yes" 'foo) (#t 'bar))
(cond ("yes" 'foo) (#t 'bar))

'(and)
(and)
'(and #t)
(and #t)
'(and #f)
(and #f)
'(and 'foo)
(and 'foo)
'(and #t #t)
(and #t #t)
'(and #t #f)
(and #t #f)
'(and #f #t)
(and #f #t)
'(and #f #f)
(and #f #f)
'(and 'a 'b 'c)
(and 'a 'b 'c)
'(and 'a 'b #f)
(and 'a 'b #f)
'(and 'a #f 'c)
(and 'a #f 'c)
'(and #f 'b 'c)
(and #f 'b 'c)

'(or)
(or)
'(or #t)
(or #t)
'(or #f)
(or #f)
'(or 'foo)
(or 'foo)
'(or #t #t)
(or #t #t)
'(or #t #f)
(or #t #f)
'(or #f #t)
(or #f #t)
'(or #f #f)
(or #f #f)
'(or 'a 'b 'c)
(or 'a 'b 'c)
'(or 'a #f #f)
(or 'a #f #f)
'(or #f 'b #f)
(or #f 'b #f)
'(or #f #f 'c)
(or #f #f 'c)

'(char->integer 'foo)
(char->integer 'foo)
'(char->integer #\a)
(char->integer #\a)
'(char->integer #\Z)
(char->integer #\Z)
'(char->integer #\space)
(char->integer #\space)
'(char->integer #\newline)
(char->integer #\newline)
'(char->integer #\\)
(char->integer #\\)
'(char->integer #\()
(char->integer #\()

'(integer->char 'foo)
(integer->char 'foo)
'(integer->char 65)
(integer->char 65)
'(integer->char 122)
(integer->char 122)
'(integer->char 32)
(integer->char 32)
'(integer->char 92)
(integer->char 92)
'(integer->char 40)
(integer->char 40)

'(integer->list 'foo)
(integer->list 'foo)
'(integer->list 123)
(integer->list 123)
'(integer->list +123)
(integer->list +123)
'(integer->list 0)
(integer->list 0)
'(integer->list -987)
(integer->list -987)

'(list->integer '(1d 2d 3d))
(list->integer '(1d 2d 3d))
'(list->integer '(+ 1d 2d 3d))
(list->integer '(+ 1d 2d 3d))
'(list->integer '(0d))
(list->integer '(0d))
'(list->integer '(- 1d 2d 3d))
(list->integer '(- 1d 2d 3d))
'(list->integer '(1d 2d 3d) #t)
(list->integer '(1d 2d 3d) #t)
'(list->integer '())
(list->integer '())

'(list->string 'foo)
(list->string 'foo)
'(list->string '(#\a #\b #\c))
(list->string '(#\a #\b #\c))
'(list->string '(#\H #\e #\l #\l #\o #\, #\space #\W #\o #\r #\l #\d #\!))
(list->string '(#\H #\e #\l #\l #\o #\, #\space #\W #\o #\r #\l #\d #\!))
'(list->string '())
(list->string '())

'(string->list 'foo)
(string->list 'foo)
'(string->list "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
(string->list "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
'(string->list "Hello, World!")
(string->list "Hello, World!")
'(string->list "")
(string->list "")

'(string->symbol 'foo)
(string->symbol 'foo)
'(string->symbol "foo")
(string->symbol "foo")
'(string->symbol "string->symbol")
(string->symbol "string->symbol")
'(string->symbol "")
(string->symbol "")

'(symbol->string "foo")
(symbol->string "foo")
'(symbol->string 'foo)
(symbol->string 'foo)
'(symbol->string 'symbol->string)
(symbol->string 'symbol->string)

'( (read)() )
(read)()
'( (read)     (x) )
(read)     (x)
'( (read) foo )
(read) foo
'( (read) 'foo )
(read) 'foo
'( (read) (a.b) )
(read) (a.b)
'( (read) (a b c) )
(read) (a b c)
'( (read) #t )
(read) #t
'( (read) #f )
(read) #f
'( (read) (lambda (x) x) )
(read) (lambda (x) x)
'( (read) 123 )
(read) 123
'( (read) #\X )
(read) #\X
'( (read) "some text" )
(read) "some text"
'( (read) (read) )
(read) (read)

'( (read-char)x )
(read-char)x
'( (read-char) x )	; read the #\space before x
(read-char) x
'( (read-char)";" )	; read a semicolon
(read-char);
'( (read-char)Z )
(read-char)Z
'( (read-char) )
(read-char)

'(write ())
(write ())
'(write 'foo)
(write 'foo)
'(write '(a.b))
(write '(a.b))
'(write '(a b c))
(write '(a b c))
'(write #t)
(write #t)
'(write #f)
(write #f)
'(write (lambda (x) x))
(write (lambda (x) x))
'(write 123)
(write 123)
'(write #\X)
(write #\X)
'(write #\space)
(write #\space)
'(write #\newline)
(write #\newline)
'(write "some text")
(write "some text")

'(display ())
(display ())
'(display 'foo)
(display 'foo)
'(display '(a.b))
(display '(a.b))
'(display '(a b c))
(display '(a b c))
'(display #t)
(display #t)
'(display #f)
(display #f)
'(display (lambda (x) x))
(display (lambda (x) x))
'(display 123)
(display 123)
'(display #\X)
(display #\X)
'(display #\space)
(display #\space)
'(display #\newline)
(display #\newline)
'(display "some text")
(display "some text")

:closure-form 2
'(lambda () '())
(lambda () '())
'(lambda (x) x)
(lambda (x) x)
'(lambda (x y z) (list x y z))
(lambda (x y z) (list x y z))
'((lambda () '()))
((lambda () '()))
'((lambda (x) x) 'first)
((lambda (x) x) 'first)
'((lambda (x y z) (list x y z)) 'first 'second 'third)
((lambda (x y z) (list x y z)) 'first 'second 'third)
'((lambda (x) x) 'first)
((lambda (x) x) 'first)
'((lambda (x) x))
((lambda (x) x))
'((lambda (x) x) 'first 'second)
((lambda (x) x) 'first 'second)
'(lambda (x) (list x y z) ((y.second) (z.third)))
(lambda (x) (list x y z) ((y.second) (z.third)))
'((lambda (x) (list x y z) ((y.second) (z.third))) 'first)
((lambda (x) (list x y z) ((y.second) (z.third))) 'first)
'(lambda (y) (lambda (x) (cons x y)))
(lambda (y) (lambda (x) (cons x y)))
'((lambda (x) (lambda (y) (cons x y))) 'first)
((lambda (x) (lambda (y) (cons x y))) 'first)
'(((lambda (x) (lambda (y) (cons x y))) 'first) 'second)
(((lambda (x) (lambda (y) (cons x y))) 'first) 'second)
:closure-form 0

'((lambda (a . b) b))
((lambda (a . b) b))
'((lambda (a . b) a) 'foo)
((lambda (a . b) a) 'foo)
'((lambda (a . b) b) 'foo)
((lambda (a . b) b) 'foo)
'((lambda (a . b) b) 'foo 'bar)
((lambda (a . b) b) 'foo 'bar)
'((lambda (a . b) b) 'foo 'bar 'baz)
((lambda (a . b) b) 'foo 'bar 'baz)

'((lambda (a b . c) a) 'foo 'bar)
((lambda (a b . c) a) 'foo 'bar)
'((lambda (a b . c) b) 'foo 'bar)
((lambda (a b . c) b) 'foo 'bar)
'((lambda (a b . c) c) 'foo 'bar)
((lambda (a b . c) c) 'foo 'bar)
'((lambda (a b . c) c) 'foo 'bar 'baz)
((lambda (a b . c) c) 'foo 'bar 'baz)

'((lambda a a))
((lambda a a))
'((lambda a a) 'foo)
((lambda a a) 'foo)
'((lambda a a) 'foo 'bar)
((lambda a a) 'foo 'bar)
'((lambda a a) 'foo 'bar 'baz)
((lambda a a) 'foo 'bar 'baz)

'(let () '())
(let () '())
'(let ((x 'first)) x)
(let ((x 'first)) x)
'(let ((x 'first) (y 'second) (z 'third)) (list x y z))
(let ((x 'first) (y 'second) (z 'third)) (list x y z))
'(let (x) x)
(let (x) x)
'(let x x)
(let x x)
'(let ((x 0))
  (let ((x 1)
        (y (* x 5)))
    y))
(let ((x 0))
  (let ((x 1)
        (y (* x 5)))
    y))
'(let ((x 0))
  (let ((x 1))
    (let ((y (* x 5)))
      y)))
(let ((x 0))
  (let ((x 1))
    (let ((y (* x 5)))
      y)))

'(letrec () '())
(letrec () '())
'(letrec ((x 'first)) x)
(letrec ((x 'first)) x)
'(letrec ((x 'first) (y 'second) (z 'third)) (list x y z))
(letrec ((x 'first) (y 'second) (z 'third)) (list x y z))
'(letrec (x) x)
(letrec (x) x)
'(letrec x x)
(letrec x x)
'(letrec ((even-p (lambda (x)
		(cond ((null? x) #t)
			(#t (odd-p (cdr x))))))
	(odd-p (lambda (x)
		(cond ((null? x) #f)
			(#t (even-p (cdr x)))))))
	(list (odd-p '(i i i i i)) (even-p '(i i i i i))))
(letrec ((even-p (lambda (x)
		(cond ((null? x) #t)
			(#t (odd-p (cdr x))))))
	(odd-p (lambda (x)
		(cond ((null? x) #f)
			(#t (even-p (cdr x)))))))
	(list (odd-p '(i i i i i)) (even-p '(i i i i i))))

'some-function
some-function
'(define some-function (lambda (x y z) (list x y z)))
(define some-function (lambda (x y z) (list x y z)))
'some-function
some-function
'(some-function 'first 'second 'third)
(some-function 'first 'second 'third)

'some-symbol
some-symbol
'(define some-symbol some-function)
(define some-symbol some-function)
'some-symbol
some-symbol
'(some-symbol 'first 'second 'third)
(some-symbol 'first 'second 'third)
'(define some-symbol 'some-function)
(define some-symbol 'some-function)
'some-symbol
some-symbol
'(define some-symbol (lambda (x y)
	(cond ((null x) y)
		(#t (some-symbol (cdr x) (cons 'i y))))))
(define some-symbol (lambda (x y)
	(cond ((null? x) y)
		(#t (some-symbol (cdr x) (cons 'i y))))))
'some-symbol
some-symbol
'(some-symbol '(h e l l o - w o r l d) '())
(some-symbol '(h e l l o - w o r l d) '())

'(define (f) ())
(define (f) ())
'(f)
(f)
'(define (f x) x)
(define (f x) x)
'(f 'a)
(f 'a)
'(define (f x y) y)
(define (f x y) y)
'(f 'a 'b)
(f 'a 'b)
'(define (f x . y) y)
(define (f x . y) y)
'(f 'a 'b 'c)
(f 'a 'b 'c)
'(define (f . x) x)
(define (f . x) x)
'(f 'a 'b 'c)
(f 'a 'b 'c)

'(bottom)
(bottom)
'(bottom 'x 'y 'z)
(bottom 'x 'y 'z)
'(eq? (bottom 'x) 'x)
(eq? (bottom 'x) 'x)

'(apply (lambda () 'foo) ())
(apply (lambda () 'foo) ())
'(apply car '((a.b)))
(apply car '((a.b)))
'(apply cons '(foo bar))
(apply cons '(foo bar))
'(apply list '(foo bar baz goo gaa))
(apply list '(foo bar baz goo gaa))

'(begin)
(begin)
'(begin 1)
(begin 1)
'(begin 1 2 3 4 5)
(begin 1 2 3 4 5)
'(begin (display 'foo) (display 'bar))
(begin (display 'foo) (display 'bar))

'(void)
(void)

'(define env '((f . (lambda (x) (or (null? x) (g (cdr x))) ((g))))
	(g . (lambda (x) (f x) ((f))))))
(define env '((f . (lambda (x) (or (null? x) (g (cdr x))) ((g))))
	(g . (lambda (x) (f x) ((f))))))
'(car (car (cdr (cdr (cdr (cdr (car env)))))))
(car (car (cdr (cdr (cdr (cdr (car env)))))))
'(car (car (cdr (cdr (cdr (cdr (car (cdr env))))))))
(car (car (cdr (cdr (cdr (cdr (car (cdr env))))))))
'(define r-env (recursive-bind env))
(define r-env (recursive-bind env))
'(null? (cdr (car (car (cdr (cdr (cdr (cdr (car env)))))))))
(null? (cdr (car (car (cdr (cdr (cdr (cdr (car env)))))))))
'(null? (cdr (car (car (cdr (cdr (cdr (cdr (car (cdr env))))))))))
(null? (cdr (car (car (cdr (cdr (cdr (cdr (car (cdr env))))))))))

'((car ((lambda (x) (list (lambda () x))) 'foo)))
((car ((lambda (x) (list (lambda () x))) 'foo)))

'(call/cc (lambda (k) 'foo))
(call/cc (lambda (k) 'foo))
'(cons 'foo (call/cc (lambda (k) (k 'bar))))
(cons 'foo (call/cc (lambda (k) (k 'bar))))
'(cons 'foo (call/cc (lambda (k) (cons 'zzz (k 'bar)))))
(cons 'foo (call/cc (lambda (k) (cons 'zzz (k 'bar)))))
'((call/cc call/cc) (lambda (x) x))
((call/cc call/cc) (lambda (x) x))
'((call/cc (lambda (x) x)) (lambda (x) x))
((call/cc (lambda (x) x)) (lambda (x) x))

'(letrec ((x (call/cc (lambda (x) x))))
	(cond ((procedure? x) (x 'foo))
		(#t x)))
(letrec ((x (call/cc (lambda (x) x))))
	(cond ((procedure? x) (x 'foo))
		(#t x)))

'((lambda (x)
   (cond ((pair? x) ((car x) (lambda () x)))
       (#t (pair? (x)))))
 (call/cc list))
((lambda (x)
   (cond ((pair? x) ((car x) (lambda () x)))
       (#t (pair? (x)))))
 (call/cc list))

'(letrec
	((k1 (lambda (x)
		(cond ((procedure? x) (x #f))
			(#t ((lambda (ignored) (pair? x))
				(letrec ((k2 (lambda (y) y)))
					(k2 (car x)))))))))
	(k1 (list k1)))
(letrec
	((k1 (lambda (x)
		(cond ((procedure? x) (x #f))
			(#t ((lambda (ignored) (pair? x))
				(letrec ((k2 (lambda (y) y)))
					(k2 (car x)))))))))
	(k1 (list k1)))

'((lambda (k1) (k1 (list k1)))
	(lambda (x) (cond ((procedure? x) (x #f))
			(#t ((lambda (ignored) (pair? x))
				((lambda (k2) (k2 (car x)))
					(lambda (y) y)))))))
((lambda (k1) (k1 (list k1)))
	(lambda (x) (cond ((procedure? x) (x #f))
			(#t ((lambda (ignored) (pair? x))
				((lambda (k2) (k2 (car x)))
					(lambda (y) y)))))))

'(letrec
	((x (call/cc list))
	(y (call/cc list)))
	(cond ((procedure? x) (x (pair? y)))
		((procedure? y) (y (pair? x)))
		((call/cc (car x)) (call/cc (car y)))
		(#t #f)))
(letrec
	((x (call/cc list))
	(y (call/cc list)))
	(cond ((procedure? x) (x (pair? y)))
		((procedure? y) (y (pair? x)))
		((call/cc (car x)) (call/cc (car y)))
		(#t #f)))

'(letrec ((x (call/cc (lambda (k) (cons 'a k)))))
	(letrec ((v (car x))
			(k (cdr x)))
		(cond
			((eq? v 'a) (k (cons 'b k)))
			((eq? v 'b) (k (cons 'c k)))
			((eq? v 'c) 'foo)
			(#t #f))))
(letrec ((x (call/cc (lambda (k) (cons 'a k)))))
	(letrec ((v (car x))
			(k (cdr x)))
		(cond
			((eq? v 'a) (k (cons 'b k)))
			((eq? v 'b) (k (cons 'c k)))
			((eq? v 'c) 'foo)
			(#t #f))))

'(letrec ((x (call/cc (lambda (c)
                         (list #t c)))))
   (cond ((car x)
       ((cadr x) (list #f (lambda () x))))
     (#t (eq? x ((cadr x))))))

(letrec ((x (call/cc (lambda (c)
                        (list #t c)))))
  (cond ((car x)
      ((cadr x) (list #f (lambda () x))))
    (#t (eq? x ((cadr x))))))

(define testfile "___test___")
(define testdata '(symbol 555 ((a.b) (c.d)) (list with members) 123
	(car (some expr)) #\x #\y #\z))

'(with-input-from-file testfile (lambda () ()))
(with-input-from-file testfile (lambda () ()))
'(with-output-to-file testfile (lambda () (write testdata)))
(with-output-to-file testfile (lambda () (write testdata)))
'(with-input-from-file testfile read)
(with-input-from-file testfile read)
'(with-input-from-file testfile (lambda () (eof-object? (read))))
(with-input-from-file testfile (lambda () (eof-object? (read))))
'(with-output-to-file testfile (lambda () ()))
(with-output-to-file testfile (lambda () ()))
'(with-input-from-file testfile read)
(with-input-from-file testfile read)
'(with-input-from-file testfile (lambda () (eof-object? (read))))
(with-input-from-file testfile (lambda () (eof-object? (read))))

'(delete-file testfile)
(delete-file testfile)
'(delete-file testfile)
(delete-file testfile)

(define slist1 '(a b c d e f g h i j))
(define slist2 '(z y x w v u t s r q))

(define nlist '(10 5 25 19 9 101 77 0 33 45))
(define olist '(0 5 9 10 19 25 33 45 77 101))

(define alist '((i.1) (ii.2) (iii.3) (iv.4) (v.5) (vi.6) (vii.7) (viii.8)
	(ix.9) (x.10)))

(define clist1 '(((a b) (c d) e) ((f g) (h i)) ((j k) (l m)) n))
(define clist2 '(((a b) (c d) x) ((f g) (h i)) ((j k) (l m)) n))

(define set1 slist1)
(define set2 '(f g h i j k l m n o p))

(define plist1 '(i ii iii iv v vi vii viii ix x))
(define plist2 '(1 2 3 4 5 6 7 8 9 10))

(define num1 55555)
(define num2 777)

(define int1 +55555)
(define int2 +777)
(define int1n -55555)
(define int2n -777)

(define xlist '(symbol 555 (list with members) 123 (car (#\a #\b))))

(define expr '(symbol 555 ((a.b) (c.d)) (list with members) 123
	(car (some expr)) #\x #\y #\z))

'(symbol? 'foo)
(symbol? 'foo)
'(symbol? '(a.b))
(symbol? '(a.b))
'(symbol? '(a b c))
(symbol? '(a b c))
'(symbol? #t)
(symbol? #t)
'(symbol? #f)
(symbol? #f)
'(symbol? (lambda (x) x))
(symbol? (lambda (x) x))
'(symbol? 123)
(symbol? 123)
'(symbol? #\X)
(symbol? #\X)
'(symbol? "some text")
(symbol? "some text")

'(pair? 'foo)
(pair? 'foo)
'(pair? '(a.b))
(pair? '(a.b))
'(pair? '(a b c))
(pair? '(a b c))
'(pair? #t)
(pair? #t)
'(pair? #f)
(pair? #f)
'(pair? (lambda (x) x))
(pair? (lambda (x) x))
'(pair? 123)
(pair? 123)
'(pair? #\X)
(pair? #\X)
'(pair? "some text")
(pair? "some text")

'(list? 'foo)
(list? 'foo)
'(list? '(a.b))
(list? '(a.b))
'(list? '(a b c))
(list? '(a b c))
'(list? #t)
(list? #t)
'(list? #f)
(list? #f)
'(list? (lambda (x) x))
(list? (lambda (x) x))
'(list? 123)
(list? 123)
'(list? #\X)
(list? #\X)
'(list? "some text")
(list? "some text")

'(boolean? 'foo)
(boolean? 'foo)
'(boolean? '(a.b))
(boolean? '(a.b))
'(boolean? '(a b c))
(boolean? '(a b c))
'(boolean? #t)
(boolean? #t)
'(boolean? #f)
(boolean? #f)
'(boolean? (lambda (x) x))
(boolean? (lambda (x) x))
'(boolean? 123)
(boolean? 123)
'(boolean? #\X)
(boolean? #\X)
'(boolean? "some text")
(boolean? "some text")

'(procedure? 'foo)
(procedure? 'foo)
'(procedure? '(a.b))
(procedure? '(a.b))
'(procedure? '(a b c))
(procedure? '(a b c))
'(procedure? #t)
(procedure? #t)
'(procedure? #f)
(procedure? #f)
'(procedure? (lambda (x) x))
(procedure? (lambda (x) x))
'(procedure? 123)
(procedure? 123)
'(procedure? #\X)
(procedure? #\X)
'(procedure? "some text")
(procedure? "some text")

'(number? 'foo)
(number? 'foo)
'(number? '(a.b))
(number? '(a.b))
'(number? '(a b c))
(number? '(a b c))
'(number? #t)
(number? #t)
'(number? #f)
(number? #f)
'(number? (lambda (x) x))
(number? (lambda (x) x))
'(number? 123)
(number? 123)
'(number? #\X)
(number? #\X)
'(number? "some text")
(number? "some text")

'(char? 'foo)
(char? 'foo)
'(char? '(a.b))
(char? '(a.b))
'(char? '(a b c))
(char? '(a b c))
'(char? #t)
(char? #t)
'(char? #f)
(char? #f)
'(char? (lambda (x) x))
(char? (lambda (x) x))
'(char? 123)
(char? 123)
'(char? #\X)
(char? #\X)
'(char? "some text")
(char? "some text")

'(string? 'foo)
(string? 'foo)
'(string? '(a.b))
(string? '(a.b))
'(string? '(a b c))
(string? '(a b c))
'(string? #t)
(string? #t)
'(string? #f)
(string? #f)
'(string? (lambda (x) x))
(string? (lambda (x) x))
'(string? 123)
(string? 123)
'(string? #\X)
(string? #\X)
'(string? "some text")
(string? "some text")

'(* int1 int2)
(* int1 int2)
'(* int1n int2)
(* int1n int2)
'(* int1 int2n)
(* int1 int2n)
'(* int1n int2n)
(* int1n int2n)
'(* num1 num2)
(* num1 num2)
'(*)
(*)
'(* 2)
(* 2)
'(* 2 3 5)
(* 2 3 5)

'(+ int1 int2)
(+ int1 int2)
'(+ int1 int2n)
(+ int1 int2n)
'(+ int1n int2)
(+ int1n int2)
'(+ int1n int2n)
(+ int1n int2n)
'(+ num1 num2)
(+ num1 num2)
'(+ num2 num1)
(+ num2 num1)
'(+)
(+)
'(+ 1)
(+ 1)
'(+ 1 2 3)
(+ 1 2 3)

'(- int1 int2)
(- int1 int2)
'(- int1 int2n)
(- int1 int2n)
'(- int1n int2)
(- int1n int2)
'(- int1n int2n)
(- int1n int2n)
'(- int2 int1)
(- int2 int1)
'(- int2 int1n)
(- int2 int1n)
'(- int2n int1)
(- int2n int1)
'(- int2n int1n)
(- int2n int1n)
'(- num1 num2)
(- num1 num2)
'(- num2 num1)
(- num2 num1)
'(- 1)
(- 1)
'(- 1 2 3)
(- 1 2 3)
'(- 1 -2 3 -4 5)
(- 1 -2 3 -4 5)

'(< int1 int2)
(< int1 int2)
'(< int2n int1n)
(< int2n int1n)
'(< num1 num2)
(< num1 num2)
'(< num2 num1)
(< num2 num1)
'(< 1 2 3)
(< 1 2 3)
'(< 1 0 3)
(< 1 0 3)

'(<= int1 int2)
(<= int1 int2)
'(<= int2n int1n)
(<= int2n int1n)
'(<= num1 num2)
(<= num1 num2)
'(<= num2 num1)
(<= num2 num1)
'(<= 1 2 2)
(<= 1 2 2)
'(<= 1 0 2)
(<= 1 0 2)

'(= int1 int1)
(= int1 int1)
'(= int1 int2)
(= int1 int2)
'(= num2 num2)
(= num2 num2)
'(= num2 num1)
(= num2 num1)
'(= 1 1 1)
(= 1 1 1)
'(= 1 0 1)
(= 1 0 1)

'(> int1 int2)
(> int1 int2)
'(> int2n int1n)
(> int2n int1n)
'(> num1 num2)
(> num1 num2)
'(> num2 num1)
(> num2 num1)
'(> 7 5 3)
(> 7 5 3)
'(> 7 5 5)
(> 7 5 5)

'(>= int1 int2)
(>= int1 int2)
'(>= int2n int1n)
(>= int2n int1n)
'(>= num1 num2)
(>= num1 num2)
'(>= num2 num1)
(>= num2 num1)
'(>= 3 2 2)
(>= 3 2 2)
'(>= 3 5 2)
(>= 3 5 2)

'(abs num1)
(abs num1)
'(abs int1)
(abs int1)
'(abs int1n)
(abs int1n)

'(any '((a b c) x (d e f)) symbol?)
(any '((a b c) x (d e f)) symbol?)
'(any '((a b c) (d e f)) symbol?)
(any '((a b c) (d e f)) symbol?)
'(any () symbol?) 
(any () symbol?)

'(append slist1 slist2)
(append slist1 slist2)
'(append slist1 '())
(append slist1 '())
'(append '() slist1)
(append '() slist1)
'(append '() '())
(append '() '())
'(append)
(append)
'(append '(a b))
(append '(a b))
'(append '(a b) '(c d))
(append '(a b) '(c d))
'(append '(a b) '(c d) '(e f))
(append '(a b) '(c d) '(e f))
'(append '(a b) 'c)
(append '(a b) 'c)
'(append '(a) 'b)
(append '(a) 'b)
'(append 'a)
(append 'a)

'(assoc 'vii alist)
(assoc 'vii alist)
'(assoc 'xxx alist)
(assoc 'xxx alist)
'(assoc 'xxx '())
(assoc 'xxx '())

; (caaaar clist1)
; (caaadr clist1)
; (caadar clist1)
; (caaddr clist1)
; (cadaar clist1)
; (cadadr clist1)
; (caddar clist1)
; (cadddr clist1)
; (cdaaar clist1)
; (cdaadr clist1)
; (cdadar clist1)
; (cdaddr clist1)
; (cddaar clist1)
; (cddadr clist1)
; (cdddar clist1)
; (cddddr clist1)

'(caaar clist1)
(caaar clist1)
'(caadr clist1)
(caadr clist1)
'(cadar clist1)
(cadar clist1)
'(caddr clist1)
(caddr clist1)
'(cdaar clist1)
(cdaar clist1)
'(cdadr clist1)
(cdadr clist1)
'(cddar clist1)
(cddar clist1)
'(cdddr clist1)
(cdddr clist1)

'(caar clist1)
(caar clist1)
'(cadr clist1)
(cadr clist1)
'(cdar clist1)
(cdar clist1)
'(cddr clist1)
(cddr clist1)

'(char-alphabetic? #\a)
(char-alphabetic? #\a)
'(char-alphabetic? #\A)
(char-alphabetic? #\A)
'(char-alphabetic? #\z)
(char-alphabetic? #\z)
'(char-alphabetic? #\Z)
(char-alphabetic? #\Z)
'(char-alphabetic? #\@)
(char-alphabetic? #\@)
'(char-alphabetic? #\[)
(char-alphabetic? #\[)
'(char-alphabetic? #\`)
(char-alphabetic? #\`)
'(char-alphabetic? #\{)
(char-alphabetic? #\{)

'(char-ci<? #\+ #\+)
(char-ci<? #\+ #\+)
'(char-ci<? #\+ #\-)
(char-ci<? #\+ #\-)
'(char-ci<? #\A #\A)
(char-ci<? #\A #\A)
'(char-ci<? #\A #\a)
(char-ci<? #\A #\a)
'(char-ci<? #\a #\A)
(char-ci<? #\a #\A)
'(char-ci<? #\a #\a)
(char-ci<? #\a #\a)
'(char-ci<? #\A #\Z)
(char-ci<? #\A #\Z)
'(char-ci<? #\A #\z)
(char-ci<? #\A #\z)
'(char-ci<? #\a #\Z)
(char-ci<? #\a #\Z)
'(char-ci<? #\a #\z)
(char-ci<? #\a #\z)
'(char-ci<? #\Z #\A)
(char-ci<? #\Z #\A)
'(char-ci<? #\Z #\a)
(char-ci<? #\Z #\a)
'(char-ci<? #\z #\A)
(char-ci<? #\z #\A)
'(char-ci<? #\z #\a)
(char-ci<? #\z #\a)

'(char-ci<=? #\+ #\+)
(char-ci<=? #\+ #\+)
'(char-ci<=? #\+ #\-)
(char-ci<=? #\+ #\-)
'(char-ci<=? #\A #\A)
(char-ci<=? #\A #\A)
'(char-ci<=? #\A #\a)
(char-ci<=? #\A #\a)
'(char-ci<=? #\a #\A)
(char-ci<=? #\a #\A)
'(char-ci<=? #\a #\a)
(char-ci<=? #\a #\a)
'(char-ci<=? #\A #\Z)
(char-ci<=? #\A #\Z)
'(char-ci<=? #\A #\z)
(char-ci<=? #\A #\z)
'(char-ci<=? #\a #\Z)
(char-ci<=? #\a #\Z)
'(char-ci<=? #\a #\z)
(char-ci<=? #\a #\z)
'(char-ci<=? #\Z #\A)
(char-ci<=? #\Z #\A)
'(char-ci<=? #\Z #\a)
(char-ci<=? #\Z #\a)
'(char-ci<=? #\z #\A)
(char-ci<=? #\z #\A)
'(char-ci<=? #\z #\a)
(char-ci<=? #\z #\a)

'(char-ci=? #\+ #\+)
(char-ci=? #\+ #\+)
'(char-ci=? #\+ #\-)
(char-ci=? #\+ #\-)
'(char-ci=? #\A #\A)
(char-ci=? #\A #\A)
'(char-ci=? #\A #\a)
(char-ci=? #\A #\a)
'(char-ci=? #\a #\A)
(char-ci=? #\a #\A)
'(char-ci=? #\a #\a)
(char-ci=? #\a #\a)
'(char-ci=? #\A #\Z)
(char-ci=? #\A #\Z)
'(char-ci=? #\A #\z)
(char-ci=? #\A #\z)
'(char-ci=? #\a #\Z)
(char-ci=? #\a #\Z)
'(char-ci=? #\a #\z)
(char-ci=? #\a #\z)

'(char-ci>? #\+ #\+)
(char-ci>? #\+ #\+)
'(char-ci>? #\+ #\-)
(char-ci>? #\+ #\-)
'(char-ci>? #\A #\A)
(char-ci>? #\A #\A)
'(char-ci>? #\A #\a)
(char-ci>? #\A #\a)
'(char-ci>? #\a #\A)
(char-ci>? #\a #\A)
'(char-ci>? #\a #\a)
(char-ci>? #\a #\a)
'(char-ci>? #\A #\Z)
(char-ci>? #\A #\Z)
'(char-ci>? #\A #\z)
(char-ci>? #\A #\z)
'(char-ci>? #\a #\Z)
(char-ci>? #\a #\Z)
'(char-ci>? #\a #\z)
(char-ci>? #\a #\z)
'(char-ci>? #\Z #\A)
(char-ci>? #\Z #\A)
'(char-ci>? #\Z #\a)
(char-ci>? #\Z #\a)
'(char-ci>? #\z #\A)
(char-ci>? #\z #\A)
'(char-ci>? #\z #\a)
(char-ci>? #\z #\a)

'(char-ci>=? #\+ #\+)
(char-ci>=? #\+ #\+)
'(char-ci>=? #\+ #\-)
(char-ci>=? #\+ #\-)
'(char-ci>=? #\A #\A)
(char-ci>=? #\A #\A)
'(char-ci>=? #\A #\a)
(char-ci>=? #\A #\a)
'(char-ci>=? #\a #\A)
(char-ci>=? #\a #\A)
'(char-ci>=? #\a #\a)
(char-ci>=? #\a #\a)
'(char-ci>=? #\A #\Z)
(char-ci>=? #\A #\Z)
'(char-ci>=? #\A #\z)
(char-ci>=? #\A #\z)
'(char-ci>=? #\a #\Z)
(char-ci>=? #\a #\Z)
'(char-ci>=? #\a #\z)
(char-ci>=? #\a #\z)
'(char-ci>=? #\Z #\A)
(char-ci>=? #\Z #\A)
'(char-ci>=? #\Z #\a)
(char-ci>=? #\Z #\a)
'(char-ci>=? #\z #\A)
(char-ci>=? #\z #\A)
'(char-ci>=? #\z #\a)
(char-ci>=? #\z #\a)

'(char-downcase #\a)
(char-downcase #\a)
'(char-downcase #\A)
(char-downcase #\A)
'(char-downcase #\z)
(char-downcase #\z)
'(char-downcase #\Z)
(char-downcase #\Z)
'(char-downcase #\@)
(char-downcase #\@)
'(char-downcase #\[)
(char-downcase #\[)
'(char-downcase #\`)
(char-downcase #\`)
'(char-downcase #\{)
(char-downcase #\{)

'(char-lower-case? #\a)
(char-lower-case? #\a)
'(char-lower-case? #\A)
(char-lower-case? #\A)
'(char-lower-case? #\z)
(char-lower-case? #\z)
'(char-lower-case? #\Z)
(char-lower-case? #\Z)
'(char-lower-case? #\@)
(char-lower-case? #\@)
'(char-lower-case? #\[)
(char-lower-case? #\[)
'(char-lower-case? #\`)
(char-lower-case? #\`)
'(char-lower-case? #\{)
(char-lower-case? #\{)

'(char-numeric? #\0)
(char-numeric? #\0)
'(char-numeric? #\9)
(char-numeric? #\9)
'(char-numeric? #\/)
(char-numeric? #\/)
'(char-numeric? #\:)
(char-numeric? #\:)

'(char-upcase #\a)
(char-upcase #\a)
'(char-upcase #\A)
(char-upcase #\A)
'(char-upcase #\z)
(char-upcase #\z)
'(char-upcase #\Z)
(char-upcase #\Z)
'(char-upcase #\@)
(char-upcase #\@)
'(char-upcase #\[)
(char-upcase #\[)
'(char-upcase #\`)
(char-upcase #\`)
'(char-upcase #\{)
(char-upcase #\{)

'(char-upper-case? #\a)
(char-upper-case? #\a)
'(char-upper-case? #\A)
(char-upper-case? #\A)
'(char-upper-case? #\z)
(char-upper-case? #\z)
'(char-upper-case? #\Z)
(char-upper-case? #\Z)
'(char-upper-case? #\@)
(char-upper-case? #\@)
'(char-upper-case? #\[)
(char-upper-case? #\[)
'(char-upper-case? #\`)
(char-upper-case? #\`)
'(char-upper-case? #\{)
(char-upper-case? #\{)

'(char-whitespace? #\0)
(char-whitespace? #\0)
'(char-whitespace? #\9)
(char-whitespace? #\9)
'(char-whitespace? #\a)
(char-whitespace? #\a)
'(char-whitespace? #\z)
(char-whitespace? #\z)
'(char-whitespace? #\ )
(char-whitespace? #\ )
'(char-whitespace? #\space)
(char-whitespace? #\space)
'(char-whitespace? #\newline)
(char-whitespace? #\newline)
'(char-whitespace? (integer->char 9))
(char-whitespace? (integer->char 9))
'(char-whitespace? (integer->char 10))
(char-whitespace? (integer->char 10))
'(char-whitespace? (integer->char 12))
(char-whitespace? (integer->char 12))
'(char-whitespace? (integer->char 13))
(char-whitespace? (integer->char 13))

'(char<? #\+ #\+)
(char<? #\+ #\+)
'(char<? #\+ #\-)
(char<? #\+ #\-)
'(char<? #\A #\A)
(char<? #\A #\A)
'(char<? #\A #\a)
(char<? #\A #\a)
'(char<? #\a #\A)
(char<? #\a #\A)
'(char<? #\a #\a)
(char<? #\a #\a)
'(char<? #\A #\Z)
(char<? #\A #\Z)
'(char<? #\A #\z)
(char<? #\A #\z)
'(char<? #\a #\Z)
(char<? #\a #\Z)
'(char<? #\a #\z)
(char<? #\a #\z)
'(char<? #\Z #\A)
(char<? #\Z #\A)
'(char<? #\Z #\a)
(char<? #\Z #\a)
'(char<? #\z #\A)
(char<? #\z #\A)
'(char<? #\z #\a)
(char<? #\z #\a)

'(char<=? #\+ #\+)
(char<=? #\+ #\+)
'(char<=? #\+ #\-)
(char<=? #\+ #\-)
'(char<=? #\A #\A)
(char<=? #\A #\A)
'(char<=? #\A #\a)
(char<=? #\A #\a)
'(char<=? #\a #\A)
(char<=? #\a #\A)
'(char<=? #\a #\a)
(char<=? #\a #\a)
'(char<=? #\A #\Z)
(char<=? #\A #\Z)
'(char<=? #\A #\z)
(char<=? #\A #\z)
'(char<=? #\a #\Z)
(char<=? #\a #\Z)
'(char<=? #\a #\z)
(char<=? #\a #\z)
'(char<=? #\Z #\A)
(char<=? #\Z #\A)
'(char<=? #\Z #\a)
(char<=? #\Z #\a)
'(char<=? #\z #\A)
(char<=? #\z #\A)
'(char<=? #\z #\a)
(char<=? #\z #\a)

'(char=? #\+ #\+)
(char=? #\+ #\+)
'(char=? #\+ #\-)
(char=? #\+ #\-)
'(char=? #\A #\A)
(char=? #\A #\A)
'(char=? #\A #\a)
(char=? #\A #\a)
'(char=? #\a #\A)
(char=? #\a #\A)
'(char=? #\a #\a)
(char=? #\a #\a)
'(char=? #\A #\Z)
(char=? #\A #\Z)
'(char=? #\A #\z)
(char=? #\A #\z)
'(char=? #\a #\Z)
(char=? #\a #\Z)
'(char=? #\a #\z)
(char=? #\a #\z)
'(char=? #\Z #\A)
(char=? #\Z #\A)
'(char=? #\Z #\a)
(char=? #\Z #\a)
'(char=? #\z #\A)
(char=? #\z #\A)
'(char=? #\z #\a)
(char=? #\z #\a)

'(char>? #\+ #\+)
(char>? #\+ #\+)
'(char>? #\+ #\-)
(char>? #\+ #\-)
'(char>? #\A #\A)
(char>? #\A #\A)
'(char>? #\A #\a)
(char>? #\A #\a)
'(char>? #\a #\A)
(char>? #\a #\A)
'(char>? #\a #\a)
(char>? #\a #\a)
'(char>? #\A #\Z)
(char>? #\A #\Z)
'(char>? #\A #\z)
(char>? #\A #\z)
'(char>? #\a #\Z)
(char>? #\a #\Z)
'(char>? #\a #\z)
(char>? #\a #\z)
'(char>? #\Z #\A)
(char>? #\Z #\A)
'(char>? #\Z #\a)
(char>? #\Z #\a)
'(char>? #\z #\A)
(char>? #\z #\A)
'(char>? #\z #\a)
(char>? #\z #\a)

'(char>=? #\+ #\+)
(char>=? #\+ #\+)
'(char>=? #\+ #\-)
(char>=? #\+ #\-)
'(char>=? #\A #\A)
(char>=? #\A #\A)
'(char>=? #\A #\a)
(char>=? #\A #\a)
'(char>=? #\a #\A)
(char>=? #\a #\A)
'(char>=? #\a #\a)
(char>=? #\a #\a)
'(char>=? #\A #\Z)
(char>=? #\A #\Z)
'(char>=? #\A #\z)
(char>=? #\A #\z)
'(char>=? #\a #\Z)
(char>=? #\a #\Z)
'(char>=? #\a #\z)
(char>=? #\a #\z)
'(char>=? #\Z #\A)
(char>=? #\Z #\A)
'(char>=? #\Z #\a)
(char>=? #\Z #\a)
'(char>=? #\z #\A)
(char>=? #\z #\A)
'(char>=? #\z #\a)
(char>=? #\z #\a)

'(count ())
(count ())
'(count 'x)
(count 'x)
'(count '(x))
(count '(x))
'(count '(x.y))
(count '(x.y))
'(count expr)
(count expr)

'(depth '())
(depth '())
'(depth 'x)
(depth 'x)
'(depth clist1)
(depth clist1)
'(depth '(((((x))))))
(depth '(((((x))))))
'(depth '(a (b (c) d) e))
(depth '(a (b (c) d) e))
'(depth 123)
(depth 123)

'(divide num1 num2)
(divide num1 num2)
'(divide num2 num1)
(divide num2 num1)
'(divide num1 1)
(divide num1 1)
'(divide num1 0)
(divide num1 0)

'digits
digits
'0d
0d
'1d
1d
'2d
2d
'3d
3d
'4d
4d
'5d
5d
'6d
6d
'7d
7d
'8d
8d
'9d
9d

'(equal? clist1 clist1)
(equal? clist1 clist1)
'(equal? clist1 clist2)
(equal? clist1 clist2)

'(even? 100)
(even? 100)
'(even? 101)
(even? 101)
'(even? -102)
(even? -102)
'(even? -103)
(even? -103)
'(even? 104)
(even? 104)
'(even? 105)
(even? 105)
'(even? 106)
(even? 106)
'(even? -107)
(even? -107)
'(even? -108)
(even? -108)
'(even? -109)
(even? -109)

'(every? '(a b c d e f) symbol?)
(every? '(a b c d e f) symbol?)
'(every? '(a b c (x.y) d e f) symbol?)
(every? '(a b c (x.y) d e f) symbol?)
'(every? () symbol?)
(every? () symbol?)

'(expt 2 0)
(expt 2 0)
'(expt 2 1)
(expt 2 1)
'(expt 2 8)
(expt 2 8)
'(expt 2 -1)
(expt 2 -1)

'(fact 0)
(fact 0)
'(fact 9)
(fact 9)
'(fact +0)
(fact +0)
'(fact +9)
(fact +9)
'(fact -1)
(fact -1)

'(factors 1)
(factors 1)
'(factors 15)
(factors 15)
'(factors 8)
(factors 8)
'(factors 12)
(factors 12)
'(factors 30)
(factors 30)
'(factors 0)
(factors 0)
'(factors -1)
(factors -1)

'(filter xlist number?)
(filter xlist number?)
'(filter '() null?)
(filter '() null?)

'(gcd 289 34)
(gcd 289 34)
'(gcd 34 289)
(gcd 34 289)
'(gcd +289 +34)
(gcd +289 +34)
'(gcd +34 +289)
(gcd +34 +289)

'(head? () '(a b c))
(head? () '(a b c))
'(head? '(a b c) '(a b c d e f))
(head? '(a b c) '(a b c d e f))
'(head? '(a c) '(a b c d e f))
(head? '(a c) '(a b c d e f))
'(head? '(a b c) '(a b c))
(head? '(a b c) '(a b c))
'(head? '(a b c d) '(a b c))
(head? '(a b c d) '(a b c))
'(head? '((a) ((b)) (c)) '((a) ((b)) (c) (d)))
(head? '((a) ((b)) (c)) '((a) ((b)) (c) (d)))

'(hyper 0 3 3)
(hyper 0 3 3)
'(hyper 1 3 3)
(hyper 1 3 3)
'(hyper 2 3 3)
(hyper 2 3 3)
'(hyper 3 3 3)
(hyper 3 3 3)
'(hyper 4 3 3)
(hyper 4 3 3)
'(hyper 100 2 2)
(hyper 100 2 2)

'(id '())
(id '())
'(id 'foo)
(id 'foo)
'(id expr)
(id expr)

'(insert 53 olist <)
(insert 53 olist <)

'(integer int1n)
(integer int1n)
'(integer num1)
(integer num1)
'(integer int1)
(integer int1)
'(integer int1n)
(integer int1n)
'(integer num1)
(integer num1)

'(intersection set1 set2)
(intersection set1 set2)
'(intersection set1 '())
(intersection set1 '())
'(intersection '() set2)
(intersection '() set2)
'(intersection '() '())
(intersection '() '())

'(iterate + nlist #f)
(iterate + nlist #f)
'(iterate - nlist #f)
(iterate - nlist #f)
'(iterate + '() 0)
(iterate + '() 0)

'(iota 0 0)
(iota 0 0)
'(iota 1 10)
(iota 1 10)
'(iota -10 10)
(iota -10 10)
'(iota 0 -1)
(iota 0 -1)

'(isort nlist >)
(isort nlist >)
'(isort nlist <)
(isort nlist <)
'(isort '() <)
(isort '() <)

'(last expr)
(last expr)
'(last '(x))
(last '(x))

'(length clist1)
(length clist1)
'(length nlist)
(length nlist)
'(length xlist)
(length xlist)

'(list)
(list)
'(list '())
(list '())
'(list 'x)
(list 'x)
'(list (list 'x))
(list (list 'x))
'(list 'a 'b)
(list 'a 'b)
'(list 'a 'b 'c)
(list 'a 'b 'c)
'(list 'a 'b 'c 'd)
(list 'a 'b 'c 'd)
'(list 'a 'b 'c 'd 'e)
(list 'a 'b 'c 'd 'e)

'(list-ref slist1 1)
(list-ref slist1 1)
'(list-ref slist1 5)
(list-ref slist1 5)
'(list-ref slist1 9)
(list-ref slist1 9)
'(list-ref slist1 0)
(list-ref slist1 0)
'(list-ref () 1)
(list-ref () 1)
'(list-ref () 0)
(list-ref () 0)

'(list-tail slist1 1)
(list-tail slist1 1)
'(list-tail slist1 5)
(list-tail slist1 5)
'(list-tail slist1 10)
(list-tail slist1 10)
'(list-tail slist1 0)
(list-tail slist1 0)
'(list-tail () 1)
(list-tail () 1)
'(list-tail () 0)
(list-tail () 0)

'(list? expr)
(list? expr)
'(list? '())
(list? '())
'(list? '(x))
(list? '(x))
'(list? '(a.b))
(list? '(a.b))
'(list? 'x)
(list? 'x)

'(map - nlist)
(map - nlist)
'(map (lambda (x) (* x x)) olist)
(map (lambda (x) (* x x)) olist)
'(map cons '(a b c) '(d e f))
(map cons '(a b c) '(d e f))
'(map list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o))
(map list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o))

'(maplist slist1 reverse)
(maplist slist1 reverse)

'(max 5)
(max 5)
'(max 1 2)
(max 1 2)
'(max 9 5 7)
(max 9 5 7)
'(apply max nlist)
(apply max nlist)

'(memq 'h slist1)
(memq 'h slist1)
'(memq 'x slist1)
(memq 'x slist1)
'(memq 'a '())
(memq 'a '())

'(member '(iv.4) alist)
(member '(iv.4) alist)
'(member '(iv.5) alist)
(member '(iv.5) alist)
'(member '(iv.4) '())
(member '(iv.4) '())

'(min 5)
(min 5)
'(min 1 2)
(min 1 2)
'(min 9 5 7)
(min 9 5 7)
'(apply min nlist)
(apply min nlist)

'(modulo int1 int2)
(modulo int1 int2)
'(modulo int1 int2n)
(modulo int1 int2n)
'(modulo int1n int2)
(modulo int1n int2)
'(modulo int1n int2n)
(modulo int1n int2n)
'(modulo int2 int1)
(modulo int2 int1)
'(modulo int2 int1n)
(modulo int2 int1n)
'(modulo int2n int1)
(modulo int2n int1)
'(modulo int2n int1n)
(modulo int2n int1n)
'(modulo num1 num2)
(modulo num1 num2)
'(modulo num1 int2)
(modulo num1 int2)
'(modulo num1 int2n)
(modulo num1 int2n)
'(modulo int1n num2)
(modulo int1n num2)

'(n* num1 num2)
(n* num1 num2)
'(n* num2 num1)
(n* num2 num1)
'(n* num1 1)
(n* num1 1)
'(n* num1 0)
(n* num1 0)

'(n+ num1 num2)
(n+ num1 num2)
'(n+ num2 num1)
(n+ num2 num1)
'(n+ num2 0)
(n+ num2 0)

'(n- num1 num2)
(n- num1 num2)
'(n- num2 num1)
(n- num2 num1)
'(n- num2 0)
(n- num2 0)

'(n< num1 num2)
(n< num1 num2)
'(n< num2 num1)
(n< num2 num1)
'(n< num1 num1)
(n< num1 num1)

'(n<= num1 num2)
(n<= num1 num2)
'(n<= num2 num1)
(n<= num2 num1)
'(n<= num2 num2)
(n<= num2 num2)

'(n> num1 num2)
(n> num1 num2)
'(n> num2 num1)
(n> num2 num1)
'(n> num2 num2)
(n> num2 num2)

'(n>= num1 num2)
(n>= num1 num2)
'(n>= num2 num1)
(n>= num2 num1)
'(n>= num1 num1)
(n>= num1 num1)

'(natural num1)
(natural num1)
'(natural int1)
(natural int1)
'(natural int1n)
(natural int1n)

'(natural? num1)
(natural? num1)
'(natural? int1)
(natural? int1)
'(natural? int1n)
(natural? int1n)

'(ndivide num1 num2)
(ndivide num1 num2)
'(ndivide num2 num1)
(ndivide num2 num1)
'(ndivide num1 1)
(ndivide num1 1)
'(ndivide num1 0)
(ndivide num1 0)

'(negate 1)
(negate 1)
'(negate +1)
(negate +1)
'(negate -1)
(negate -1)
'(negate int1)
(negate int1)
'(negate int1n)
(negate int1n)

'(negative? int1)
(negative? int1)
'(negative? int1n)
(negative? int1n)
'(negative? num1)
(negative? num1)
'(negative? 0)
(negative? 0)

'(non-negative? int1)
(non-negative? int1)
'(non-negative? int1n)
(non-negative? int1n)
'(non-negative? num1)
(non-negative? num1)
'(non-negative? 0)
(non-negative? 0)

'(neq? 'a 'a)
(neq? 'a 'a)
'(neq? 'a 'b)
(neq? 'a 'b)

'(not-equal? clist1 clist1)
(not-equal? clist1 clist1)
'(not-equal? clist1 clist2)
(not-equal? clist1 clist2)

'(newline)
(newline)

'(nexpt 2 0)
(nexpt 2 0)
'(nexpt 2 1)
(nexpt 2 1)
'(nexpt 2 8)
(nexpt 2 8)
'(nexpt 2 -1)
(nexpt 2 -1)

'(normalize 00012345)
(normalize 00012345)
'(normalize +00012345)
(normalize +00012345)
'(normalize -00012345)
(normalize -00012345)
'(normalize 0)
(normalize 0)

'(nquotient num1 num2)
(nquotient num1 num2)
'(nquotient num2 num1)
(nquotient num2 num1)

'(nremainder num1 num2)
(nremainder num1 num2)
'(nremainder num2 num1)
(nremainder num2 num1)

'(number->string 0)
(number->string 0)
'(number->string 123)
(number->string 123)
'(number->string 165 2)
(number->string 165 2)
'(number->string 375 8)
(number->string 375 8)
'(number->string 789 10)
(number->string 789 10)
'(number->string 11259375 16)
(number->string 11259375 16)
'(number->string +165 2)
(number->string +165 2)
'(number->string +375 8)
(number->string +375 8)
'(number->string +789 10)
(number->string +789 10)
'(number->string +11259375 16)
(number->string +11259375 16)
'(number->string -165 2)
(number->string -165 2)
'(number->string -375 8)
(number->string -375 8)
'(number->string -789 10)
(number->string -789 10)
'(number->string -11259375 16)
(number->string -11259375 16)
'(number->string 0 1)
(number->string 0 1)
'(number->string 0 17)
(number->string 0 17)

'(number? num1)
(number? num1)
'(number? int1)
(number? int1)
'(number? int1n)
(number? int1n)
'(number? clist1)
(number? clist1)

'(odd? 100)
(odd? 100)
'(odd? 101)
(odd? 101)
'(odd? -102)
(odd? -102)
'(odd? -103)
(odd? -103)
'(odd? 104)
(odd? 104)
'(odd? 105)
(odd? 105)
'(odd? 106)
(odd? 106)
'(odd? -107)
(odd? -107)
'(odd? -108)
(odd? -108)
'(odd? -109)
(odd? -109)

'(ordered? olist <)
(ordered? olist <)
'(ordered? nlist <)
(ordered? nlist <)
'(ordered? '() <)
(ordered? '() <)

'(pair plist1 plist2)
(pair plist1 plist2)
'(pair '() '())
(pair '() '())

'(permute '(a b c))
(permute '(a b c))
'(permute '(a a b))
(permute '(a a b))
'(permute '(a a a))
(permute '(a a a))
'(permute '())
(permute '())

'(positive? int1)
(positive? int1)
'(positive? int1n)
(positive? int1n)
'(positive? 0)
(positive? 0)
'(positive? num1)
(positive? num1)

'(procedure? num1)
(procedure? num1)
'(procedure? clist1)
(procedure? clist1)
'(procedure? (lambda (x) x))
(procedure? (lambda (x) x))
'(procedure? procedure?)
(procedure? procedure?)
'(procedure? cons)
(procedure? cons)

'(product 1 10)
(product 1 10)
'(product +1 +10)
(product +1 +10)
'(product 5 15)
(product 5 15)
'(product -1 -10)
(product -1 -10)
'(product 10 1)
(product 10 1)

'(qsort > nlist)
(qsort > nlist)
'(qsort < nlist)
(qsort < nlist)
'(qsort < '())
(qsort < '())

'(quotient int1 int2)
(quotient int1 int2)
'(quotient int1 int2n)
(quotient int1 int2n)
'(quotient int1n int2)
(quotient int1n int2)
'(quotient int1n int2n)
(quotient int1n int2n)
'(quotient int2 int1)
(quotient int2 int1)
'(quotient int2 int1n)
(quotient int2 int1n)
'(quotient int2n int1)
(quotient int2n int1)
'(quotient int2n int1n)
(quotient int2n int1n)
'(quotient num1 num2)
(quotient num1 num2)
'(quotient num1 int2)
(quotient num1 int2)
'(quotient num1 int2n)
(quotient num1 int2n)
'(quotient int1n num2)
(quotient int1n num2)

'(reduce cons slist1 '())
(reduce cons slist1 '())
'(reduce cons '() '())
(reduce cons '() '())

'(remainder int1 int2)
(remainder int1 int2)
'(remainder int1 int2n)
(remainder int1 int2n)
'(remainder int1n int2)
(remainder int1n int2)
'(remainder int1n int2n)
(remainder int1n int2n)
'(remainder int2 int1)
(remainder int2 int1)
'(remainder int2 int1n)
(remainder int2 int1n)
'(remainder int2n int1)
(remainder int2n int1)
'(remainder int2n int1n)
(remainder int2n int1n)
'(remainder num1 num2)
(remainder num1 num2)
'(remainder num1 int2)
(remainder num1 int2)
'(remainder num1 int2n)
(remainder num1 int2n)
'(remainder int1n num2)
(remainder int1n num2)

'(remove xlist number?)
(remove xlist number?)
'(remove '() null?)
(remove '() null?)

'(reverse clist1)
(reverse clist1)
'(reverse olist)
(reverse olist)
'(reverse '())
(reverse '())

'(some '((a b c) x (d e f)) symbol?)
(some '((a b c) x (d e f)) symbol?)
'(some '((a b c) (d e f)) symbol?)
(some '((a b c) (d e f)) symbol?)
'(some () symbol?)
(some () symbol?)

'(sqrt 1)
(sqrt 1)
'(sqrt 4)
(sqrt 4)
'(sqrt 99)
(sqrt 99)
'(sqrt -1)
(sqrt -1)

'(string)
(string)
'(string #\a)
(string #\a)
'(string #\a #\b)
(string #\a #\b)
'(string #\a #\b #\c)
(string #\a #\b #\c)
'(string #\a #\b #\c 'x)
(string #\a #\b #\c 'x)

'(string->number "0")
(string->number "0")
'(string->number "123")
(string->number "123")
'(string->number "10100101" 2)
(string->number "10100101" 2)
'(string->number "567" 8)
(string->number "567" 8)
'(string->number "789" 10)
(string->number "789" 10)
'(string->number "abcdef" 16)
(string->number "abcdef" 16)
'(string->number "+1010" 2)
(string->number "+1010" 2)
'(string->number "+123" 8)
(string->number "+123" 8)
'(string->number "+123" 10)
(string->number "+123" 10)
'(string->number "+123" 16)
(string->number "+123" 16)
'(string->number "-1010" 2)
(string->number "-1010" 2)
'(string->number "-123" 8)
(string->number "-123" 8)
'(string->number "-123" 10)
(string->number "-123" 10)
'(string->number "-123" 16)
(string->number "-123" 16)
'(string->number "02" 2)
(string->number "02" 2)
'(string->number "08" 8)
(string->number "08" 8)
'(string->number "0a" 10)
(string->number "0a" 10)
'(string->number "0g" 16)
(string->number "0g" 16)
'(string->number "0" 1)
(string->number "0" 1)
'(string->number "0" 17)
(string->number "0" 17)

'(string-append "" "")
(string-append "" "")
'(string-append "abc" "")
(string-append "abc" "")
'(string-append "" "def")
(string-append "" "def")
'(string-append "abc" "def")
(string-append "abc" "def")
'(string-append "abc" "def" "xyz")
(string-append "abc" "def" "xyz")

'(string-ci<? "test" "test")
(string-ci<? "test" "test")
'(string-ci<? "test" "tesa")
(string-ci<? "test" "tesa")
'(string-ci<? "test" "tesz")
(string-ci<? "test" "tesz")
'(string-ci<? "TEST" "tesa")
(string-ci<? "TEST" "tesa")
'(string-ci<? "TEST" "tesz")
(string-ci<? "TEST" "tesz")
'(string-ci<? "test" "TESA")
(string-ci<? "test" "TESA")
'(string-ci<? "test" "TESZ")
(string-ci<? "test" "TESZ")
'(string-ci<? "TEST" "TESA")
(string-ci<? "TEST" "TESA")
'(string-ci<? "TEST" "TESZ")
(string-ci<? "TEST" "TESZ")
'(string-ci<? "test" "tes")
(string-ci<? "test" "tes")
'(string-ci<? "test" "test0")
(string-ci<? "test" "test0")

'(string-ci<=? "test" "test")
(string-ci<=? "test" "test")
'(string-ci<=? "test" "tesa")
(string-ci<=? "test" "tesa")
'(string-ci<=? "test" "tesz")
(string-ci<=? "test" "tesz")
'(string-ci<=? "TEST" "tesa")
(string-ci<=? "TEST" "tesa")
'(string-ci<=? "TEST" "tesz")
(string-ci<=? "TEST" "tesz")
'(string-ci<=? "test" "TESA")
(string-ci<=? "test" "TESA")
'(string-ci<=? "test" "TESZ")
(string-ci<=? "test" "TESZ")
'(string-ci<=? "TEST" "TESA")
(string-ci<=? "TEST" "TESA")
'(string-ci<=? "TEST" "TESZ")
(string-ci<=? "TEST" "TESZ")
'(string-ci<=? "test" "tes")
(string-ci<=? "test" "tes")
'(string-ci<=? "test" "test0")
(string-ci<=? "test" "test0")

'(string-ci=? "abc" "abc")
(string-ci=? "abc" "abc")
'(string-ci=? "abC" "abc")
(string-ci=? "abC" "abc")
'(string-ci=? "aBc" "abc")
(string-ci=? "aBc" "abc")
'(string-ci=? "aBC" "abc")
(string-ci=? "aBC" "abc")
'(string-ci=? "Abc" "abc")
(string-ci=? "Abc" "abc")
'(string-ci=? "AbC" "abc")
(string-ci=? "AbC" "abc")
'(string-ci=? "ABc" "abc")
(string-ci=? "ABc" "abc")
'(string-ci=? "ABC" "abc")
(string-ci=? "ABC" "abc")
'(string-ci=? "aBc" "AbC")
(string-ci=? "aBc" "AbC")
'(string-ci=? "abc" "abd")
(string-ci=? "abc" "abd")
'(string-ci=? "abc" "abcd")
(string-ci=? "abc" "abcd")
'(string-ci=? "abcd" "abc")
(string-ci=? "abcd" "abc")

'(string-ci>? "test" "test")
(string-ci>? "test" "test")
'(string-ci>? "test" "tesa")
(string-ci>? "test" "tesa")
'(string-ci>? "test" "tesz")
(string-ci>? "test" "tesz")
'(string-ci>? "TEST" "tesa")
(string-ci>? "TEST" "tesa")
'(string-ci>? "TEST" "tesz")
(string-ci>? "TEST" "tesz")
'(string-ci>? "test" "TESA")
(string-ci>? "test" "TESA")
'(string-ci>? "test" "TESZ")
(string-ci>? "test" "TESZ")
'(string-ci>? "TEST" "TESA")
(string-ci>? "TEST" "TESA")
'(string-ci>? "TEST" "TESZ")
(string-ci>? "TEST" "TESZ")
'(string-ci>? "test" "tes")
(string-ci>? "test" "tes")
'(string-ci>? "test" "test0")
(string-ci>? "test" "test0")

'(string-ci>=? "test" "test")
(string-ci>=? "test" "test")
'(string-ci>=? "test" "tesa")
(string-ci>=? "test" "tesa")
'(string-ci>=? "test" "tesz")
(string-ci>=? "test" "tesz")
'(string-ci>=? "TEST" "tesa")
(string-ci>=? "TEST" "tesa")
'(string-ci>=? "TEST" "tesz")
(string-ci>=? "TEST" "tesz")
'(string-ci>=? "test" "TESA")
(string-ci>=? "test" "TESA")
'(string-ci>=? "test" "TESZ")
(string-ci>=? "test" "TESZ")
'(string-ci>=? "TEST" "TESA")
(string-ci>=? "TEST" "TESA")
'(string-ci>=? "TEST" "TESZ")
(string-ci>=? "TEST" "TESZ")
'(string-ci>=? "test" "tes")
(string-ci>=? "test" "tes")
'(string-ci>=? "test" "test0")
(string-ci>=? "test" "test0")

'(string-length "")
(string-length "")
'(string-length "a")
(string-length "a")
'(string-length "ab")
(string-length "ab")
'(string-length "abc")
(string-length "abc")
'(string-length "Hello, World!")
(string-length "Hello, World!")

'(string-ref "abc" 0)
(string-ref "abc" 0)
'(string-ref "abc" 1)
(string-ref "abc" 1)
'(string-ref "abc" 2)
(string-ref "abc" 2)
'(string-ref "abc" 3)
(string-ref "abc" 3)
'(string-ref "" 0)
(string-ref "" 0)

'(string<? "test" "test")
(string<? "test" "test")
'(string<? "test" "tesa")
(string<? "test" "tesa")
'(string<? "test" "tesz")
(string<? "test" "tesz")
'(string<? "TEST" "tesa")
(string<? "TEST" "tesa")
'(string<? "TEST" "tesz")
(string<? "TEST" "tesz")
'(string<? "test" "TESA")
(string<? "test" "TESA")
'(string<? "test" "TESZ")
(string<? "test" "TESZ")
'(string<? "TEST" "TESA")
(string<? "TEST" "TESA")
'(string<? "TEST" "TESZ")
(string<? "TEST" "TESZ")
'(string<? "test" "tes")
(string<? "test" "tes")
'(string<? "test" "test0")
(string<? "test" "test0")

'(string<=? "test" "test")
(string<=? "test" "test")
'(string<=? "test" "tesa")
(string<=? "test" "tesa")
'(string<=? "test" "tesz")
(string<=? "test" "tesz")
'(string<=? "TEST" "tesa")
(string<=? "TEST" "tesa")
'(string<=? "TEST" "tesz")
(string<=? "TEST" "tesz")
'(string<=? "test" "TESA")
(string<=? "test" "TESA")
'(string<=? "test" "TESZ")
(string<=? "test" "TESZ")
'(string<=? "TEST" "TESA")
(string<=? "TEST" "TESA")
'(string<=? "TEST" "TESZ")
(string<=? "TEST" "TESZ")
'(string<=? "test" "tes")
(string<=? "test" "tes")
'(string<=? "test" "test0")
(string<=? "test" "test0")

'(string=? "abc" "abc")
(string=? "abc" "abc")
'(string=? "aBc" "abc")
(string=? "aBc" "abc")
'(string=? "abc" "abd")
(string=? "abc" "abd")
'(string=? "abc" "abcd")
(string=? "abc" "abcd")
'(string=? "abcd" "abc")
(string=? "abcd" "abc")

'(string>? "test" "test")
(string>? "test" "test")
'(string>? "test" "tesa")
(string>? "test" "tesa")
'(string>? "test" "tesz")
(string>? "test" "tesz")
'(string>? "TEST" "tesa")
(string>? "TEST" "tesa")
'(string>? "TEST" "tesz")
(string>? "TEST" "tesz")
'(string>? "test" "TESA")
(string>? "test" "TESA")
'(string>? "test" "TESZ")
(string>? "test" "TESZ")
'(string>? "TEST" "TESA")
(string>? "TEST" "TESA")
'(string>? "TEST" "TESZ")
(string>? "TEST" "TESZ")
'(string>? "test" "tes")
(string>? "test" "tes")
'(string>? "test" "test0")
(string>? "test" "test0")

'(string>=? "test" "test")
(string>=? "test" "test")
'(string>=? "test" "tesa")
(string>=? "test" "tesa")
'(string>=? "test" "tesz")
(string>=? "test" "tesz")
'(string>=? "TEST" "tesa")
(string>=? "TEST" "tesa")
'(string>=? "TEST" "tesz")
(string>=? "TEST" "tesz")
'(string>=? "test" "TESA")
(string>=? "test" "TESA")
'(string>=? "test" "TESZ")
(string>=? "test" "TESZ")
'(string>=? "TEST" "TESA")
(string>=? "TEST" "TESA")
'(string>=? "TEST" "TESZ")
(string>=? "TEST" "TESZ")
'(string>=? "test" "tes")
(string>=? "test" "tes")
'(string>=? "test" "test0")
(string>=? "test" "test0")

'(sublist alist '(((+ vi vii) (- x ix)) ((* ii iii) (/ viii iv))))
(sublist alist '(((+ vi vii) (- x ix)) ((* ii iii) (/ viii iv))))
'(sublist alist '())
(sublist alist '())
'(sublist '() '(((+ vi vii) (- x ix)) ((* ii iii) (/ viii iv))))
(sublist '() '(((+ vi vii) (- x ix)) ((* ii iii) (/ viii iv))))

'(subst '(x x) '(j k) clist1)
(subst '(x x) '(j k) clist1)
'(subst '(x x) '(j k) xlist)
(subst '(x x) '(j k) xlist)
'(subst '(x x) '(j k) '())
(subst '(x x) '(j k) '())
'(subst '() 'xxx xlist)
(subst '() 'xxx xlist)

'(substring "" 0 0)
(substring "" 0 0)
'(substring "abc" 0 0)
(substring "abc" 0 0)
'(substring "abc" 0 1)
(substring "abc" 0 1)
'(substring "abc" 0 2)
(substring "abc" 0 2)
'(substring "abc" 0 3)
(substring "abc" 0 3)
'(substring "abc" 1 1)
(substring "abc" 1 1)
'(substring "abc" 1 2)
(substring "abc" 1 2)
'(substring "abc" 1 3)
(substring "abc" 1 3)
'(substring "abc" 2 2)
(substring "abc" 2 2)
'(substring "abc" 2 3)
(substring "abc" 2 3)
'(substring "abc" 3 3)
(substring "abc" 3 3)
'(substring "abc" 3 4)
(substring "abc" 3 4)
'(substring "abc" 4 5)
(substring "abc" 4 5)
'(substring "abc" 4 3)
(substring "abc" 4 3)

'(sum 1 100)
(sum 1 100)
'(sum +1 +100)
(sum +1 +100)
'(sum 50 100)
(sum 50 100)
'(sum -1 -10)
(sum -1 -10)
'(sum 10 1)
(sum 10 1)

'(tail? () '(a b c))
(tail? () '(a b c))
'(tail? '(d e f) '(a b c d e f))
(tail? '(d e f) '(a b c d e f))
'(tail? '(a b c) '(a b c))
(tail? '(a b c) '(a b c))
'(tail? '((b) (c) (d)) '((a) (b) (c) (d)))
(tail? '((b) (c) (d)) '((a) (b) (c) (d)))
'(tail? '(d e f g) '(a b c d e f))
(tail? '(d e f g) '(a b c d e f))

'(union set1 set2)
(union set1 set2)
'(union set1 '())
(union set1 '())
'(union '() set2)
(union '() set2)

'(unique (append set1 set1))
(unique (append set1 set1))
'(unique xlist)
(unique xlist)
'(unique (append nlist nlist))
(unique (append nlist nlist))
'(unique '())
(unique '())

'(unsort '(1) 1)
(unsort '(1) 1)
'(unsort (iota 1 10) 3)
(unsort (iota 1 10) 3)

'(zero? 0)
(zero? 0)
'(zero? 1)
(zero? 1)
'(zero? +0)
(zero? +0)
'(zero? -0)
(zero? -0)

