BEGIN	{
	lineno = 0
	Nmodels = 0
	SrcDir = "../vol2/library/"
	i = 0
	fmap[i, "name"] = "+"; fmap[i++, "file"] = "plus";
	fmap[i, "name"] = "-"; fmap[i++, "file"] = "minus";
	fmap[i, "name"] = "*"; fmap[i++, "file"] = "times";
	fmap[i, "name"] = "<"; fmap[i++, "file"] = "less";
	fmap[i, "name"] = ">"; fmap[i++, "file"] ="greater";
	fmap[i, "name"] = "<="; fmap[i++, "file"] = "lteq";
	fmap[i, "name"] = ">="; fmap[i++, "file"] = "gteq";
	fmap[i, "name"] = "n+"; fmap[i++, "file"] = "nplus";
	fmap[i, "name"] = "n-"; fmap[i++, "file"] = "nminus";
	fmap[i, "name"] = "n*"; fmap[i++, "file"] = "ntimes";
	fmap[i, "name"] = "n<"; fmap[i++, "file"] = "nless";
	fmap[i, "name"] = "n>"; fmap[i++, "file"] = "ngreater";
	fmap[i, "name"] = "n<="; fmap[i++, "file"] = "nlteq";
	fmap[i, "name"] = "n>="; fmap[i++, "file"] = "ngteq";
	fmap[i, "name"] = "="; fmap[i++, "file"] = "equal";
	fmap[i, "name"] = "char=?"; fmap[i++, "file"] = "ceqp";
	fmap[i, "name"] = "char<?"; fmap[i++, "file"] = "cltp";
	fmap[i, "name"] = "char>?"; fmap[i++, "file"] = "cgtp";
	fmap[i, "name"] = "char<=?"; fmap[i++, "file"] = "clep";
	fmap[i, "name"] = "char>=?"; fmap[i++, "file"] = "cgep";
	fmap[i, "name"] = "char-lower-case?";
		fmap[i++, "file"] = "c-lower-casep";
	fmap[i, "name"] = "char-upper-case?";
		fmap[i++, "file"] = "c-upper-casep";
	fmap[i, "name"] = "char-ci=?"; fmap[i++, "file"] = "c-cieqp";
	fmap[i, "name"] = "char-ci<?"; fmap[i++, "file"] = "c-ciltp";
	fmap[i, "name"] = "char-ci>?"; fmap[i++, "file"] = "c-cigtp";
	fmap[i, "name"] = "char-ci<=?"; fmap[i++, "file"] = "c-cilep";
	fmap[i, "name"] = "char-ci>=?"; fmap[i++, "file"] = "c-cigep";
	fmap[i, "name"] = "string=?"; fmap[i++, "file"] = "seqp";
	fmap[i, "name"] = "string<?"; fmap[i++, "file"] = "sltp";
	fmap[i, "name"] = "string>?"; fmap[i++, "file"] = "sgtp";
	fmap[i, "name"] = "string<=?"; fmap[i++, "file"] = "slep";
	fmap[i, "name"] = "string>=?"; fmap[i++, "file"] = "sgep";
	fmap[i, "name"] = "string-ci=?"; fmap[i++, "file"] = "s-cieqp";
	fmap[i, "name"] = "string-ci<?"; fmap[i++, "file"] = "s-ciltp";
	fmap[i, "name"] = "string-ci<=?"; fmap[i++, "file"] = "s-cilep";
	fmap[i, "name"] = "string-ci>?"; fmap[i++, "file"] = "s-cigtp";
	fmap[i, "name"] = "string-ci>=?"; fmap[i++, "file"] = "s-cigep";
	fmap[i, "name"] = "string->number";
		fmap[i++, "file"] = "strtonum";
	fmap[i, "name"] = "number->string";
		fmap[i++, "file"] = "numtostr";
	fmap[i, "name"] = "char-alphabetic?";
		fmap[i++, "file"] = "c-alphabeticp";
	fmap[i, "name"] = "char-numeric?";
		fmap[i++, "file"] = "c-numericp";
	fmap[i, "name"] = "any?"; fmap[i++, "file"] = "anyp";
	fmap[i, "name"] = "boolean?"; fmap[i++, "file"] = "booleanp";
	fmap[i, "name"] = "char-whitespace?";
		fmap[i++, "file"] = "c-whitespacep";
	fmap[i, "name"] = "equal?"; fmap[i++, "file"] = "equalp";
	fmap[i, "name"] = "even?"; fmap[i++, "file"] = "evenp";
	fmap[i, "name"] = "every?"; fmap[i++, "file"] = "everyp";
	fmap[i, "name"] = "head?"; fmap[i++, "file"] = "headp";
	fmap[i, "name"] = "list?"; fmap[i++, "file"] = "listp";
	fmap[i, "name"] = "natural?"; fmap[i++, "file"] = "naturalp";
	fmap[i, "name"] = "negative?"; fmap[i++, "file"] = "negativep";
	fmap[i, "name"] = "neq?"; fmap[i++, "file"] = "neqp";
	fmap[i, "name"] = "non-negative?";
		fmap[i++, "file"] = "non-negativep";
	fmap[i, "name"] = "not-equal?"; fmap[i++, "file"] = "not-equalp";
	fmap[i, "name"] = "odd?"; fmap[i++, "file"] = "oddp";
	fmap[i, "name"] = "one?"; fmap[i++, "file"] = "onep";
	fmap[i, "name"] = "ordered?"; fmap[i++, "file"] = "orderedp";
	fmap[i, "name"] = "positive?"; fmap[i++, "file"] = "positivep";
	fmap[i, "name"] = "tail?"; fmap[i++, "file"] = "tailp";
	fmap[i, "name"] = "zero?"; fmap[i++, "file"] = "zerop";
	fmap[i, "name"] = "string-length"; fmap[i++, "file"] = "s-length";
	fmap[i, "name"] = "string-append"; fmap[i++, "file"] = "s-append";
	fmap[i, "name"] = "string-downcase"; fmap[i++, "file"] = "s-downcase";
	fmap[i, "name"] = "string-upcase"; fmap[i++, "file"] = "s-upcase";
	fmap[i, "name"] = "string-ref"; fmap[i++, "file"] = "s-ref";
	fmap[i, "name"] = "char-downcase"; fmap[i++, "file"] = "c-downcase";
	fmap[i, "name"] = "char-upcase"; fmap[i++, "file"] = "c-upcase";
	fmap[i, "name"] = "null?"; fmap[i++, "file"] = "nullp";
	Nfmap = i;
	i = 0;
	pmap[i++] = "bottom"
	pmap[i++] = "define"
	pmap[i++] = "lambda"
	pmap[i++] = "let"
	pmap[i++] = "letrec"
	pmap[i++] = "package"
	pmap[i++] = "quote"
	pmap[i++] = "recursive-bind"
	pmap[i++] = "void"
	pmap[i++] = "and"
	pmap[i++] = "apply"
	pmap[i++] = "begin"
	pmap[i++] = "call/cc"
	pmap[i++] = "cond"
	pmap[i++] = "or"
	pmap[i++] = "car"
	pmap[i++] = "cdr"
	pmap[i++] = "cons"
	pmap[i++] = "char?"
	pmap[i++] = "eq?"
	pmap[i++] = "null?"
	pmap[i++] = "number?"
	pmap[i++] = "pair?"
	pmap[i++] = "procedure?"
	pmap[i++] = "string?"
	pmap[i++] = "symbol?"
	pmap[i++] = "char->integer"
	pmap[i++] = "integer->char"
	pmap[i++] = "integer->list"
	pmap[i++] = "list->integer"
	pmap[i++] = "list->string"
	pmap[i++] = "string->list"
	pmap[i++] = "string->symbol"
	pmap[i++] = "symbol->string"
	pmap[i++] = "char-ci<?"
	pmap[i++] = "char-ci=?"
	pmap[i++] = "char<?"
	pmap[i++] = "char=?"
	pmap[i++] = "n+"
	pmap[i++] = "n-"
	pmap[i++] = "n<"
	pmap[i++] = "string-append"
	pmap[i++] = "string-length"
	pmap[i++] = "string-ref"
	pmap[i++] = "substring"
	pmap[i++] = "delete-file"
	pmap[i++] = "display"
	pmap[i++] = "eof-object?"
	pmap[i++] = "read"
	pmap[i++] = "read-char"
	pmap[i++] = "with-input-from-file"
	pmap[i++] = "with-output-to-file"
	pmap[i++] = "write"
	Npmap = i;
	}
function endsection() {
	if (lineno == 0) {
		/* skip */
	}
	else if (substr(lines[0], 1, 8) == ":require" || \
		substr(lines[0], 1, 8) == ";require" \
	) {
		y = 0
		for (x=0; x<lineno; x++) {
			if (index(lines[x], "/") != 0)
				libs[y,"name"] = substr(lines[x],
					index(lines[x], "/")+1)
			else
				libs[y,"name"] = substr(lines[x],
					index(lines[x], " ")+1)
			libs[y,"name"] = substr(libs[y,"name"], 1,
				index(libs[y,"name"], ".")-1)
			libs[y,"file"] = tolower(libs[y,"name"])
			k = 10
			while (index(substr(lines[x], k), " ") != 0) {
				y++
				libs[y,"file"] = libs[y-1,"file"]
				k += index(substr(lines[x], k), " ")
				libs[y,"name"] = substr(lines[x], k)
				if (index(libs[y,"name"], " ") != 0)
					libs[y,"name"] = \
						substr(libs[y,"name"], 1,
						index(libs[y,"name"], " ")-1)
			}
			y++
		}
		Nlibs = y
	}
	else if (lines[0] == "---name---") {
		y = 0
		MyName = lines[1];
		gsub("&", "\\&amp;", MyName)
		gsub("<", "\\&lt;", MyName)
		gsub(">", "\\&gt;", MyName)
	}
	else if (lines[0] == "---conformance---") {
		Conformance = lines[1]
		Nres = 0
		x = 2
		while (x < lineno) {
			Restrictions[Nres++] = lines[x++]
		}
	}
	else if (lines[0] == "---purpose---") {
		y = 0
		for (x=1; x<lineno; x++)
			if (lines[x] != ";") purpose[y++] = lines[x]
		Npurpose = y
	}
	else if (lines[0] == "---args---") {
		Nargs = 0
		for(x=1; x<lineno; x++) {
			desc = index(lines[x], " - ")
			if (desc != 0) {
				args[Nargs,"name"] = substr(lines[x], 1, desc-1)
				args[Nargs,"desc"] = substr(lines[x], desc+3)
				Nargs++
			}
			else {
				while (substr(lines[x], 1, 1) == " ")
					lines[x] = substr(lines[x], 2)
				args[Nargs-1,"desc"] = \
					args[Nargs-1,"desc"] "\n" lines[x]
			}
		}
	}
	else if (lines[0] == "---keywords---") {
		for (x=1; x<lineno; x++) keywords[x-1] = lines[x]
		Nkwords = x-1
	}
	else if (lines[0] == "---see-also---") {
		for (x=1; x<lineno; x++) refs[x-1] = lines[x]
		Nrefs = x-1
	}
	else if (lines[0] == "---model---") {
		for (x=1; x<lineno; x++)
			if (lines[x] != ";")
				model[Nmodels,x-1] = lines[x]
			else
				model[Nmodels,x-1] = ""
		model[Nmodels,len] = x-1
		Nmodels++
	}
	else if (lines[0] == "---example---") {
		for (x=1; x<lineno; x++)
			if (lines[x] != ";")
				example[x-1] = lines[x]
			else
				example[x-1] = ""
		Nexam = x-1
	}
	else if (lines[0] == "---code---") {
		for (x=1; x<lineno; x++) code[x-1] = lines[x]
		Ncode = x-1
	}
	lineno = 0
	}
/^$/	{
	if (lines[0] != "---code---") {
		endsection()
		next
	}
	}
	{
	lines[lineno++] = $0
	}
function writemenu() {
	print  "<TABLE class=menu>"
	print  " <TR>"
	print  "  <TD align=center>"
	print  "   [<A href=\"index.html\">&nbsp;Index&nbsp;</A>]"
	print  "  </TD>"
	print  " </TR>"
	print  "</TABLE>"
	}
function writeprolog() {
	system("cat util/srchdr")
	print ""
	writemenu()
	print ""
	printf "<H2><A name=\"%s-function\" class=idx>%s</A></H2>\n", \
		MyName, MyName
	print ""
	printf "<P><B>Conformance:</B> %s\n", Conformance
	if (Nres > 0) {
		printf "(<B>Restrictions:</B> "
		for (x=0; x<Nres; x++) print Restrictions[x]
		printf ")"
	}
	print "</P>"
	print ""
	}
function writedesc() {
	print "<P><B>Purpose:</B>"
	for (x=0; x<Npurpose; x++) {
		if (purpose[x] == "-") {
			printf "   <BR>\n"
		}
		else if (purpose[x] == "--") {
			printf "   <BR>&nbsp;<BR>\n"
		}
		else {
			gsub("&", "\\&amp;", purpose[x])
			gsub("<", "\\&lt;", purpose[x])
			gsub(">", "\\&gt;", purpose[x])
			printf "   %s\n", purpose[x]
		}
	}
	print "</P>"
	if (Nargs > 0) {
		print "<P><B>Arguments:</B><BR>"
		for (x=0; x<Nargs; x++) {
			gsub("&", "\\&amp;", args[x,"desc"])
			gsub("<", "\\&lt;", args[x,"desc"])
			gsub(">", "\\&gt;", args[x,"desc"])
			printf "   <B>%s</B> - %s", \
				args[x,"name"], args[x,"desc"]
			print (x<Nargs-1)? "<BR>": ""
		}
		print "</P>"
	}
	}
function identifier(str) {
	return index("abcdefghijklmnopqrstuvwxyz+-*/<=>?#\\", str) != 0
	}
function printcode(line) {
	semi = index(line, ";")
	for (j=0; j<Nlibs; j++) {
		pos = 1
		while (1) {
			k = index(substr(line, pos), libs[j,"name"])
			pos += k
			if (k <= 0) break
			k = pos-1
			l = length(libs[j,"name"])
			if (k > 0) {
				c = substr(line, k+l, 1)
				if (identifier(c)) k = 0;
				if (k > 1) {
					c = substr(line, k-1, 1)
					if (identifier(c)) k = 0;
				}
			}
			if (k > 0) break
		}
		if (semi > 0 && k >= semi) k = 0
		if (l != 0 && k > 0) {
			s1 = substr(line, 1, k-1)
			href = sprintf(\
		"{{A class=\"funref\" href=\"%s.html\"}}%s{{/A}}", \
				fileref(libs[j,"file"]), libs[j,"name"])
			s2 = substr(line, k+l)
			line = s1 href s2
			libs[j,"name"] = "?" libs[j,"name"]
		}
	}
	for (j=0; j<Npmap; j++) {
		pos = 1
		while (1) {
			k = index(substr(line, pos), pmap[j])
			pos += k
			if (k <= 0) break
			k = pos-1
			l = length(pmap[j])
			if (k > 0) {
				c = substr(line, k+l, 1)
				if (identifier(c)) k = 0;
				if (k > 1) {
					c = substr(line, k-1, 1)
					if (identifier(c)) k = 0;
				}
			}
			if (k > 0) break
		}
		if (semi > 0 && k >= semi) k = 0
		if (l != 0 && k > 0) {
			s1 = substr(line, 1, k-1)
			href = sprintf(\
		 "{{A class=\"primref\" href=\"../sk04.html#%s\"}}%s{{/A}}",\
				pmap[j], pmap[j])
			s2 = substr(line, k+l)
			line = s1 href s2
			pmap[j] = "?" pmap[j]
		}
	}
	k = index(line, ";")
	if (k > 0) {
		s1 = substr(line, 1, k)
		s2 = substr(line, k+1)
		line = s1 "{{I class=comment}}" s2 "{{/I}}"
	}
	gsub("&", "\\&amp;", line)
	gsub("<", "\\&lt;", line)
	gsub(">", "\\&gt;", line)
	gsub("{{", "<", line)
	gsub("}}", ">", line)
	print line
	}
function writecode(prog, len, title) {
	printf "<P><B>%s:</B></P>\n", title
	print "<PRE>"
	for (x=0; x<len; x++) {
		printcode(prog[x])
	}
	print "</PRE>"
	for (j=0; j<Nlibs; j++) {
		if (substr(libs[j,"name"], 1, 1) == "?")
			libs[j,"name"] = substr(libs[j,"name"], 2)
	}
	for (j=0; j<Npmap; j++) {
		if (substr(pmap[j], 1, 1) == "?")
			pmap[j] = substr(pmap[j], 2)
	}
	}
function write_interactive_exam(prog, len) {
	print "<FORM method=get action=\"http://sketchy.dyndns.org/lisp/index.cgi\">"
	print " <P><B>Example:</B></P>"
	print " <PRE class=example>"
	for (x=0; x<len; x++) {
		gsub("&", "\\&amp;", prog[x])
		gsub("<", "\\&lt;", prog[x])
		gsub(">", "\\&gt;", prog[x])
		if (substr(prog[x], 1, 1) != ":") print(prog[x])
	}
	print "</PRE>"
	print " <INPUT class=eval type=submit value=\"Evaluate\">"
	for (x=0; x<len; x++)
		if (substr(prog[x], 1, 1) != ":") break;
	pg = substr(prog[x], 1, index(prog[x], "=&gt;")-2)
	gsub("\"", "\\&quot;", pg)
	printf " <INPUT type=hidden name=expr value=\"%s\">", pg
	print "</FORM>"
	for (j=0; j<Nlibs; j++) {
		if (substr(libs[j,"name"], 1, 1) == "?")
			libs[j,"name"] = substr(libs[j,"name"], 2)
	}
	}
function writeexam(prog, len) {
	print " <P><B>Example:</B></P>"
	print " <PRE class=example>"
	for (x=0; x<len; x++) {
		gsub("&", "\\&amp;", prog[x])
		gsub("<", "\\&lt;", prog[x])
		gsub(">", "\\&gt;", prog[x])
		if (substr(prog[x], 1, 1) != ":") print(prog[x])
	}
	print "</PRE>"
	for (x=0; x<len; x++)
		if (substr(prog[x], 1, 1) != ":") break;
	pg = substr(prog[x], 1, index(prog[x], "=&gt;")-2)
	gsub("\"", "\\&quot;", pg)
	for (j=0; j<Nlibs; j++) {
		if (substr(libs[j,"name"], 1, 1) == "?")
			libs[j,"name"] = substr(libs[j,"name"], 2)
	}
	}
function writeepilog() {
	print ""
	writemenu()
	print ""
	print "</BODY>"
	print "</HTML>"
	}
function fileref(filename) {
	tolower(filename)
	pfx = substr(filename, 1, length(filename)-1)
	sfx = substr(filename, length(filename))
	for (i=0; i<Nfmap; i++) {
		if (fmap[i, "name"] == filename)
			return fmap[i, "file"]
	}
	return sfx == "?"? pfx"p": filename
}
function nameref(filename) {
	for (i=0; i<Nfmap; i++) {
		if (fmap[i, "file"] == filename)
			return fmap[i, "name"]
	}
	return filename
}
function writerefs() {
	if (Nrefs) {
		print "<P><B>See also:</B><BR>"
		for (x=0; x<Nrefs; x++) {
			for (comma=1; comma != 0; ) {
				comma = index(refs[x], ",")
				if (comma != 0) {
					ref = substr(refs[x], 1, comma-1)
					refs[x] = substr(refs[x], comma+2)
				}
				else {
					ref = refs[x]
				}
				href=ref
				gsub("&", "\\&amp;", href)
				gsub("<", "\\&lt;", href)
				gsub(">", "\\&gt;", href)
				printf "<A href=\"%s.html\"><TT>%s</TT></A>", \
					tolower(fileref(ref)), href
				if (comma != 0 || x < Nrefs-1)
					printf "<TT>,</TT>\n"
			}
		}
		print "<TT>.</TT>\n</P>"
	}
	}
function writetmpl() {
		writeprolog()
		writedesc()
		for (mod=0; mod<Nmodels; mod++) {
			for (lns=0; lns<model[mod,len]; lns++)
				mcode[lns] = model[mod,lns]
			writecode(mcode, model[mod,len], "Model")
		}
		writecode(code, Ncode, "Implementation")
		if (Nexam) writeexam(example, Nexam)
		writerefs()
		writeepilog()
	}
END	{
	endsection()
	writetmpl()
	}
