:l src/read-line.l

(define (copy-pre from to)
  (with-input-from-file from
    (lambda ()
      (with-output-to-file to
	extract-pre))))

(define (extract-pre)
  (letrec
    ((writeln (lambda (ln)
      (begin (display ln)
        (newline))))
    (readln (lambda (ln pass)
      (letrec ((k (cond ((string? ln) (string-length ln))
                    (#t 0))))
        (cond ((eof-object? ln) ln)
          ((and (> k 11)
                (string=? (substring ln 0 4) "<PRE")
                (string=? (substring ln (- k 6) k) "</PRE>"))
            (begin (writeln ln)
	      (newline)
              (readln (read-line) #f)))
          ((and (> k 3)
                (string=? (substring ln 0 4) "<PRE"))
            (begin (writeln ln)
              (readln (read-line) #t)))
          ((and (> k 5)
                (string=? (substring ln 0 6) "</PRE>"))
            (begin (writeln "</PRE>")
	      (newline)
              (readln (read-line) #f)))
          (#t (begin (cond (pass (writeln ln)) (#t #f))
                (readln (read-line) pass))))))))
  (readln (read-line) #f)))

