; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---purpose---
; Solve the N-queens problem using backtracking
; and pretty-print the solution.

; ---args---
; N - number of queens.

; ---keywords---
; VQUEENS function, queens, eight queens, N queens, N-queens, example

; ---example---
; (vqueens 4) => done

:require queens.l
;c lib/zerop.l zero?
;c lib/newline.l
;c lib/minus.l -
;c lib/remainder.l

; ---code---
(define (vqueens board-size)
  (letrec

    ((print-dots (lambda (n)
      (cond ((zero? n) ())
        (#t (begin
              (display " .")
              (print-dots (- n 1)))))))

    (print-row (lambda (n)
      (begin
        (print-dots n)
        (display " &")
        (print-dots (- board-size n 1))
        (newline))))

    (print-board (lambda (b)
      (cond ((null? b) 'done)
        (#t (begin
              (print-row
                (remainder (car b) board-size))
              (print-board (cdr b))))))))

    (print-board (queens board-size))))

