; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; unsort

; ---conformance---
; Sketchy Extension

; ---purpose---
; Generate some entropy by un-sorting a list of
; natural numbers. The order of the list A is
; changed in a hard to predict way by extracting
; the (N mod length[A])'th element from A and
; consing it to B. Each extracted element is
; removed from A. When A is empty, the result
; is in B.

; ---args---
; A - list to unsort
; SEED - first element to arrange, where 0<SEED<=length[A]

; ---keywords---
; UNSORT function, entropy, order, sorting, unsorting, random

; ---see-also---
; sort, insert, ordered?

; ---example---
; :l src/iota.l
; (unsort (iota 1 5) 3) => (3 2 5 1 4)

;c lib/digits.l
;c lib/length.l
;c lib/zerop.l zero?
;c lib/nremainder.l
;c lib/list-ref.l

; ---code---
(define (unsort a seed)
  (letrec

    ; Generate a list with the n'th element removed
    ((nonth (lambda (a n r)
      (cond ((zero? n) 
          (cond ((null? a)
              (reverse r))
            (#t (append (cdr a)
              (reverse r)))))
        (#t (nonth (cdr a) (n- n 1)
        (cons (car a) r))))))

    ; Unsort list A of length K
    ; N = element to extract
    ; R = intermediate result
    (usrt (lambda (a n k r)
      (cond ((zero? k) (cons (car a) r))
        (#t (usrt (nonth a n '())
              (nremainder (car a) k)
              (n- k 1)
              (cons (list-ref a n) r)))))))

    (usrt a seed (n- (length a) 1) '())))

