; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---purpose---
; Convert a LET into an equivalent LAMBDA expression.
; --
; This program proves that any LET can be converted
; into an equivalent LAMBDA expression by automating
; this process.
; --
; Note: This version actually replaces LETREC with
; LAMBDA, because Sketchy does not have LET. The
; conversion breaks recursive definitions, of course.

; ---args---
; X - expression to convert

; ---keywords---
; LABEL, LAMBDA, scoping, example

; ---example---
; (unlabel '(letrec ((a 5) (b 7)) (+ a b))) => ((lambda (a b) (+ a b)) 5 7)

;c lib/list.l
;c lib/reverse.l
;c lib/append.l
;c lib/caar.l cadr
;c lib/caaar.l caddr cadar
;c lib/booleanp.l boolean?

; ---code---
(define unlabel (lambda (x)
  (letrec

    ; Create list of symbols to bind in LABEL
    ((symlist (lambda (x r)
      (cond ((null? x) (reverse r))
        (#t (symlist (cdr x) (cons (caar x) r))))))

    ; Create list of (unlabeled) values to bind
    (vallist (lambda (x r)
      (cond ((null? x) (reverse r))
        (#t (vallist (cdr x)
              (cons (_unlabel (cadar x)) r))))))

    ; Extract (unlabeled) term of label
    (term (lambda (x)
      (_unlabel (caddr x))))

    ; Create lambda expression
    (make-lambda (lambda (x)
      (append
        (list (list 'lambda (symlist (cadr x) '()) (term x)))
        (vallist (cadr x) '()))))

    ; Traverse expression tree, replacing letrecs with lambda
    (_unlabel (lambda (x)
      (cond ((symbol? x) x)
        ((null? x) x)
        ((number? x) x)
        ((char? x) x)
        ((string? x) x)
        ((boolean? x) x)
        ((eq? (car x) 'quote) x)
        ((eq? (car x) 'letrec) (make-lambda x))
        (#t (cons (_unlabel (car x))
            (_unlabel (cdr x))))))))

    (_unlabel x))))

