; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; unique

; ---conformance---
; Sketchy Extension

; ---purpose---
; Transform a list into a set (a list containing
; only unique elements).

; ---args---
; A - list

; ---keywords---
; UNIQUE function, unique, sets, set theory, lists

; ---see-also---
; intersection, union, member, remove, any?

; ---example---
; (unique '(a b b c d a)) => (a b c d)

;c lib/reverse.l
;c lib/member.l

; ---model---
; (define unique (lambda (a)
;   (cond ((null? a) a)
;     ((member (car a) (cdr a)) (unique (cdr a)))
;     (#t (cons (car a) (unique (cdr a)))))))

; ---code---
(define (unique a)
  (letrec
    ((_unique (lambda (a r)
      (cond ((null? a) (reverse r))
        ((member (car a) r) (_unique (cdr a) r))
        (#t (_unique (cdr a) (cons (car a) r)))))))
    (_unique a '())))

