; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; union

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute the union of two sets.
; Sets are represented by lists
; of unique members.

; ---args---
; A - set
; B - set

; ---keywords---
; UNION function, union, sets, set theory

; ---see-also---
; intersection, member, remove, unique, any?

; ---example---
; (union '(a b c) '(b d)) => (a b c d)

(define union #t)

:require unique.l
;c lib/append.l
;c lib/reverse.l
;c lib/member.l

; ---model---
; (define (union a b)
;   (cond ((null? a) b)
;     ((member (car a) b) (union (cdr a) b))
;     (#t (cons (car a) (union (cdr a) b)))))

; ---code---
(define (union a b)
  (unique (append a b)))

