; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; tail?

; ---conformance---
; Sketchy Extension

; ---purpose---
; Check if an expression X is the tail of an
; expression Y.

; ---args---
; X - potential tail
; Y - expression

; ---keywords---
; TAIL? function, list, pair, tail

; ---see-also---
; head?, caar, list?

; ---example---
; (tail? '(d e f) '(a b c d e f)) => #t

;c lib/equalp.l equal?

; ---model---
; (define (tail? x y)
;   (cond ((null? y) (null? x))
;     ((equal? x y) #t)
;     (#t (tailp x (cdr y)))))

; ---code---
(define (tail? x y)
  (letrec
    ((tailp (lambda (y)
      (cond ((null? y) (null? x))
        ((equal? x y) #t)
        (#t (tailp (cdr y)))))))
    (tailp y)))

