; Sketchy Example Program
; Copyright (C) 2005,2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; sum

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute the sum of a sequence of positive numbers.

; ---args---
; N - least value of sequence
; M - maximum value of seqence

; ---keywords---
; SUM function, sum of sequence

; ---see-also---
; digits, nexpt, fact, gcd, product

; ---example---
; (sum 2 5) => 14

(define sum #t)

;c lib/digits.l
;c lib/equal.l =
;c lib/ngreater.l n>
;c lib/natural.l
;c lib/ntimes.l n*
;c lib/nquotient.l

; ---model---
; (define (sum n m)
;   (cond ((= n m) m)
;     (#t (n+ n (sum (n+ n 1) m)))))

; ---code---
(define (sum n m)
  (letrec
    ((nn (natural n))
    (nm (natural m))
    (_sum (lambda (n m)
      (let ((x (n+ 1 (n- m n))))
        (n+ (nquotient (n+ (n* x x) x)
                       2)
            (n* (n- n 1) x))))))
    (cond ((n> nn nm)
        (bottom 'sum-range))
      (#t (_sum nn nm)))))

