; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; subst

; ---conformance---
; Sketchy Extension

; ---purpose---
; Substitute X for each occurence of Y in Z.
; X, Y, Z are S-expressions.

; ---args---
; X - expression to replace Y with
; Y - expression to find
; Z - expression to process

; ---keywords---
; SUBST function, substitution, substitute, lists

; ---see-also---
; member, equal?, sublist

; ---example---
; (subst 'z 'y '(lambda (x y) (x y))) => (lambda (x z) (x z))

;c lib/equalp.l equal?
;c lib/append.l
;c lib/reverse.l
;c lib/caar.l cdar

; ---code---
(define (subst x y z)
  (cond ((equal? y z) x)
    ((pair? z)
      (cons (subst x y (car z))
            (subst x y (cdr z))))
    (#t z)))

