; Sketchy Example Program
; Copyright (C) 2005,2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; sublist

; ---conformance---
; Sketchy Extension

; ---purpose---
; Substitute variables in S-expressions.
; For a description of association lists (alists)
; see ASSOC.

; ---args---
; A - alist with bindings
; X - S-expression to process

; ---keywords---
; SUBLIST function, substitution, substitute variables
; association lists

; ---see-also---
; assoc, subst

; ---example---
; (sublist '((i.1) (ii.2) (iii.3)) '(i + ii - iii)) => (1 + 2 - 3)

;c lib/assoc.l
;c lib/reverse.l
;c lib/caar.l cdar
;c lib/append.l

; ---code---
(define (sublist a x)
  (cond ((null? x) '())
    ((pair? x)
      (cons (sublist a (car x))
        (sublist a (cdr x))))
    (#t (let ((r (assoc x a)))
          (cond (r (cdr r))
            (#t x))))))

