; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; some

; ---conformance---
; Sketchy Extension

; ---purpose---
; Extract the tail of a list where the first
; member of the tail has a given property.
; Evaluate to () if no such member exists.

; ---args---
; A - list
; P - predicate defining property to find

; ---keywords---
; SOME function, property, predicate

; ---see-also---
; any?, every?, member, filter, unique

; ---example---
; (some '(a b c (x.y) d e f) pair?) => ((x . y) d e f)

; ---model---
; (define (some x p)
;   (cond ((null? x) '())
;     ((p (car x)) x)
;     (#t (some (cdr x) p))))

; ---code---
(define (some x p)
  (letrec
    ((_some (lambda (x)
      (cond ((null? x) '())
        ((p (car x)) x)
        (#t (_some (cdr x)))))))
    (_some x)))

