; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; remove

; ---conformance---
; Sketchy Extension

; ---purpose---
; Remove members from lists.

; ---args---
; A - list
; P - predicate to match members to remove

; ---keywords---
; REMOVE function, lists, sets, set theory, member, remove

; ---see-also---
; insert, filter, member, any?

; ---example---
; (remove '(abc 123 def 456 ghi) number?) => (abc def ghi)

(define remove #t)

:require filter.l
;c lib/reverse.l
;c lib/not.l

; ---model---
; (define (remove a p)
;   (cond ((null? a) '())
;     ((p (car a)) (cdr a))
;     (#t (cons (car a) (remove (cdr a) p)))))

; ---code---
(define (remove a p)
  (filter a (lambda (x) (not (p x)))))

