; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; reduce

; ---conformance---
; Sketchy Core

; ---purpose---
; Reduce a list. Combine the first member of the
; list with the reduced rest of the list using a
; given function.

; ---args---
; F - combining function
; A - list to reduce
; X - default member (replaces NIL)

; ---keywords---
; REDUCE function, reduction, reduce lists

; ---see-also---
; map, iterate

; ---example---
; :l lib/plus.l +
; (reduce + '(1 2 3 4) 5) => 15

;c lib/reverse.l

; ---model---
; (define (reduce f a x)
;   (cond ((null? a) x)
;     (#t (f (car a) (reduce f (cdr a) x)))))

; ---code---
(define (reduce f a x)
  (letrec
    ((_reduce (lambda (a b)
      (cond ((null? a) b)
        ((null? b) (_reduce (cdr a) (f (car a) x)))
        (#t (_reduce (cdr a) (f (car a) b)))))))
    (_reduce (reverse a) '())))

