; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; read-line

; ---conformance---
; Sketchy Extension

; ---purpose---
; Read a newline-terminated sequence of characters.
; Return a string containing the characters read.

; ---args---
; none

; ---keywords---
; READ-LINE
; read, line, newline, string

; ---example---
; (read-line) hello world => " hello world "

;c lib/string.l
;c lib/reverse.l

; ---code---
(define (read-line)
  (letrec
    ((collect-chars (lambda (c s)
      (cond ((or (eof-object? c) (char=? c #\newline))
          (apply string (reverse s)))
        (#t (collect-chars (read-char) (cons c s))))))
    (first-char (read-char)))
    (cond ((eof-object? first-char) first-char)
      (#t (collect-chars first-char ())))))

