; Sketchy Example Program
; Copyright (C) 2005,2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; qsort

; ---conformance---
; Sketchy Extension

; ---purpose---
; Sort a list using the Quicksort algorithm.

; ---args---
; A - list to sort
; P - predicate defining the desired order

; ---keywords---
; QSORT function, quick sort, ordering, sorting

; ---see-also---
; sort, isort, ordered?

; ---example---
; (qsort < '(5 1 3 2 4)) => (1 2 3 4 5)

;c lib/list.l
;c lib/append.l
;c lib/reverse.l
;c lib/null.l
;c lib/not.l

; ---code---
(define (qsort p a)
  (letrec
    ((filter (lambda (p a r)
      (cond ((null? a) (reverse r))
        ((p (car a))
          (filter p (cdr a) (cons (car a) r)))
        (#t (filter p (cdr a) r)))))
    (_qsort (lambda (a)
      (cond ((null? a) a)
        (#t (letrec
              ((left-part (lambda (x)
                (lambda (y) (not (p x y)))))
              (right-part (lambda (x)
                (lambda (y) (p x y)))))
              (append
                (_qsort (filter
                          (left-part (car a))
                          (cdr a) ()))
                (list (car a))
                (_qsort (filter
                          (right-part (car a))
                          (cdr a) ())))))))))
    (_qsort a)))

