; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; product

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute the product of a sequence of
; positive numbers.

; ---args---
; N - least value of sequence
; M - maximum value of seqence

; ---keywords---
; PRODUCT function, product of sequence

; ---see-also---
; digits, expt, fact, gcd, sum

; ---example---
; (product 5 7) => 210

(define product #t)

;c lib/digits.l
;c lib/equal.l =
;c lib/ngreater.l n>
;c lib/ntimes.l n*
;c lib/natural.l

; ---model---
; (define (product n m)
;   (cond ((= n m) m)
;     (#t (n* n (product (n+ n 1) m)))))

; ---code---
(define (product n m)
  (letrec
    ((nn (natural n))
    (lim (natural m))
    (prod (lambda (n r)
      (cond ((n> n lim) r)
        (#t (prod (n+ n 1) (n* n r)))))))
    (cond ((n> nn lim)
        (bottom 'product-range))
      (#t (prod nn 1)))))

