; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; permute

; ---conformance---
; Sketchy Extension

; ---purpose---
; Generate permutations of a set.

; ---args---
; X - set

; ---keywords---
; PERMUTE, permutation, combination

; ---see-also---
; unique, member

; ---example---
; (permute '(a b c)) => ((a b c) (a c b) (b c a) (b a c) (c a b) (c b a))

;c lib/list.l
;c lib/append.l
;c lib/map.l

; ---code---
(define (permute x)
  (letrec

    ((rotate (lambda (x)
      (append (cdr x) (list (car x)))))

    (rotations (lambda (x)
      (letrec
        ((rot (lambda (x n)
          (cond ((null? n) '())
            (#t (cons x 
                  (rot (rotate x)
                    (cdr n))))))))
        (rot x x))))

    (permutations (lambda (lst)
      (cond ((null? lst) '())
        ((null? (cdr lst)) (list lst))
        ((null? (cddr lst)) (rotations lst))
        (#t (apply append
              (map (lambda (rotn)
                     (map (lambda (x)
                            (cons (car rotn) x))
                       (permutations (cdr rotn))))
                (rotations lst))))))))

    (permutations x)))

