; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; pair

; ---conformance---
; Sketchy Extension

; ---purpose---
; Build an association list from two lists.

; ---args---
; X - list containing keys
; Y - list containing values

; ---keywords---
; PAIR function, assocation lists, alists, associate

; ---see-also---
; assoc

; ---example---
; (pair '(1 2 3) '(i ii iii)) => ((1 . i) (2 . ii) (3 . iii))

;c lib/map.l

; ---model---
; (define (pair x y)
;   (cond ((null? x) '())
;     ((null? y) '())
;     (#t (cons (cons (car x) (car y))
;         (pair (cdr x) (cdr y))))))

; ---code---
(define (pair x y)
  (map cons x y))

