; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; ordered?

; ---conformance---
; Sketchy Extension

; ---purpose---
; Check whether the members of a list
; are in a given monotonic order.

; ---args---
; X - list
; P - predicate defining order

; ---keywords---
; ORDERED? function, ordered, ordering, relation
; lists, predicate

; ---see-also---
; insert, sort, unsort

; ---example---
; :l lib/greater.l >
; (ordered? '(9 8 7 6 5) >) => #t

;c lib/caar.l cadr

; ---model---
; (define (ordered? x p)
;   (cond ((null? x) #t)
;     ((null? (cdr x)) #t)
;     ((p (car x) (cadr x)) (orderedp (cdr x) p))
;     (#t #f)))

; ---code---
(define (ordered? x p)
  (letrec
    ((ordererdp (lambda (x)
      (cond ((null? x) #t)
        ((null? (cdr x)) #t)
        ((p (car x) (cadr x))
          (ordererdp (cdr x)))
        (#t #f)))))
    (ordererdp x)))

