; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; not-equal?

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compare two lists (S-expressions, in fact)
; with negative result.

; ---args---
; A - expression
; B - expression

; ---keywords---
; NOT-EQUAL? function, negative equivalence, relation, comparison
; predicate

; ---see-also---
; equal?, neq?

; ---example---
; (not-equal? '(a b (c d (e)) f) '(a b (c d (x)) f)) => #t

;c lib/equalp.l equal?

; ---code---
(define (not-equal? a b)
  (eq? (equal? a b) #f))

