; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; maplist

; ---conformance---
; Sketchy Extension

; ---purpose---
; Apply a function to each CDR of a list.

; ---args---
; A - list
; F - function to apply to each sublist

; ---keywords---
; MAPLIST function, mapping, lists, CDR

; ---see-also---
; map, reduce

; ---example---
; (maplist '(a b c) reverse) => ((c b a) (c b) (c))

;c lib/reverse.l

; ---model---
; (define (maplist a f)
;   (cond ((null? #t) b)
;     (#t (cons (f (cdr a)) (maplist (cdr a) f)))))

; ---code---
(define (maplist a f)
  (letrec
    ((_maplist (lambda (a b)
      (cond ((null? a) (reverse b))
        (#t (_maplist (cdr a) (cons (f a) b)))))))
    (_maplist a '())))

