; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; isort

; ---conformance---
; Sketchy Extension

; ---purpose---
; Sort a list using insertion sort. A predicate is
; used to define the desired order of members. It
; should return #T for each two members in the
; desired order.

; ---args---
; A - list to sort
; P - predicate

; ---keywords---
; ISORT function, sorting, ordering, insertion sort

; ---see-also---
; insert, sort, quicksort, orderedp

; ---example---
; (isort '(5 1 3 2 4) <) => (1 2 3 4 5)

:require insert.l

; ---model---
; (define isort (lambda (a p)
;   (cond ((null? a) '())
;     (#t (insert (car a) (isort (cdr a) p) p)))))

; ---code---
(define (isort a p)
  (letrec
    ((_isort (lambda (a r)
      (cond ((null? a) r)
        (#t (_isort (cdr a)
              (insert (car a) r p)))))))
    (_isort a '())))

